<?php
/**
 * Register custom style.
 */

if ( ! function_exists( 'veliki_custom_style' ) ) {
    function veliki_custom_style(){
        
        $custom_style ='';
        global $veliki_opt;

        if( isset( $veliki_opt['primary_color'] ) ):
            $primary_color              = $veliki_opt['primary_color'];
            $secondary_color            = $veliki_opt['secondary_color'];
            $footer_bg                  = $veliki_opt['footer_bg'];
            $footer_bottom_bg           = $veliki_opt['footer_bottom_bg'];
            $top_header_textcolor       = $veliki_opt['top_header_textcolor'];
            $top_header_iconcolor       = $veliki_opt['top_header_iconcolor'];
            $nav_item                   = $veliki_opt['nav_item'];
            $text_color                 = $veliki_opt['text_color'];
            $preloader_bg               = $veliki_opt['preloader_bgcolor'];
            $preloader_imgbg            = $veliki_opt['preloader_imgbgcolor'];
            $footer_text_color          = $veliki_opt['footer_top_textcolor'];
            $footer_text_hover          = $veliki_opt['footer_top_texthover'];
            $footer_btext_color         = $veliki_opt['footer_bottom_textcolor'];
            $footer_btext_hover         = $veliki_opt['footer_bottom_texthover'];

            $grad_color1 = $veliki_opt['grad_color1'];
            $grad_color2 = $veliki_opt['grad_color2'];
            $grad_color3 = $veliki_opt['grad_color3'];
            $grad_color4 = $veliki_opt['grad_color4'];
            $grad_color5 = $veliki_opt['grad_color5'];

            $opt_grad_color1 = $veliki_opt['opt_grad_color1'];
            $opt_grad_color2 = $veliki_opt['opt_grad_color2'];
            $opt_grad_color3 = $veliki_opt['opt_grad_color3'];
            $opt_grad_color4 = $veliki_opt['opt_grad_color4'];
            $opt_grad_color5 = $veliki_opt['opt_grad_color5'];

            $nav_grad_color1 = $veliki_opt['nav_grad_color1'];
            $nav_grad_color2 = $veliki_opt['nav_grad_color2'];
            $nav_grad_color3 = $veliki_opt['nav_grad_color3'];
            $nav_grad_color4 = $veliki_opt['nav_grad_color4'];
            $nav_grad_color5 = $veliki_opt['nav_grad_color5'];
        else:   
            $primary_color              = '#074ece';
            $secondary_color            = '#4ac728';
            $footer_bg                  = '#182c51';
            $footer_bottom_bg           = '#0d1d3b';
            $top_header_textcolor       = '#ffffff';
            $top_header_iconcolor       = '#4ac728';
            $nav_item                   = '#fff';
            $text_color                 = '#57647c';
            $preloader_bg               = '#074ece';
            $preloader_imgbg            = '#ffffff';
            $footer_text_color          = '#ffffff';
            $footer_text_hover          = '#4ac728';
            $footer_btext_color         = '#ffffff';
            $footer_btext_hover         = '#4ac728';

            $grad_color1 = '#0030b8';
            $grad_color2 = '#003cc1';
            $grad_color3 = '#0047c9';
            $grad_color4 = '#0152d0';
            $grad_color5 = '#0a5dd8';

            $opt_grad_color1 = '#49c628';
            $opt_grad_color2 = '#53d23c';
            $opt_grad_color3 = '#5ddd4e';
            $opt_grad_color4 = '#66e95f';
            $opt_grad_color5 = '#70f570';

            $nav_grad_color1 = '#0030b8';
            $nav_grad_color2 = '#003cc1';
            $nav_grad_color3 = '#0047c9';
            $nav_grad_color4 = '#0152d0';
            $nav_grad_color5 = '#0a5dd8';
        endif;

        $header_bg = !empty($veliki_opt['header_bg']) ? $veliki_opt['header_bg'] : '';
        $top_header_bg = !empty($veliki_opt['top_header_bg']) ? $veliki_opt['top_header_bg'] : '';

        $custom_style .='
        .wp-block-button .wp-block-button__link,.has-cyan-bluish-gray-background-color.has-cyan-bluish-gray-background-color, .page-links .current, .page-links .post-page-numbers:hover, .post-password-form input[type="submit"], .comment-navigation .nav-links .nav-previous a:hover, .comment-navigation .nav-links .nav-next a:hover, .blog-sidebar .widget ul li::before, #comments .comment-list .comment-body .reply a:hover, .comment-respond .form-submit input, .blog-sidebar .tagcloud a:hover, .blog-sidebar .tagcloud a:focus, .pages-links .post-page-numbers.current, .pages-links .post-page-numbers:hover, .pages-links .post-page-numbers:focus, .main-banner, .single-services-box:hover, .featured-services-slides.owl-theme .owl-dots .owl-dot.active span, .featured-services-slides.owl-theme .owl-dots .owl-dot:hover span, .services-details-overview .services-details-desc .services-details-accordion .accordion .accordion-title i, .why-choose-us-area, .resources-details-overview .resources-details-desc .resources-details-accordion .accordion .accordion-title i, .question-form, .feedback-slides.owl-theme .owl-dots .owl-dot.active span, .feedback-slides.owl-theme .owl-dots .owl-dot:hover span, .entry-meta li::before, .page-title-area, .pagination-area .page-numbers.current, .pagination-area .page-numbers:hover, .pagination-area .page-numbers:focus, .faq-accordion .accordion .accordion-title i, .coming-soon-area .coming-soon-content .social ul li a:hover, .contact-info .contact-info-content .social li a:hover, .nav-color, .navbar-area-with-main-color .evolta-nav, .about-wrap-content .wrap-list li:hover, .services-wrap-card .image-icon .circles-box .circle-one, .services-area-with-main-color, .value-benefits-list-tabs .nav .nav-item .nav-link .icon .circles-box .circle-one, .value-benefits-list-tabs .nav .nav-item .nav-link:hover, .value-benefits-list-tabs .nav .nav-item .nav-link.active, .value-benefits-content .list li:hover, .value-benefits-wrap-content .list li:hover, .overview-wrap-area.with-main-color::before, .with-main-color .overview-wrap-area::before, .awesome-solutions-area.with-main-color, .with-main-color .awesome-solutions-area, .clients-review-slides.owl-theme .owl-dots .owl-dot.active span, .clients-review-slides.owl-theme .owl-dots .owl-dot:hover span, .blog-wrap-card .blog-content .blog-btn i, .data-science-banner-content .banner-form button:hover, .our-awards-area, .case-study-wrap-card .case-study-content .tag span:hover, .footer-area .newsletter-form button:hover { background-color: '.esc_attr($primary_color).';}

        .wp-block-file .wp-block-file__button, .wp-block-tag-cloud a:hover, .wp-block-tag-cloud a:focus, .wp-block-search button { background-color: '.esc_attr($primary_color).' !important; }

        .sticky .post-content .title::before, .blog-details .blog-details-content code, .blog-details .blog-details-content ul a, .blog-details .blog-details-content .category li a:hover, .entry-meta li a:hover, .blog-details .blog-details-content ul.entry-meta li a:hover, #comments .comment-list .comment-body a, .wp-block-image figcaption a, .blog-details .blog-details-content p a, .blog-details .blog-details-content ol a, .wp-block-file a, table th a, .blog-details .blog-details-content kbd, .wp-caption .wp-caption-text a, .comments-area .comment-content code, .comments-area .comment-content kbd, table td a, table td a:hover, .blog-sidebar .widget ul li a:hover, .page-main-content .entry-content a, .page-main-content kbd, .page-main-content code, .read-more-btn i, .read-more-btn:hover, .single-blog-post .post-content .entry-meta li a:hover, .entry-meta li a:hover, .entry-meta li i, .wpcf7-list-item-label a, a:hover, a:focus, .section-title span, .btn-light, .learn-more-btn:hover, .single-services-box .icon, .about-content span, .single-team-box .image .social a, .single-how-it-work-box .icon, .single-choose-us-box .title .icon, .single-feedback-item::before, .single-feedback-item .client-info span, .single-blog-post .post-content .entry-meta li a:hover, .blog-details .blog-details-content .category li a:hover, .contact-info .contact-info-content h2 a, .contact-info .contact-info-content h2 a:not(:first-child):hover, .solutions-wrap-card .icon i, .about-wrap-content .wrap-list li i, .services-wrap-box:hover .content h3 a, .services-wrap-box:hover .content .services-btn, .value-benefits-list-tabs .nav .nav-item .nav-link .icon i, .value-benefits-content .list li i, .value-benefits-wrap-content span, .value-benefits-wrap-content .list li i, .overview-wrap-btn .btn-primary, .awesome-solutions-area.with-main-color .awesome-solutions-card .icon, .with-main-color .awesome-solutions-area .awesome-solutions-card .icon, .work-process-card .work-process-image .icon i, .clients-review-item .client-info h3, .blog-wrap-card .blog-content .entry-meta li a:hover, .blog-wrap-card .blog-content h3 a:hover, .user-analysis-banner-content .sub-title, .data-science-banner-content .sub-title, .case-study-wrap-card .case-study-content .tag span, .team-wrap-content span, .team-wrap-box .image .social a, .team-wrap-box .content span { color: '.esc_attr($primary_color).'; }

        .sticky .post-content .entry-meta li a:hover, .is-style-outline .wp-block-button__link, .blog-details .blog-meta ul li a:hover, .blog-details .blog-meta ul li a:hover, table th a:hover, .evolta-nav .navbar .others-options .btn-primary:hover, .main-banner-content .btn-box .btn-primary:hover, .question-form .form .btn-primary:hover, .question-form .form .btn-primary:focus { color: '.esc_attr($primary_color).' !important; }

        .form-control:focus, blockquote, .form-control:focus, .contact-info .contact-info-content .social li a:hover { border-color: '.esc_attr($primary_color).'; }
    
        @media only screen and (max-width: 991px) {
            .evolta-responsive-nav .evolta-responsive-menu.mean-container .mean-nav ul li.active a,  .evolta-responsive-nav .evolta-responsive-menu.mean-container .mean-nav ul li.active li.active a, .evolta-responsive-nav .evolta-responsive-menu.mean-container .mean-nav ul li.active li li.active a, .evolta-responsive-nav .evolta-responsive-menu.mean-container .mean-nav ul li.active li li li.active a, .evolta-responsive-nav .evolta-responsive-menu.mean-container .mean-nav ul li.active li li li li.active a, .evolta-responsive-nav .evolta-responsive-menu.mean-container .mean-nav ul li a.active { color: '.esc_attr($primary_color).'; }
        }

        .evolta-nav .navbar .navbar-nav .nav-item a.active, .evolta-nav .navbar .navbar-nav .nav-item:focus a, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li a:hover, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li a:focus, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li a.active, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li a:hover, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li a:focus, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li a.active, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li a:hover, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li a:focus, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li a.active, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:hover, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:focus, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a.active, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:hover, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:focus, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a.active, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:hover, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:focus, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a.active, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:hover, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:focus, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a.active, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li.active a, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li.active a, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li.active a, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li.active a, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li.active a, .evolta-nav .navbar .navbar-nav .nav-item .dropdown-menu li.active a, .learn-more-btn, .top-header ul li a:hover, .evolta-nav .navbar .navbar-nav .nav-item a:hover, .evolta-nav .navbar .navbar-nav .nav-item a:focus, .evolta-nav .navbar .navbar-nav .nav-item a.active, .evolta-nav .navbar .navbar-nav .nav-item:hover a, .evolta-nav .navbar .navbar-nav .nav-item:focus a, .evolta-nav .navbar .navbar-nav .nav-item.active a, .evolta-nav .navbar .others-options .option-item .search-btn:hover, .evolta-nav .navbar .others-options .option-item .close-btn:hover, .search-overlay.search-popup .search-form .search-button:hover, .search-overlay.search-popup .search-form .search-button:focus, .single-services-box .icon.bg-dfffd7, .services-details-overview .services-details-desc .features-list li i, .single-team-box .image .social a:hover, .single-team-box .content span, .page-title-content ul li a, .page-title-content ul li a:hover, .contact-info .contact-info-content h2 a:hover, .contact-info .contact-info-content h2 a:not(:first-child), .single-footer-widget ul li a:hover, .single-footer-widget .footer-contact-list li a:hover, .copyright-area p a:hover, .copyright-area ul li a:hover, .section-title .sub-title, .data-analysis-banner-content .banner-btn li .video-btn:hover, .about-wrap-content span, .services-wrap-box .content .services-btn, .clients-review-item span, .partner-wrap-area .section-title h2 b, .case-study-wrap-card .case-study-content h3 .case-study-btn, .team-wrap-content .team-btn, .team-wrap-box .image .social a:hover { color: '.esc_attr($secondary_color).'; }

        .overview-box .content .features-list li span i, .resources-slides.owl-theme .owl-dots .owl-dot.active span, .resources-slides.owl-theme .owl-dots .owl-dot:hover span, .single-footer-widget .social li a:hover, .single-footer-widget h3::before, .go-top, .services-wrap-card:hover .image-icon .circles-box .circle-one, .value-benefits-list-tabs .nav .nav-item .nav-link:hover .icon .circles-box .circle-one, .value-benefits-list-tabs .nav .nav-item .nav-link.active .icon .circles-box .circle-one, .awesome-solutions-card .icon .circles-box .circle-one, .blog-wrap-card:hover .blog-content .blog-btn i, .data-science-banner-content .banner-form button, .our-awards-card:hover, .case-study-wrap-card .case-study-content h3 .case-study-btn i, .team-wrap-content .team-btn i, .footer-area .newsletter-form button { background-color: '.esc_attr($secondary_color).'; }

        .btn-light:hover, .btn-light:focus { background: '.esc_attr($secondary_color).' !important; }

        .search-overlay.search-popup .search-form .search-input:focus { border-color: '.esc_attr($secondary_color).'; }

        .evolta-nav { background-color: '.esc_attr( $header_bg ).'; }

        .top-header { background-color: '.esc_attr( $top_header_bg ).'; }
        .top-header p, .top-header ul li, .top-header ul li a { color: '.esc_attr( $top_header_textcolor ).'; }
        .top-header p i, .top-header ul li i { color: '.esc_attr( $top_header_iconcolor ).'; }

        .evolta-nav .navbar .navbar-nav .nav-item a { color: '.esc_attr( $nav_item  ).'; }

        p, .search-overlay.search-popup .search-form .search-button, .services-details-overview .services-details-desc .features-list li, .single-feedback-item .feedback-desc p::before, .single-feedback-item .feedback-desc p::after, .single-blog-post .post-content .entry-meta li, .single-blog-post .post-content .entry-meta li a, .blog-details .blog-details-content .entry-meta li, .blog-details .blog-details-content .category li a, .entry-meta li, .contact-info .contact-info-content h2 span, .blog-details .blog-details-content ul.entry-meta li a, .blog-sidebar .widget ul li a, .blog-sidebar .widget ul li span, .comment-respond p.logged-in-as a, .blog-sidebar .tagcloud a, .blog-sidebar .calendar_wrap table th, .blog-sidebar .calendar_wrap table td, .blog-sidebar .nice-select, .blog-details .blog-details-content strong, .blog-details .blog-details-content b, .blog-details .blog-details-content ul li, .blog-details .blog-details-content ol li, .blog-details .blog-meta ul li { color: '.esc_attr( $text_color ).' }

        .single-blog-post .post-content .entry-meta li::before { background: '.esc_attr( $text_color ).' }

        .blog-sidebar .widget_search form button::before, .blog-sidebar .widget .widget-title::before, .comments-title::before, .comment-respond .comment-reply-title::before, .search-form .search-submit, .btn-primary::after, .learn-more-btn::before, .overview-box .content .features-list li span::before, .go-top::before, .data-analysis-banner-content .banner-btn li .video-btn i, .solutions-wrap-card::before, .services-wrap-card::before { background: linear-gradient(to right top, '.esc_attr($grad_color1).', '.esc_attr($grad_color2).', '.esc_attr($grad_color3).', '.esc_attr($grad_color4).', '.esc_attr($grad_color5).')}

        .navbar-area.is-sticky .evolta-nav, .navbar-area.is-sticky {background: linear-gradient(to right top, '.esc_attr($nav_grad_color1).', '.esc_attr($nav_grad_color2).', '.esc_attr($nav_grad_color3).', '.esc_attr($nav_grad_color4).', '.esc_attr($nav_grad_color5).') !important}

        .blog-sidebar .widget_search form button::after, .comment-respond .form-submit input:hover, .comment-respond .form-submit input:focus, .btn-primary::before, .evolta-nav .navbar .others-options .option-item a span {background: linear-gradient(to right, '.esc_attr($opt_grad_color1).', '.esc_attr($opt_grad_color2).', '.esc_attr($opt_grad_color3).', '.esc_attr($opt_grad_color4).', '.esc_attr($opt_grad_color5).')}
        
        .footer-area { background-color: '.esc_attr($footer_bg).'; }
        .copyright-area { background-color: '.esc_attr($footer_bottom_bg).'; }

        .single-footer-widget .logo p, .single-footer-widget h3, .single-footer-widget ul li a, .single-footer-widget .footer-contact-list li, .single-footer-widget .footer-contact-list li a { color: '.esc_attr($footer_text_color).'; }

        .single-footer-widget ul li a:hover, .single-footer-widget .footer-contact-list li a:hover { color: '.esc_attr($footer_text_hover).'; }

        .copyright-area p a, .copyright-area p, .copyright-area ul li a { color: '.esc_attr($footer_btext_color).'; }
        .copyright-area ul li::before { background-color: '.esc_attr($footer_btext_color).'; }

        .copyright-area p a:hover, .copyright-area ul li a:hover { color: '.esc_attr($footer_btext_hover).'; }
        
        .single-products .sale-btn, .single-products .products-image ul li a:hover, .productsQuickView .modal-dialog .modal-content .products-content form button, .productsQuickView .modal-dialog .modal-content button.close:hover, .productsQuickView .modal-dialog .modal-content button.close:hover, .woocommerce ul.products li.product:hover .add-to-cart-btn, .shop-sidebar .widget_product_search form button, .shop-sidebar a.button, .shop-sidebar .woocommerce-widget-layered-nav-dropdown__submit, .shop-sidebar .woocommerce button.button, .woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .products_details div.product .woocommerce-tabs .panel #respond input#submit, .products_details div.product .product_title::before, .woocommerce #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt:disabled[disabled], .woocommerce #respond input#submit.alt:disabled[disabled]:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt:disabled[disabled], .woocommerce a.button.alt:disabled[disabled]:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt:disabled[disabled], .woocommerce button.button.alt:disabled[disabled]:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt:disabled[disabled], .woocommerce input.button.alt:disabled[disabled]:hover, .btn-primary:hover, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce .woocommerce-MyAccount-navigation ul .is-active a, .woocommerce .woocommerce-MyAccount-navigation ul li a:hover, .products_details div.product span.sale-btn, .shop-sidebar .tagcloud a:focus, .shop-sidebar .widget_search form button, .shop-sidebar .widget .widget-title::before, .shop-sidebar .widget ul li::before, .shop-sidebar .tagcloud a:hover, .shop-sidebar .tagcloud a:focus { background-color: '.esc_attr($primary_color).'; }
        
        .productsQuickView .modal-dialog .modal-content .products-content .product-meta span a:hover, .woocommerce ul.products li.product h3 a:hover, .woocommerce ul.products li.product .add-to-cart-btn, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a, .products_details div.product .woocommerce-tabs ul.tabs li a:hover, .products_details div.product .woocommerce-tabs ul.tabs li.active, .products_details div.product .woocommerce-tabs ul.tabs li.active a:hover, .products_details div.product .product_meta span.posted_in a:hover, .products_details div.product .product_meta span.tagged_as a:hover, .products_details div.product span.price, .cart-table table tbody tr td.product-name a, .woocommerce-message::before, .woocommerce-info::before, .shop-sidebar .widget ul li a:hover, .shop-sidebar .widget_rss .widget-title .rsswidget { color: '.esc_attr ($primary_color).'; }

        .woocommerce-info, .woocommerce-message { border-top-color: '.esc_attr ($primary_color).'; }

        .case-study-wrap-card:hover .case-study-content .tag { border-bottom-color: '.esc_attr ($primary_color).'; }

        .shop-sidebar .widget_shopping_cart .cart_list li a:hover, .shop-sidebar ul li a:hover { color: '.esc_attr ($primary_color).' !important; }

        .woocommerce ul.products li.product:hover .add-to-cart-btn, .form-control:focus, .woocommerce .form-control:focus, .shop-sidebar .tagcloud a:hover, .shop-sidebar .tagcloud a:focus { border-color: '.esc_attr ($primary_color).'; }

        .preloader::before, .preloader::after { background-color: '.esc_attr($preloader_bg).'; }
        
        ';

        if ( isset( $veliki_opt['border-line-show'] ) && $veliki_opt['border-line-show'] != 1 ) {
            $custom_style .='
            .copyright-area { border-top: none;}';
        }

        // Hide Sticky Header
        if(isset($veliki_opt['enable_sticky_header']) && $veliki_opt['enable_sticky_header'] == false){ $custom_style .='
            .navbar-area.is-sticky{
                display:none !important;
            }';
        }

        // Custom Css
        if( isset($veliki_opt['veliki_css_code'] ) && !empty($veliki_opt['veliki_css_code']) ):
            $custom_style .= $veliki_opt['veliki_css_code'];
        endif;

        // Pre-loader image
        $is_preloader       = !empty($veliki_opt['enable_preloader']) ? $veliki_opt['enable_preloader'] : '';
        $preloader_image = isset( $veliki_opt['preloader_image']['url'] ) ? $veliki_opt['preloader_image']['url'] : get_template_directory_uri() . '/assets/img' .'/status.gif';
        $preloader_style = !empty( $veliki_opt['preloader_style'] ) ? $veliki_opt['preloader_style'] : 'text';
        if ( $preloader_style == 'image' && $is_preloader == '1' ) {
            $custom_style .= "
            .preloader:after,  .preloader:before {
                display: none;
            }
            .preloader { background-color: ".esc_attr($preloader_imgbg)."; }
            .preloader-img {
                 background-image: url(" . esc_url( $preloader_image ) . ");
                 background-repeat: no-repeat;
                 background-position: center;
            }";
        }
        
        wp_add_inline_style('veliki-main-style', $custom_style);

        // Custom Js
        $custom_script ='';
        if( isset($veliki_opt['veliki_js_code'] )){
            $custom_script .= $veliki_opt['veliki_js_code'];
        }
        
        wp_add_inline_script( 'veliki-main', $custom_script );
    }
}
add_action( 'wp_enqueue_scripts', 'veliki_custom_style' );