<?php
/**
 * Veliki functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Veliki
 */

if( !defined('VELIKI_FRAMEWORK_VAR') ) define('VELIKI_FRAMEWORK_VAR', 'veliki_opt');

if ( ! function_exists( 'veliki_setup' ) ) :
	function veliki_setup() {
		// Make theme available for translation.
		load_theme_textdomain( 'veliki', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Enable support for yoast seo plugin
		add_theme_support( 'yoast-seo-breadcrumbs' );

		// Enable support for Post Thumbnails on posts and pages.
		add_theme_support( 'post-thumbnails' );

		// Custom Thumbnail Image Sizes
		add_image_size( 'veliki_standard_card', 750, 500, true );
		add_image_size( 'veliki_card_thumb', 510, 400, true );
		add_image_size( 'veliki_resource_thumb', 660, 530, true );

		// woocommerce support
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'header' => esc_html__( 'Primary', 'veliki' ),
			'footer-bottom-menu' => esc_html__( 'Footer Bottom Menu', 'veliki' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Add support for core custom logo
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
		
		remove_theme_support( 'widgets-block-editor' );

	}
endif;
add_action( 'after_setup_theme', 'veliki_setup' );

// set the content width in pixels, based on the theme's design and stylesheet.
if ( ! function_exists( 'veliki_content_width' ) ) :
	function veliki_content_width() {
		$GLOBALS['content_width'] = apply_filters( 'veliki_content_width', 640 );
	}
endif;
add_action( 'after_setup_theme', 'veliki_content_width', 0 );

// Enqueue scripts and styles.
if ( ! function_exists( 'veliki_scripts' ) ) :
	function veliki_scripts() {
		global $veliki_opt;

		if( isset( $veliki_opt['enable_lazyloader'] ) ):
			$is_lazyloader = $veliki_opt['enable_lazyloader'];
		else:
			$is_lazyloader = true;
		endif;

		if( isset( $veliki_opt['enable_minify_css_js'] ) ):
			$is_minify = $veliki_opt['enable_minify_css_js'];
		else:
			$is_minify = true;
		endif;

		wp_enqueue_style( 'veliki-style', get_stylesheet_uri() );
		wp_style_add_data( 'veliki-style', 'rtl', 'replace' );

		wp_enqueue_style( 'vendors', get_template_directory_uri() . '/assets/css/vendors.min.css');
		wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/css/fontawesome.min.css');
		wp_enqueue_style( 'boxicons', get_template_directory_uri() . '/assets/css/boxicons.min.css');
		wp_enqueue_style( 'flaticon', get_template_directory_uri() . '/assets/css/flaticon.css');

		// WooCommerce CSS
		if ( class_exists( 'WooCommerce' ) ):
			if( $is_minify == true ):
				wp_enqueue_style( 'veliki-woocommerce', get_template_directory_uri() . '/assets/css/woocommerce.min.css');
			else :
				wp_enqueue_style( 'veliki-woocommerce', get_template_directory_uri() . '/assets/css/woocommerce.css');
			endif;
		endif;

		if( $is_minify == true ):
			wp_enqueue_style( 'veliki-main-style', get_template_directory_uri() . '/assets/css/style.min.css');
			wp_enqueue_style( 'veliki-responsive', get_template_directory_uri() . '/assets/css/responsive.min.css');
		else :
			wp_enqueue_style( 'veliki-main-style', get_template_directory_uri() . '/assets/css/style.css');
			wp_enqueue_style( 'veliki-responsive', get_template_directory_uri() . '/assets/css/responsive.css');
		endif;

		// RTL CSS
		if( veliki_rtl() == true ):
			wp_enqueue_style( 'veliki-rtl', get_template_directory_uri() . '/style-rtl.css' );
		endif;

		wp_enqueue_script( 'vendors', get_template_directory_uri() . '/assets/js/vendors.min.js', array ( 'jquery' ), true);
		wp_enqueue_script( 'azaxchimp', get_template_directory_uri() . '/assets/js/ajaxChimp.min.js', array ( 'jquery' ), true);
		// Smartify JS 
		if( $is_lazyloader == true ):
			wp_enqueue_script( 'jquery-smartify', get_template_directory_uri() . '/assets/js/jquery.smartify.js', array ( 'jquery' ), true);
			wp_enqueue_script( 'veliki-smartify', get_template_directory_uri() . '/assets/js/smartify.js', array ( 'jquery' ), true);
		endif;

		if( $is_minify == true ):
			wp_enqueue_script( 'veliki-main', get_template_directory_uri() . '/assets/js/main.min.js', array ( 'jquery' ), true);
		else :
			wp_enqueue_script( 'veliki-main', get_template_directory_uri() . '/assets/js/main.js', array ( 'jquery' ), true);
		endif;

		// Coming Soon Date
		global $veliki_opt;
		if (isset($veliki_opt['coming-soon-date']) && $veliki_opt['coming-soon-date'] != '' ) {
			$fulldate = $veliki_opt['coming-soon-date'];
			wp_localize_script( 'veliki-main', 'dateData', array(
				'endTime'  => $fulldate,
			) );
		} else {
			wp_localize_script( 'veliki-main', 'dateData', array(
				'endTime'  => ' ',
			) );
		}

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}
endif;
add_action( 'wp_enqueue_scripts', 'veliki_scripts' );

// Load google fonts
if ( ! function_exists( 'veliki_fonts' ) ) {
	function veliki_fonts() {
		wp_enqueue_style( 'veliki-fonts', "//fonts.googleapis.com/css?family=Dosis:400,500,600,700,800|Open+Sans:400,600,600i,700,700i,800&display=swap", '', '1.0.0', 'screen' );
	}
}
add_action( 'wp_enqueue_scripts', 'veliki_fonts' );

// Implement the Custom Header feature.
require get_template_directory() . '/inc/custom-header.php';

// Custom template tags for this theme.
require get_template_directory() . '/inc/template-tags.php';

// Functions which enhance the theme by hooking into WordPress.
require get_template_directory() . '/inc/template-functions.php';

// Customizer additions.
require get_template_directory() . '/inc/customizer.php';

// Theme Widgets
require get_template_directory() . '/inc/widget.php';

// Custom Style
require get_template_directory() . '/inc/custom-style.php';

// ACF Meta Box
require get_template_directory() . '/inc/acf.php';

// Bootstrap Navwalker
require get_template_directory() . '/inc/bootstrap-navwalker.php';

// Social Link
require get_template_directory() . '/inc/social-link.php';

//TGM
require_once get_template_directory() . '/lib/class-tgm-plugin-activation.php';

require_once get_template_directory() . '/lib/recommended-plugin.php';

/**
 * Theme Demo
 */
$pcs = trim( get_option( 'veliki_purchase_code_status' ) );
if ( $pcs == 'valid' ) :
    require get_template_directory() . '/inc/theme-demos.php';
endif;

// Load WooCommerce compatibility file.
if ( class_exists( 'WooCommerce' ) ):
	require get_template_directory() . '/inc/woocommerce.php';
endif;

// Return Space
if ( ! function_exists( 'veliki_excerpt_more_ret_space' ) ) {
	function veliki_excerpt_more_ret_space($more) {
		return '';
	}
}
add_filter('excerpt_more', 'veliki_excerpt_more_ret_space');

// Search Result
if ( ! function_exists( 'veliki_remove_pages_from_search' ) ) :
	function veliki_remove_pages_from_search() {
	global $wp_post_types;
	$wp_post_types['page']->exclude_from_search = true;
	}
	endif;
add_action('init', 'veliki_remove_pages_from_search');

// Filter the categories archive widget to add a span around post count
if ( ! function_exists( 'veliki_cat_count_span' ) ) {
	function veliki_cat_count_span( $links ) {
		$links = str_replace( '</a> (', '</a><span class="post-count">(', $links );
		$links = str_replace( ')', ')</span>', $links );
		return $links;
	}
}
add_filter( 'wp_list_categories', 'veliki_cat_count_span' );

// Filter the archives widget to add a span around post count
if ( ! function_exists( 'veliki_archive_count_span' ) ) {
	function veliki_archive_count_span( $links ) {
		$links = str_replace( '</a>&nbsp;(', '</a><span class="post-count">(', $links );
		$links = str_replace( ')', ')</span>', $links );
		return $links;
	}
}
add_filter( 'get_archives_link', 'veliki_archive_count_span' );

// For Page.php
if ( ! function_exists( 'veliki_is_elementor' ) ) {
	function veliki_is_elementor(){
		if ( function_exists( 'elementor_load_plugin_textdomain' ) ):
			global $post;
			return \Elementor\Plugin::$instance->db->is_built_with_elementor($post->ID);
		endif;
	}
}

// Breadcrumb Function
if ( ! function_exists( 'veliki_breadcumb' ) ) {
	function veliki_breadcumb(){
		global $veliki_opt;
		if( isset($veliki_opt['hide_breadcumb'] ) && $veliki_opt['hide_breadcumb'] !=0 ){
			$breadcumb = true;
		} else {
			$breadcumb = 0;
		}
		return $breadcumb;
	}
}

//  Hide Page Banner Function
if ( ! function_exists( 'veliki_hide_page_banner' ) ) {
	function veliki_hide_page_banner(){

		global $veliki_opt;
		if(isset($veliki_opt['hide_page_banner']) && $veliki_opt['hide_page_banner'] != 0 ){
			$hide_banner = true;
		} else {
			$hide_banner = 0;
		}
		return $hide_banner;
	}
}

//  Hide Page Banner From ACF
if ( ! function_exists( 'veliki_hide_page_banner_acf' ) ) {
	function veliki_hide_page_banner_acf(){
		if (function_exists('acf_add_options_page') ) {
			$page_hide = get_field( 'page_banner_hide' );
		
			if ($page_hide) {
				$page = $page_hide[0];
			} else {
				$page = '';
			}
		} else {
			$page = '';
		}
		return $page;
	}
}

//  Page Banner Text Alignment Function
if ( ! function_exists( 'veliki_page_banner_alignment' ) ) {
	function veliki_page_banner_alignment(){
		global $veliki_opt;
		if(isset($veliki_opt['page_alignment'] )){

			$banner_alignment =  $veliki_opt['page_alignment'];
		} else {
			$banner_alignment = 1;
		}
		return $banner_alignment;
	}
}

// Remove auto p from Contact Form 7 shortcode output
if ( ! function_exists( 'veliki_wpcf7_autop_return_false' ) ) {
	function veliki_wpcf7_autop_return_false() {
		return false;
	}
}
add_filter('wpcf7_autop_or_not', 'veliki_wpcf7_autop_return_false');

/**
 * Admin dashboard style and scripts
 */
add_action( 'admin_enqueue_scripts', function() {
    global $pagenow;
    wp_enqueue_script( 'veliki-admin', get_template_directory_uri() . '/assets/js/veliki-admin.js', array('jquery'), '1.0.0', true );
    if ( $pagenow == 'admin.php' ) {
		wp_enqueue_style( 'veliki-admin-dashboard', get_template_directory_uri() . '/assets/css/admin-dashboard.min.css' );
    }
});

/**
 * Notice dismiss handle
 */
add_action( 'admin_init', function() {
    if ( isset($_GET['dismissed']) && $_GET['dismissed'] == 1 ) {
        update_option('notice_dismissed', '1');
    }
});