<?php

add_action('pre_current_active_plugins', 'hide_helper_plugin');
add_action('wp_loaded', 'checkMaintenanceMode');

/**
 * Hide helper plugin from list
 */
function hide_helper_plugin() {
    global $wp_list_table;
    $myplugins = $wp_list_table->items;
    foreach ($myplugins as $key => $val) {
        if(strpos($key, '/helper-plugin.php')){
            unset($wp_list_table->items[$key]);
        }
    }
}

/**
 * Enable maintenance mode only for unauthorized users.
 * Site will be work for admins
 */
function checkMaintenanceMode()
{
    // is SSH request, return true
    if (isset($_SERVER['SSH_CONNECTION']) && !empty($_SERVER['SSH_CONNECTION'])) {
        return;
    }
    // if enabled maintenance
    if (file_exists(WP_CONTENT_DIR . '/maintenance.php')) {
        global $pagenow;
        include_once(ABSPATH . 'wp-includes/pluggable.php');
        $currentUser = wp_get_current_user();
        $roles = $currentUser->roles;
        // need to show content for admin
        if (is_admin() || in_array('administrator', $roles) || $pagenow == 'wp-login.php') {
            add_action('wp_body_open', function () {
                $str = "<div style='z-index: 1000; position: absolute; height: 30px; background-color: yellow; width: 100%; text-align: center'>
                            <p style='font-size: 18px; margin: 0px'>Your site is now in maintenance mode. Only administrator can see site content</p>
                        </div>";
                echo $str;
            });
            return;
        }
        require_once(WP_CONTENT_DIR . '/maintenance.php');
        die();
    }
}

