<?php

namespace TmdHelper\App\Api\Templates;

use TmdHelper\App\Interfaces\ApiInterface;
use WP_REST_Controller, WP_REST_Request, WP_Error, WP_REST_Server, WP_REST_Response;

class TemplatesApi extends WP_REST_Controller implements ApiInterface
{
    const NAMESPACE = 'wp/v2';
    const BASE_ROUTE = '/templates';

    public function registerFields(){}

    public function registerRoutes()
    {
        // list
        register_rest_route(
            self::NAMESPACE,
            self::BASE_ROUTE,
            [
                [
                    'methods' => WP_REST_Server::READABLE,
                    'callback' => [$this, 'getThemeTemplatesList']
                ],
            ]
        );
    }

    public function getThemeTemplatesList(WP_REST_Request $request)
    {
        try {
            $bodyParams = $request->get_query_params();
            if ($request->get_method() === 'POST') {
                $bodyParams = $request->get_body_params();
            }
            $this->validateRequestParameters($bodyParams);
            $templates = [];
            $templateType = (string)$bodyParams['type'];
            $templatesArray = wp_get_theme()->get_page_templates(null, $templateType);
            if (count($templatesArray) > 0) {
                foreach ($templatesArray as $file => $name) {
                    $templates[] = [
                        'name' => $name,
                        'file' => $file
                    ];
                }
            }
        } catch (\Exception $exception) {
            return new WP_REST_Response([
                'status' => 'error',
                'message' => $exception->getMessage()
            ], 400);
        }

        return new WP_REST_Response([$templates], 200);
    }

    private function validateRequestParameters(array $bodyParams)
    {
        $errorMessage = null;
        if (!isset($bodyParams['type']) || empty($bodyParams['type'])) {
            $errorMessage = "Please specify a 'type' parameter (can be page|post|...)";
        }

        if ($errorMessage) {
            throw new \Exception($errorMessage);
        }

        return true;
    }
}
