<?php

namespace TmdHelper\App\Api\Settings;

use TmdHelper\App\Interfaces\ApiInterface;
use WP_REST_Controller, WP_REST_Settings_Controller, WP_REST_Server, WP_REST_Request, WP_Error;

/**
 * Class SettingsApi
 */
class SettingsApi extends WP_REST_Controller implements ApiInterface
{
    /**
     * @var SettingsManager
     */
    protected $settingsManager;

    /**
     * @var Reference/wpdb
     */
    protected $wpdb;
    /**
     * @var WP_REST_Settings_Controller
     */
    protected $settingsController;

    /**
     * SettingsApi constructor.
     */
    public function __construct()
    {
        global $wpdb;
        $this->wpdb = $wpdb;
        $this->settingsController = new WP_REST_Settings_Controller();
    }

    /**
     * Register the routes for the objects of the controller.
     */
    public function registerRoutes()
    {
        $version = '2';
        $namespace = 'wp/v' . $version;
        $base = 'settings';
        register_rest_route(
            $namespace,
            '/' . $base,
            [
                [
                    'methods'             => WP_REST_Server::READABLE,
                    'callback'            => [$this, 'getSettings'],
                    'args'                => [
                        'key' => 'value',
                    ],
                ],
            ]
        );
        register_rest_route(
            $namespace,
            '/' . $base,
            [
                [
                    'methods'             => WP_REST_Server::CREATABLE,
                    'callback'            => [$this, 'configure'],
                    'args'                => [
                        'key' => 'value',
                    ],
                ],
            ]
        );
        $this->settingsController->register_routes();
    }

    /**
     * Register the field total_posts for user endpoint.
     */
    public function registerFields()
    {

    }

    /**
     * @param $request
     *
     * @return array
     */
    public function configure($request)
    {
        $bodyParams = $request->get_body_params();
        $this->initSettingsManager();
        $this->settingsManager->setSettings($bodyParams);

        return array_merge($this->settingsController->update_item($request), $this->settingsManager->run());
    }

    /**
     * @param WP_REST_Request $request
     *
     * @return array
     */
    public function getSettings($request)
    {
        $this->initSettingsManager();
        $this->settingsManager->selectSettings();

        return array_merge($this->settingsController->get_item($request), $this->settingsManager->getSettings());
    }

    /**
     * Initializes $settingsManager
     */
    private function initSettingsManager()
    {
        $this->settingsManager = new SettingsManager($this->wpdb);
    }
}
