<?php

namespace TmdHelper\App\Api\Secure;

/**
 * Class SecureManager
 * @package TmdHelper\App\Api\Secure
 */
class SecureManager
{
    public function updateHeadersInHtaccess(array $headers, string $service)
    {
        $allHeaders = $headers;
        $htaccess = get_home_path() . ".htaccess";
        if (!file_exists($htaccess)) {
            throw new \Exception('Cant find .htaccess file in the site directory', 404);
        }
        $htaccessHandle = fopen($htaccess, "r");
        while (!feof($htaccessHandle)) {
            $line = fgets($htaccessHandle);
            $fileByLines[] = $line;

        }
        fclose($htaccessHandle);
        foreach ($headers as $key => $header) {
            foreach ($fileByLines as $line) {
                if (preg_match("/{$header}/", $line)) {
                    unset($headers[$key]);
                }
            }
        }

        insert_with_markers($htaccess, $service, $allHeaders);

        /*
         * Example of inserted headers in .htaccess
         *
         *  # BEGIN $serviceName
         *  Some Header Here
         *  # END MyPlugin
         */

        return $headers;
    }
}
