<?php

namespace TmdHelper\App\Api\Cloudflare;

/**
 * Class CloudflareManager
 * @package TmdHelper\App\Api\Cloudflare
 */
class CloudflareManager
{

    const OPTION_API_KEY = 'cloudflare_api_key';
    const OPTION_API_EMAIL = 'cloudflare_api_email';
    const OPTION_CACHED_DOMAIN = 'cloudflare_cached_domain_name';

    /**
     * @var Reference/wpdb
     */
    private $wpdb;

    /**
     * Matomo auth_token
     * @var string
     */
    protected $apiKey;

    /**
     * @var string
     */
    private $email;

    /**
     * CloudflareManager constructor.
     * @param $wbdbInstance
     */
    public function __construct($wbdbInstance)
    {
        $this->wpdb = $wbdbInstance;
    }

    /**
     * @throws \Exception
     */
    public function run()
    {
        if (empty($this->email) || empty($this->apiKey)) {
            throw new \Exception('Email or apiKey can not be empty');
        }
        $this->updateConfiguration();
    }

    /**
     *
     */
    private function updateConfiguration()
    {
        $sqlPattern = "INSERT INTO {$this->wpdb->options} (option_name,option_value,autoload) 
                        VALUES (%s,%s,%s) 
                        ON DUPLICATE KEY UPDATE option_value = %s";
        $sql1 = $this->wpdb->prepare($sqlPattern, self::OPTION_API_EMAIL, $this->email,'yes', $this->email);
        $sql2 = $this->wpdb->prepare($sqlPattern, self::OPTION_API_KEY, $this->apiKey,'yes', $this->apiKey);
        $domain = preg_replace('/https?:\/\//', '' , site_url());
        $sql3 = $this->wpdb->prepare($sqlPattern, self::OPTION_CACHED_DOMAIN, $domain,'yes', $domain);
        $this->wpdb->query($sql1);
        $this->wpdb->query($sql2);
        $this->wpdb->query($sql3);
    }

    /**
     * @param $apiKey
     * @throws \Exception
     */
    public function setApiKey($apiKey)
    {
        if (empty($apiKey)) {
            throw new \Exception('api key must be set');
        }
        $this->apiKey = $apiKey;
    }

    /**
     * @param $email
     * @throws \Exception
     */
    public function setEmail($email)
    {
        if (empty($email)) {
            throw new \Exception('email must be set');
        }
        $this->email = $email;
    }

}