<?php
namespace Elementor;
class VelikiWorkProcess extends Widget_Base{
    public function get_name(){
        return "veliki-work-process";
    }
    public function get_title(){
        return "Work Process";
    }
    public function get_icon(){
        return "eicon-favorite";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'work_section_content',
            [
                'label'=>esc_html__('Section Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'top_title', [
                'label' => esc_html__( 'Top Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title', [
                'label' => esc_html__( 'Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'veliki-toolkit' ),
                    3   => __( '3', 'veliki-toolkit' ),
                    4   => __( '4', 'veliki-toolkit' ),
                ],
                'default' => 3,
            ]
        );
        $this->add_control(
			'card_alignment',
			[
				'label' => __( 'Card Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '1'
			]
		);
        $this->add_control(
            'card_shape',
            [
                'label'     => __('Process Shape', 'veliki-toolkit' ),
                'type'      => Controls_Manager::MEDIA,
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control(
            'card_icon',
            [
                'label' => esc_html__( 'Choose Card Icon', 'alpas-toolkit' ),
                'type' 			=> Controls_Manager::ICON,
                'label_block' 	=> true,
                'options' 		=> domain_font_awesome(),
                'default' 		=> 'fab fa-facebook-f',
            ]
        );
        
        $repeater->add_control(
            'card_num', [
                'label' => esc_html__( 'Card Number', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'card_title', [
                'label' => esc_html__( 'Card Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'card_details', [
                'label' => esc_html__( 'Card Description', 'veliki-toolkit' ),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'card_list',
            [
                'label' => esc_html__( 'Add Card Content', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'show_num_gbg',
            [
                'label'        => __( 'Number Gradient Hide/Show?', 'tovi-toolkit' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'tovi-toolkit' ),
                'label_off'    => __( 'Hide', 'tovi-toolkit' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );
        $this-> end_controls_section();
        // End Tab content controls

        // Start Features Card Style
        $this-> start_controls_section(
            'it_works_style',
            [
                'label'=>esc_html__('Works Style', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'toptitle_color',
            [
                'label' => esc_html__( 'Top Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'toptitle_font_size',
			[
				'label' => esc_html__( 'Top Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 60,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title .sub-title' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 60,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_control(
            'card_num_color',
            [
                'label' => esc_html__( 'Card Number Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process-card .work-process-image .number' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_num_bgcolor',
            [
                'label' => esc_html__( 'Card Number Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process-card .work-process-image .number' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_icon_color',
            [
                'label' => esc_html__( 'Card Icon Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process-card .work-process-image .icon i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_title_color',
            [
                'label' => esc_html__( 'Card Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process-card .content h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'card_title_font_size',
			[
				'label' => esc_html__( 'Card Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .work-process-card .content h3' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'card_desc_color',
            [
                'label' => esc_html__( 'Card Content Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process-card .content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'card_details_font_size',
			[
				'label' => esc_html__( 'Card Content Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .work-process-card .content p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this-> end_controls_section();
    }
    // Register control section end here

    protected function render()
    {
        $settings = $this->get_settings_for_display(); 
            // Text Alignment
            if( $settings['card_alignment' ] == '1') {
                $alignment = 'text-center';
            } 
            elseif( $settings['card_alignment' ] == '2') {
                $alignment = 'text-right';
            } else {
                $alignment = 'text-left';
            }

            $columns = $settings['columns'];
            if ($columns == 2) {
                $column = 'col-lg-6 col-md-6';
            } elseif ($columns == 4) {
                $column = 'col-lg-3 col-sm-6';
            } else {
                $column = 'col-lg-4 col-sm-6';
            }
        ?>

        <div class="work-process-area pt-100 pb-70">
            <div class="container">
                <?php if( $settings['top_title'] != '' || $settings['title'] != ''): ?>
                    <div class="section-title">
                        <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>

                        <<?php echo esc_attr( $settings['title_tag'] ); ?> class="title"><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    </div>
                <?php endif; ?>

                <div class="row justify-content-center work-process-with-border">
                    <?php if ($settings['card_list'] !='') : 
                        $i = 1;
                        foreach ( $settings['card_list'] as $item ) :
                            if ( $item['card_title'] !='' || $item['card_details'] !='' || $item['card_icon'] !='' ) : ?>
                                <div class="<?php echo esc_attr($column); ?>">
                                    <div class="work-process-card  <?php echo esc_attr( $alignment); ?>">
                                        <div class="work-process-image">
                                            <?php if( !empty( $settings['card_shape']['url'] ) ){ ?>
                                                <img src="<?php echo esc_url( $settings['card_shape']['url'] ); ?>" alt="<?php echo esc_attr__( 'Image', 'veliki-toolkit' ); ?>">
                                            <?php } ?>

                                            <?php if( $item['card_icon'] != '' ) : ?>
                                                <div class="icon">
                                                    <i class="<?php echo esc_attr( $item['card_icon'] ); ?>"></i>
                                                </div>
                                            <?php endif; ?>

                                            <?php if( $item['card_num'] != '') : ?>
                                                <span class="number <?php if ( $settings['show_num_gbg'] == 'yes' ) : ?> bg-2 <?php endif; ?>"><?php echo esc_html( $item['card_num'] ); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="content">
                                            <h3><?php echo esc_html( $item['card_title'] ); ?></h3>
                                            <p><?php echo wp_kses_post( $item['card_details'] ); ?></p>
                                        </div>
                                    </div>

                                </div><?php 
                            endif;
                        $i++;
                        endforeach;
                    endif; ?>
                </div>
            </div>
        </div>
        <?php
    }   
}
Plugin::instance()->widgets_manager->register_widget_type( new VelikiWorkProcess );