<?php
namespace Elementor;
class Veliki_Benefit_Tab extends Widget_Base{
    public function get_name(){
        return "VelikiBenefitTab";
    }
    public function get_title(){
        return "Veliki Benefit Tab";
    }
    public function get_icon(){
        return "eicon-info-box";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'section_content',
            [
                'label' => __('Content', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            
            $this->add_control(
                'top_title', [
                    'label'       => __( 'Top Title', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'title', [
                    'label'       => __( 'Title', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'heading_tag', [
                    'label'   => __( 'Title Heading Tag', 'veliki-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                    'default'     => 'h3',
                    'label_block' => true,
                ]
            );
          
            $card_items = new Repeater();
            $card_items->add_control(
                'tab_icon',
                [
                    'label'   => __( 'Tab Icon', 'veliki-toolkit' ),
                    'type' 	  => Controls_Manager::TEXT,
                    'default' => 'flaticon-big-data',
                ]
            );
            $card_items->add_control(
                'tab_title',
                [
                    'label' => __('Tab Title', 'veliki-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'label_block' => true,
                ]
            );
            $card_items->add_control(
                'inner_title',
                [
                    'label' => __('Inner Title', 'veliki-toolkit'),
                    'type'  => Controls_Manager:: TEXT,
                    'label_block' => true,
                ]
            );
            $card_items->add_control(
                'inner_con',
                [
                    'label' => __('Inner Content', 'veliki-toolkit'),
                    'type'  => Controls_Manager:: TEXTAREA,
                    'label_block' => true,
                ]
            );
            $card_items->add_control(
                'inner_lists',
                [
                    'label' => __('Inner Lists', 'veliki-toolkit'),
                    'type'  => Controls_Manager:: TEXTAREA,
                    'label_block' => true,
                ]
            );
            $card_items->add_control(
                'image',
                [
                    'label'     => __('Upload Image', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'tabs_content',
                [
                    'label'       => __( 'Add Content', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $card_items->get_controls(),
                ]
            );
        $this-> end_controls_section();

        // End Tab content controls

        // Start style1 content controls
        $this-> start_controls_section(
            'content_style',
            [
                'label'     => __('Style', 'veliki-toolkit'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'toptitle_color',
                [
                    'label'     => __( 'Top Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_toptitle',
                    'label'    => __( 'Top Title Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .section-title .sub-title',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_title',
                    'label'    => __( 'Title Typography', 'veliki-toolkit' ),
                     
                    'selector' => ' {{WRAPPER}} .section-title .title',
                ]
            );
            // List
            $this->add_control(
                'icon_color',
                [
                    'label'     => __( 'Icon Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .value-benefits-list-tabs .nav .nav-item .nav-link .icon i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_bgcolor',
                [
                    'label'     => __( 'Icon Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .value-benefits-list-tabs .nav .nav-item .nav-link .icon i' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'tabtitle_color',
                [
                    'label'     => __( 'Tab Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .value-benefits-list-tabs .nav .nav-item .nav-link' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_tabtitle',
                    'label'    => __( 'Tab Title Typography', 'veliki-toolkit' ),
                     
                    'selector' => ' {{WRAPPER}} .value-benefits-list-tabs .nav .nav-item .nav-link',
                ]
            );
            $this->add_control(
                'inti_color',
                [
                    'label'     => __( 'Inner Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .value-benefits-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_intti',
                    'label'    => __( 'Inner Title Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .value-benefits-content h3',
                ]
            );
            $this->add_control(
                'incon_color',
                [
                    'label'     => __( 'Inner Content Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .value-benefits-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_incon',
                    'label'    => __( 'Inner Content Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .value-benefits-content p',
                ]
            );
            $this->add_control(
                'list_color',
                [
                    'label'     => __( 'List Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .value-benefits-content .list li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_list',
                    'label'    => __( 'List Typography', 'veliki-toolkit' ),
                     
                    'selector' => ' {{WRAPPER}} .value-benefits-content .list li',
                ]
            );
            $this->add_control(
                'libg_color',
                [
                    'label'     => __( 'Lists Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .value-benefits-content .list li' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'li_bg_hcolor',
                [
                    'label'     => __( 'Lists Hover Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .value-benefits-content .list li:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card_hcolor',
                [
                    'label'     => __( 'Lists Hover Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .value-benefits-content .list li:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
        $this-> end_controls_section();
    }

    protected function render()
    {
        // Retrieve all controls value
        $settings = $this->get_settings_for_display();

        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        $lists    = $settings['tabs_content']; ?>

        <div class="value-benefits-area ptb-100">
            <div class="container">
                <?php if( $settings['top_title'] != '' || $settings['title'] != ''): ?>
                    <div class="section-title">
                        <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>

                        <<?php echo esc_attr( $settings['heading_tag'] ); ?> class="title"><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['heading_tag'] ); ?>>
                    </div>
                <?php endif; ?>
                
                <div class="value-benefits-list-tabs">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <?php $i = 1; foreach ( $lists as $item ) : ?>
                            <li class="nav-item">
                                <a class="nav-link <?php if( $i == 1 ) : ?>active <?php endif; ?>" id="sales-increase-tab" data-toggle="tab" href="#sales-increase<?php echo $i; ?>" role="tab" aria-controls="sales-increase">
                                    <div class="icon">
                                        <i class="<?php echo esc_attr( $item['tab_icon'] ); ?>"></i> 

                                        <div class="circles-box">
                                            <div class="circle-one"></div>
                                        </div>
                                    </div>

                                    <?php echo esc_html( $item['tab_title'] ); ?>
                                </a>
                            </li>
                        <?php $i++; endforeach; ?>
                    </ul>

                    <div class="tab-content" id="myTabContent">
                        <?php $i = 1; foreach ( $lists as $item ) : ?>
                            <div class="tab-pane fade <?php if( $i == 1 ) : ?> show active <?php endif; ?>" id="sales-increase<?php echo $i; ?>" role="tabpanel">
                                <div class="row align-items-center">
                                    <div class="col-lg-6 col-md-12">
                                        <div class="value-benefits-content">
                                            <h3><?php echo esc_html( $item['inner_title'] ); ?></h3>
                                            <p><?php echo wp_kses_post( $item['inner_con'] ); ?></p>

                                            <div class="row justify-content-center">
                                                <?php echo wp_kses_post( $item['inner_lists'] ); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if( !empty( $item['image']['url'] ) ){ ?>
                                        <div class="col-lg-6 col-md-12">
                                            <div class="value-benefits-image">
                                                <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $item['image']['url'] ); ?>" alt="<?php echo esc_attr__( 'Image', 'veliki-toolkit' ); ?>">
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php $i++; endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new Veliki_Benefit_Tab );