<?php namespace Elementor;

class FAQWidget extends Widget_Base{
    public function get_name(){
        return "faq-widget";
    }
    public function get_title(){
        return "FAQ Widget";
    }
    public function get_icon(){
        return "eicon-accordion";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){

    // Start FAQ section
    $this-> start_controls_section(
        'faq_section',
        [
            'label'=>esc_html__('FAQ Content', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_CONTENT,
        ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
        'card_text_alignment',
        [
            'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
            ],
            'default' => '3'
        ]
    );
    $repeater->add_control(
        'faq_title',
        [
            'label' => esc_html__( 'FAQ Title', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );
    $repeater->add_control(
        'faq_desc',
        [
            'label' => esc_html__( 'Description', 'veliki-toolkit' ),
            'type' => Controls_Manager::WYSIWYG,
        ]
    );

    $this->add_control(
        'faq_list',
        [
            'label' => esc_html__( 'Add FAQ List', 'veliki-toolkit' ),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]
    );
    $this->add_control(
        'section_text_alignment',
        [
            'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
            ],
            'default' => '3',
        ]
    ); 
    $this->add_control(
        'section_top_title',
        [
            'label'=>esc_html__('Top Title', 'veliki-toolkit'),
            'type'=>Controls_Manager:: TEXT,
        ]
    );

    $this->add_control(
        'section_title',
        [
            'label'=>esc_html__('Title', 'veliki-toolkit'),
            'type'=>Controls_Manager:: TEXT,
        ]
    );
    $this->add_control(
        'title_tag',
        [
            'label' => __('Title Tag', 'veliki-toolkit'),
            'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                ],
            'default'     => 'h2',
            'label_block' => true,
        ]
    );
    $this->add_control(
        'section_desc',
        [
            'label'=>esc_html__('Description', 'veliki-toolkit'),
            'type'=>Controls_Manager:: WYSIWYG,
            'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
        ]
    );
    // End Section controls
    $this->add_control(
        'image',
        [
            'label' => esc_html__( 'FAQ Image', 'veliki-toolkit' ),
            'type' => Controls_Manager::MEDIA,
            'default' => [
                'url' => Utils::get_placeholder_image_src(),
            ],
        ]
    );
    $this-> end_controls_section();
    // End Right Controls

    // Start FAQ Style
    $this-> start_controls_section(
        'faq_style',
        [
            'label'=>esc_html__('FAQ Style', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_STYLE,
        ]
    );

    // Start Section Style
    $this->add_responsive_control(
        'toptitle_font_size',
        [
            'label' => esc_html__( 'Top Title Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 30,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .section-title span' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );

    $this->add_control(
        'title_color',
        [
            'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
            ],
        ]
    );

    $this->add_responsive_control(
        'title_font_size',
        [
            'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 60,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );
    $this->add_responsive_control(
        'desc_font_size',
        [
            'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 20,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );
    // End Section Style

    $this->add_control(
        'list_style',
        [
            'label' => esc_html__( 'Accordion Lists', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
        ]
    );
    
    $this->add_control(
        'list_title_color',
        [
            'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .faq-accordion .accordion .accordion-title' => 'color: {{VALUE}}',
            ],
        ]
    );
    $this->add_responsive_control(
        'list_title_sz',
        [
            'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 30,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .faq-accordion .accordion .accordion-title' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );
    $this->add_control(
        'title_icon_color',
        [
            'label' => esc_html__( 'Title Icon Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .faq-accordion .accordion .accordion-title i' => 'color: {{VALUE}}',
            ],
        ]
    );
    $this->add_responsive_control(
        'list_desc_sz',
        [
            'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 25,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .faq-accordion .accordion .accordion-content' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );
    $this-> end_controls_section();
    
}
    // Register control section end here

    protected function render() 
    {
        $settings = $this->get_settings_for_display();
        // Text Alignment
		if( $settings['section_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['section_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
        }
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif; ?>
        <div class="faq-area ptb-110">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-md-12">
                        <div class="faq-accordion">
                            <ul class="accordion">
                                <?php if ( $settings['faq_list']!='' ){
                                    $loop = 1;
                                    foreach ( $settings['faq_list'] as $item ) {

                                        // Text Alignment
                                        if( $item['card_text_alignment' ] == '1') {
                                            $c_alignment = 'text-center';
                                        } 
                                        elseif( $item['card_text_alignment' ] == '2') {
                                            $c_alignment = 'text-right';
                                        } else {
                                            $c_alignment = 'text-left';
                                        }
                                        if ($loop == 1) {
                                            $active = 'active';
                                            $show = 'show';
                                        }else {
                                            $active = '';
                                            $show = '';
                                        }

                                        if($item['faq_title']!='' || $item['faq_desc']!='') { ?>
                                            <li class="accordion-item <?php echo esc_attr( $c_alignment); ?>">
                                                <a class="accordion-title <?php echo esc_attr($active); ?>" href="javascript:void(0)"><?php echo esc_html($item['faq_title']); ?> <i class="fas fa-plus"></i></a>
                                                <p class="accordion-content <?php echo esc_attr($show); ?>"><?php echo wp_kses_post($item['faq_desc']); ?></p>
                                            </li><?php
                                        } 
                                    $loop++; 
                                    } 
                                } ?>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-6 col-md-12">
                        <div class="faq-content">
                            <div class="section-title <?php echo esc_attr( $alignment); ?>">
                                <span><?php echo esc_html($settings['section_top_title']); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['section_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['section_desc'] ); ?>
                            </div>
                            <div class="faq-image">
                                <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php    
    }

       
}
Plugin::instance()->widgets_manager->register_widget_type( new FAQWidget );