<?php
namespace Elementor;
class TeamWidget extends Widget_Base{
    public function get_name(){
        return "teams-widget";
    }
    public function get_title(){
        return "Team Widget";
    }
    public function get_icon(){
        return "eicon-gallery-group";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){

    // Section controls
    $this-> start_controls_section(
        'veliki_section',
        [
            'label'=>esc_html__('Section', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_CONTENT,
        ]
    );

    $this->add_control(
        'section_show',
        [
            'label' => esc_html__( 'Section Show?', 'veliki-toolkit' ),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Show', 'veliki-toolkit' ),
            'label_off' => esc_html__( 'Hide', 'veliki-toolkit' ),
            'return_value' => 'yes',
            'default' => 'yes',
        ]
    );
    $this->add_control(
        'section_text_alignment',
        [
            'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
            ],
            'default' => '1',
            'condition' => [
                'section_show' => 'yes',
            ]
        ]
    ); 
   
    $this->add_control(
        'section_title',
        [
            'label'=>esc_html__('Title', 'veliki-toolkit'),
            'type'=>Controls_Manager:: TEXT,
            'condition' => [
                'section_show' => 'yes',
            ]
        ]
    );
    $this->add_control(
        'title_tag',
        [
            'label' => __('Title Heading Tag', 'veliki-toolkit'),
            'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                ],
            'default'     => 'h2',
            'label_block' => true,
            'condition' => [
                'section_show' => 'yes',
            ]
        ]
    );
    $this->add_control(
        'section_desc',
        [
            'label'=>esc_html__('Description', 'veliki-toolkit'),
            'type'=>Controls_Manager:: WYSIWYG,
            'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
            'condition' => [
                'section_show' => 'yes',
            ]
        ]
    );
    // End Section controls

    // Start Partner section
    $this->add_control(
        'team_controls',
        [
            'label' => esc_html__( 'Our Experts', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
        ]
    );

    $this->add_control(
        'columns',
        [
            'label' => __( 'Choose Columns', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                2   => __( '2', 'veliki-toolkit' ),
                3   => __( '3', 'veliki-toolkit' ),
                4   => __( '4', 'veliki-toolkit' ),
            ],
            'default' => 4,
        ]
    );

    $repeater = new Repeater();

    $repeater->add_control(
        'card_text_alignment',
        [
            'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
            ],
            'default' => '1'
        ]
    );

    $repeater->add_control(
        'member_img', [
            'label' => esc_html__( 'Image', 'veliki-toolkit' ),
            'type' => Controls_Manager::MEDIA,
            'label_block' => true,
        ]
    );

    $repeater->add_control(
        'name',
        [
            'label' => esc_html__( 'Member Name', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );
    $repeater->add_control(
        'name_tag',
        [
            'label' => __('Name Tag', 'veliki-toolkit'),
            'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                ],
            'default'     => 'h3',
            'label_block' => true,
        ]
    );
    $repeater->add_control(
        'designation',
        [
            'label' => esc_html__( 'Designation', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );
    $repeater->add_control(
        'icon_type', [
            'label' => esc_html__( 'Choose Icon Type', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'label_block' => true,
            'options' => [
                '1'  => __( 'Flaticon', 'veliki-toolkit' ),
                '2'  => __( 'Fontawesome', 'veliki-toolkit' ),
            ],
            'default' => '1'
        ]
    );
    $repeater->add_control(
        'flat_icon1',
        [
            'label' => esc_html__( 'Choose Social Share One', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                'flaticon-play-button'                          => esc_html__( 'Play Button', 'veliki-toolkit' ),
                'flaticon-shopping-basket'                      => esc_html__( 'Shopping Basket', 'veliki-toolkit' ),
                'flaticon-search'                               => esc_html__( 'Search', 'veliki-toolkit' ),
                'flaticon-add'                                  => esc_html__( 'Add', 'veliki-toolkit' ),
                'flaticon-add-1'                                => esc_html__( 'Add-1', 'veliki-toolkit' ),
                'flaticon-substract'                            => esc_html__( 'Add', 'veliki-toolkit' ),
                'flaticon-minus'                                => esc_html__( 'Substract', 'veliki-toolkit' ),
                'flaticon-right-arrow'                          => esc_html__( 'Right arrow', 'veliki-toolkit' ),
                'flaticon-arrow-pointing-to-right'              => esc_html__( 'Arrow pointing to right', 'veliki-toolkit' ),
                'flaticon-left-arrow'                           => esc_html__( 'Left arrow', 'veliki-toolkit' ),
                'flaticon-arrow-pointing-to-left'               => esc_html__( 'Arrow pointing to left', 'veliki-toolkit' ),
                'flaticon-facebook-letter-logo'                 => esc_html__( 'Facebook', 'veliki-toolkit' ),
                'flaticon-twitter-black-shape'                  => esc_html__( 'Twitter', 'veliki-toolkit' ),
                'flaticon-instagram-logo'                       => esc_html__( 'Instagram', 'veliki-toolkit' ),
                'flaticon-linkedin-letters'                     => esc_html__( 'Linkedin', 'veliki-toolkit' ),
                'flaticon-youtube'                              => esc_html__( 'Youtube', 'veliki-toolkit' ),
                'flaticon-top'                                  => esc_html__( 'Top', 'veliki-toolkit' ),
                'flaticon-maps-and-location'                    => esc_html__( 'Maps and location', 'veliki-toolkit' ),
                'flaticon-link-symbol'                          => esc_html__( 'Link symbol', 'veliki-toolkit' ),
                'flaticon-right-quotes-symbol'                  => esc_html__( 'Right quotes symbol', 'veliki-toolkit' ),
                'flaticon-copyright'                            => esc_html__( 'Copyright', 'veliki-toolkit' ),
                'flaticon-down-arrow'                           => esc_html__( 'Down arrow', 'veliki-toolkit' ),
                'flaticon-up-arrow'                             => esc_html__( 'Up arrow', 'veliki-toolkit' ),
                'flaticon-placeholder'                          => esc_html__( 'Placeholder', 'veliki-toolkit' ),
                'flaticon-phone-call'                           => esc_html__( 'Phone call', 'veliki-toolkit' ),
                'flaticon-message-closed-envelope'              => esc_html__( 'Message closed envelope', 'veliki-toolkit' ),
                'flaticon-big-data'                             => esc_html__( 'Big data', 'veliki-toolkit' ),
                'flaticon-code'                                 => esc_html__( 'Code', 'veliki-toolkit' ),
                'flaticon-big-data-1'                           => esc_html__( 'Big data 1', 'veliki-toolkit' ),
                'flaticon-tick'                                 => esc_html__( 'Tick', 'veliki-toolkit' ),
                'flaticon-cloud'                                => esc_html__( 'Cloud', 'veliki-toolkit' ),
                'flaticon-system'                               => esc_html__( 'System', 'veliki-toolkit' ),
                'flaticon-analysis'                             => esc_html__( 'Analysis', 'veliki-toolkit' ),
            ],
            'condition' => [
                'icon_type' => '1',
            ]
        ]
    );
    $repeater->add_control(
        'icon',
        [
            'label' => esc_html__( 'Choose Social Icon One', 'veliki-toolkit' ),
            'type' => Controls_Manager::ICON,
            'default' => 'fa fa-facebook',
            'condition' => [
                'icon_type' => '2',
            ]
        ]
    );
    $repeater->add_control(
        'url1',
        [
            'label' => esc_html__( 'URL', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );
    $repeater->add_control(
        'flat_icon2',
        [
            'label' => esc_html__( 'Choose Social Share Two', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                'flaticon-play-button'                          => esc_html__( 'Play Button', 'veliki-toolkit' ),
                'flaticon-shopping-basket'                      => esc_html__( 'Shopping Basket', 'veliki-toolkit' ),
                'flaticon-search'                               => esc_html__( 'Search', 'veliki-toolkit' ),
                'flaticon-add'                                  => esc_html__( 'Add', 'veliki-toolkit' ),
                'flaticon-add-1'                                => esc_html__( 'Add-1', 'veliki-toolkit' ),
                'flaticon-substract'                            => esc_html__( 'Add', 'veliki-toolkit' ),
                'flaticon-minus'                                => esc_html__( 'Substract', 'veliki-toolkit' ),
                'flaticon-right-arrow'                          => esc_html__( 'Right arrow', 'veliki-toolkit' ),
                'flaticon-arrow-pointing-to-right'              => esc_html__( 'Arrow pointing to right', 'veliki-toolkit' ),
                'flaticon-left-arrow'                           => esc_html__( 'Left arrow', 'veliki-toolkit' ),
                'flaticon-arrow-pointing-to-left'               => esc_html__( 'Arrow pointing to left', 'veliki-toolkit' ),
                'flaticon-facebook-letter-logo'                 => esc_html__( 'Facebook', 'veliki-toolkit' ),
                'flaticon-twitter-black-shape'                  => esc_html__( 'Twitter', 'veliki-toolkit' ),
                'flaticon-instagram-logo'                       => esc_html__( 'Instagram', 'veliki-toolkit' ),
                'flaticon-linkedin-letters'                     => esc_html__( 'Linkedin', 'veliki-toolkit' ),
                'flaticon-youtube'                              => esc_html__( 'Youtube', 'veliki-toolkit' ),
                'flaticon-top'                                  => esc_html__( 'Top', 'veliki-toolkit' ),
                'flaticon-maps-and-location'                    => esc_html__( 'Maps and location', 'veliki-toolkit' ),
                'flaticon-link-symbol'                          => esc_html__( 'Link symbol', 'veliki-toolkit' ),
                'flaticon-right-quotes-symbol'                  => esc_html__( 'Right quotes symbol', 'veliki-toolkit' ),
                'flaticon-copyright'                            => esc_html__( 'Copyright', 'veliki-toolkit' ),
                'flaticon-down-arrow'                           => esc_html__( 'Down arrow', 'veliki-toolkit' ),
                'flaticon-up-arrow'                             => esc_html__( 'Up arrow', 'veliki-toolkit' ),
                'flaticon-placeholder'                          => esc_html__( 'Placeholder', 'veliki-toolkit' ),
                'flaticon-phone-call'                           => esc_html__( 'Phone call', 'veliki-toolkit' ),
                'flaticon-message-closed-envelope'              => esc_html__( 'Message closed envelope', 'veliki-toolkit' ),
                'flaticon-big-data'                             => esc_html__( 'Big data', 'veliki-toolkit' ),
                'flaticon-code'                                 => esc_html__( 'Code', 'veliki-toolkit' ),
                'flaticon-big-data-1'                           => esc_html__( 'Big data 1', 'veliki-toolkit' ),
                'flaticon-tick'                                 => esc_html__( 'Tick', 'veliki-toolkit' ),
                'flaticon-cloud'                                => esc_html__( 'Cloud', 'veliki-toolkit' ),
                'flaticon-system'                               => esc_html__( 'System', 'veliki-toolkit' ),
                'flaticon-analysis'                             => esc_html__( 'Analysis', 'veliki-toolkit' ),
            ],
            'condition' => [
                'icon_type' => '1',
            ]
        ]
    );
    $repeater->add_control(
        'icon2',
        [
            'label' => esc_html__( 'Choose Social Icon Two', 'veliki-toolkit' ),
            'type' => Controls_Manager::ICON,
            'default' => 'fa fa-facebook',
            'condition' => [
                'icon_type' => '2',
            ]
        ]
    );
    $repeater->add_control(
        'url2',
        [
            'label' => esc_html__( 'URL', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );
    $repeater->add_control(
        'flat_icon3',
        [
            'label' => esc_html__( 'Choose Social Share Three', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                'flaticon-play-button'                          => esc_html__( 'Play Button', 'veliki-toolkit' ),
                'flaticon-shopping-basket'                      => esc_html__( 'Shopping Basket', 'veliki-toolkit' ),
                'flaticon-search'                               => esc_html__( 'Search', 'veliki-toolkit' ),
                'flaticon-add'                                  => esc_html__( 'Add', 'veliki-toolkit' ),
                'flaticon-add-1'                                => esc_html__( 'Add-1', 'veliki-toolkit' ),
                'flaticon-substract'                            => esc_html__( 'Add', 'veliki-toolkit' ),
                'flaticon-minus'                                => esc_html__( 'Substract', 'veliki-toolkit' ),
                'flaticon-right-arrow'                          => esc_html__( 'Right arrow', 'veliki-toolkit' ),
                'flaticon-arrow-pointing-to-right'              => esc_html__( 'Arrow pointing to right', 'veliki-toolkit' ),
                'flaticon-left-arrow'                           => esc_html__( 'Left arrow', 'veliki-toolkit' ),
                'flaticon-arrow-pointing-to-left'               => esc_html__( 'Arrow pointing to left', 'veliki-toolkit' ),
                'flaticon-facebook-letter-logo'                 => esc_html__( 'Facebook', 'veliki-toolkit' ),
                'flaticon-twitter-black-shape'                  => esc_html__( 'Twitter', 'veliki-toolkit' ),
                'flaticon-instagram-logo'                       => esc_html__( 'Instagram', 'veliki-toolkit' ),
                'flaticon-linkedin-letters'                     => esc_html__( 'Linkedin', 'veliki-toolkit' ),
                'flaticon-youtube'                              => esc_html__( 'Youtube', 'veliki-toolkit' ),
                'flaticon-top'                                  => esc_html__( 'Top', 'veliki-toolkit' ),
                'flaticon-maps-and-location'                    => esc_html__( 'Maps and location', 'veliki-toolkit' ),
                'flaticon-link-symbol'                          => esc_html__( 'Link symbol', 'veliki-toolkit' ),
                'flaticon-right-quotes-symbol'                  => esc_html__( 'Right quotes symbol', 'veliki-toolkit' ),
                'flaticon-copyright'                            => esc_html__( 'Copyright', 'veliki-toolkit' ),
                'flaticon-down-arrow'                           => esc_html__( 'Down arrow', 'veliki-toolkit' ),
                'flaticon-up-arrow'                             => esc_html__( 'Up arrow', 'veliki-toolkit' ),
                'flaticon-placeholder'                          => esc_html__( 'Placeholder', 'veliki-toolkit' ),
                'flaticon-phone-call'                           => esc_html__( 'Phone call', 'veliki-toolkit' ),
                'flaticon-message-closed-envelope'              => esc_html__( 'Message closed envelope', 'veliki-toolkit' ),
                'flaticon-big-data'                             => esc_html__( 'Big data', 'veliki-toolkit' ),
                'flaticon-code'                                 => esc_html__( 'Code', 'veliki-toolkit' ),
                'flaticon-big-data-1'                           => esc_html__( 'Big data 1', 'veliki-toolkit' ),
                'flaticon-tick'                                 => esc_html__( 'Tick', 'veliki-toolkit' ),
                'flaticon-cloud'                                => esc_html__( 'Cloud', 'veliki-toolkit' ),
                'flaticon-system'                               => esc_html__( 'System', 'veliki-toolkit' ),
                'flaticon-analysis'                             => esc_html__( 'Analysis', 'veliki-toolkit' ),
            ],
            'condition' => [
                'icon_type' => '1',
            ]
        ]
    );
    $repeater->add_control(
        'icon3',
        [
            'label' => esc_html__( 'Choose Social Icon Three', 'veliki-toolkit' ),
            'type' => Controls_Manager::ICON,
            'default' => 'fa fa-facebook',
            'condition' => [
                'icon_type' => '2',
            ]
        ]
    );
    $repeater->add_control(
        'url3',
        [
            'label' => esc_html__( 'URL', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );

    $this->add_control(
        'teams',
        [
            'label' => esc_html__( 'Add Experts Information', 'veliki-toolkit' ),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]
    );
    $this-> end_controls_section();

    // Start Style content controls
    $this-> start_controls_section(
        'experts_style',
        [
            'label'=>esc_html__('Experts Content', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_STYLE,
        ]
    );

    // Start Section Style
    $this->add_control(
        'title_style',
        [
            'label' => esc_html__( 'Title', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
            'condition' => [
                'section_show' => 'yes',
            ]
        ]
    );

    $this->add_control(
        'title_color',
        [
            'label' => esc_html__( 'Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
            ],
            'condition' => [
                'section_show' => 'yes',
            ]
        ]
    );

    $this->add_responsive_control(
        'title_font_size',
        [
            'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 60,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
            'condition' => [
                'section_show' => 'yes',
            ]
        ]
    );
    $this->add_control(
        'section_desc_style',
        [
            'label' => esc_html__( 'Description', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
            'condition' => [
                'section_show' => 'yes',
            ]
        ]
    );

    $this->add_responsive_control(
        'desc_font_size',
        [
            'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 20,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
            'condition' => [
                'section_show' => 'yes',
            ]
        ]
    );
    // End Section Style

    // Start Single Expert Style controls
    $this->add_control(
        'member_name',
        [
            'label' => esc_html__( 'Member Name', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
        ]
    );
    $this->add_control(
        'name_color',
        [
            'label' => esc_html__( 'Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .single-team-box .content h3, .single-team-box .content h1, .single-team-box .content h2, .single-team-box .content h4, .single-team-box .content h5, .single-team-box .content h6' => 'color: {{VALUE}}',
            ],
        ]
    );
    $this->add_responsive_control(
        'name_sz',
        [
            'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 40,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .single-team-box .content h3, .single-team-box .content h1, .single-team-box .content h2, .single-team-box .content h4, .single-team-box .content h5, .single-team-box .content h6' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );
    $this->add_control(
        'member_desig',
        [
            'label' => esc_html__( 'Member Designation', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
        ]
    );
    $this->add_responsive_control(
        'desig_sz',
        [
            'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 20,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .single-team-box .content span' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );
    $this->add_control(
        'des_hcolor',
        [
            'label' => esc_html__( 'Hover Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .single-team-box:hover .content span' => 'color: {{VALUE}}',
            ],
        ]
    );

    $this->add_control(
        'member_share',
        [
            'label' => esc_html__( 'Social Share', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
        ]
    );
    $this->add_control(
        'share_bg',
        [
            'label' => esc_html__( 'Background Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .single-team-box .image .social' => 'background-color: {{VALUE}}',
            ],
        ]
    );
    $this-> end_controls_section(); 
}
    protected function render() 
    {
        // Retrieve all controls value
        $settings = $this->get_settings_for_display();
        // Text Alignment
		if( $settings['section_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['section_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
        }
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif; 
        
        $columns = $settings['columns'];
        if ($columns == 2) {
            $column = 'col-lg-6 col-md-6';
        } elseif ($columns == 3) {
            $column = 'col-lg-4 col-md-6 col-sm-6';
        } else {
            $column = 'col-lg-3 col-md-6 col-sm-6';
        }
        ?>

        <!-- Start Team Area -->
        <div class="team-area ptb-110">
            <div class="container">
                <?php 
                if ( 'yes' === $settings['section_show'] ) { ?>
                    <div class="section-title <?php echo esc_attr( $alignment); ?>">
                        <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['section_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                        <?php echo wp_kses_post( $settings['section_desc'] ); ?>
                    </div>
                <?php } ?>

                <div class="row">
                    <?php
                    if ( $settings['teams']!='' ) : 
                        foreach ( $settings['teams'] as $item ) :
                            // Text Alignment
                            if( $item['card_text_alignment' ] == '1') {
                                $c_alignment = 'text-center';
                            } 
                            elseif( $item['card_text_alignment' ] == '2') {
                                $c_alignment = 'text-right';
                            } else {
                                $c_alignment = 'text-left';
                            }
                            if($item['name']!='' || $item['member_img']!='') : ?>
                                <div class="<?php echo esc_attr( $column ); ?>">
                                    <div class="single-team-box">
                                        <div class="image">
                                            <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $item['member_img']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">

                                            <div class="social">
                                                <?php
                                                    if ( $item['flat_icon1'] != '' || $item['icon'] != '' ) { 
                                                        if ( $item['flat_icon1'] !='' ) {
                                                            $iconcls1 = $item['flat_icon1'];
                                                        } else {
                                                            $iconcls1 = $item['icon'];
                                                        } ?>
                                                        <a href="<?php echo esc_url($item['url1']);?>" target="_blank"><i class="<?php echo esc_attr( $iconcls1 );?>"></i></a> <?php 
                                                    } 
                                                    if ( $item['flat_icon2'] != '' || $item['icon2'] != '' ) { 
                                                        if ( $item['flat_icon2'] !='' ) {
                                                            $iconcls2 = $item['flat_icon2'];
                                                        } else {
                                                            $iconcls2 = $item['icon2'];
                                                        } ?>
                                                        <a href="<?php echo esc_url($item['url2']);?>" target="_blank"><i class="<?php echo esc_attr( $iconcls2 );?>"></i></a><?php 
                                                    } 
                                                    if( $item['flat_icon3'] != '' || $item['icon3'] != '' ) { 
                                                        if ( $item['flat_icon3'] !='' ) {
                                                            $iconcls3 = $item['flat_icon3'];
                                                        } else {
                                                            $iconcls3 = $item['icon3'];
                                                        } ?>
                                                        <a href="<?php echo esc_url($item['url3']);?>" target="_blank"><i class="<?php echo esc_attr( $iconcls3 );?>"></i></a><?php 
                                                    }  
                                                ?>
                                            </div>

                                        </div>
                                        <?php if($item['name'] !='' || $item['designation'] ) : ?>
                                            <div class="content <?php echo esc_attr( $c_alignment); ?>">
                                                <<?php echo esc_attr( $item['name_tag'] ); ?>><?php echo esc_html($item['name']);?></<?php echo esc_attr( $item['name_tag'] ); ?>>
                                                <span><?php echo esc_html($item['designation']);?></span>
                                            </div> <?php
                                        endif; ?>
                                    </div>
                                </div><?php
                            endif; 
                        endforeach; 
                    endif; ?>
                </div>
            </div> 
        </div> <?php    
    }

       
}
Plugin::instance()->widgets_manager->register_widget_type( new TeamWidget );