<?php
namespace Elementor;
class VelikiTeamTwo extends Widget_Base{
    public function get_name(){
        return "teams-widget-two";
    }
    public function get_title(){
        return "Team Two";
    }
    public function get_icon(){
        return "eicon-gallery-group";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){

        // Section controls
        $this-> start_controls_section(
            'veliki_section',
            [
                'label'=>esc_html__('Section', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        ); 
        $this->add_control(
            'top_title', [
                'label'       => __( 'Top Title', 'veliki-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title', [
                'label'       => __( 'Title', 'veliki-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'heading_tag', [
                'label'   => __( 'Title Heading Tag', 'veliki-toolkit' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );
       
        $this->add_control(
            'button_text',
            [
                'label'   => __( 'Button Text', 'veliki-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __(' View All Members', 'veliki-toolkit'),
            ]
        );
        $this->add_control(
            'link_type',
            [
                'label'       => __( 'Link Type', 'veliki-toolkit' ),
                'type'        => Controls_Manager::SELECT,
                'label_block' => true,
                'options'     => [
                    '1'  => __( 'Link To Page', 'veliki-toolkit' ),
                    '2'  => __( 'External Link', 'veliki-toolkit' ),
                ],
            ]
        );
        $this->add_control(
            'link_to_page',
            [
                'label'       => __( 'Link Page', 'veliki-toolkit' ),
                'type'        => Controls_Manager::SELECT,
                'label_block' => true,
                'options'     => veliki_toolkit_get_page_as_list(),
                'condition'   => [
                    'link_type'    => '1',
                ]
            ]
        );
        $this->add_control(
            'external_link',
            [
                'label'     => __('External Link', 'veliki-toolkit'),
                'type'      => Controls_Manager:: TEXT,
                'condition' => [
                    'link_type'    => '2',
                ]
            ]
        );
        //Target Page
        $this->add_control(
            'target_page',
            [
                'label' => __( 'Link Open In New Tab?', 'veliki-toolkit' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'veliki-toolkit' ),
                'label_off' => __( 'No', 'veliki-toolkit' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // Start Partner section
        $this->add_control(
            'team_controls',
            [
                'label' => esc_html__( 'Our Experts', 'veliki-toolkit' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'veliki-toolkit' ),
                    3   => __( '3', 'veliki-toolkit' ),
                    4   => __( '4', 'veliki-toolkit' ),
                ],
                'default' => 2,
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'card_text_alignment',
            [
                'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                    '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                    '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
                ],
                'default' => '1'
            ]
        );

        $repeater->add_control(
            'member_img', [
                'label' => esc_html__( 'Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => esc_html__( 'Member Name', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'designation',
            [
                'label' => esc_html__( 'Designation', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__( 'Choose Social Icon One', 'veliki-toolkit' ),
                'type' => Controls_Manager::ICON,
                'default' => 'fa fa-facebook',
            ]
        );
        $repeater->add_control(
            'url1',
            [
                'label' => esc_html__( 'URL', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'icon2',
            [
                'label' => esc_html__( 'Choose Social Icon Two', 'veliki-toolkit' ),
                'type' => Controls_Manager::ICON,
                'default' => 'fa fa-twitter',
            ]
        );
        $repeater->add_control(
            'url2',
            [
                'label' => esc_html__( 'URL', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'icon3',
            [
                'label' => esc_html__( 'Choose Social Icon Three', 'veliki-toolkit' ),
                'type' => Controls_Manager::ICON,
                'default' => 'fa fa-instagram',
            ]
        );
        $repeater->add_control(
            'url3',
            [
                'label' => esc_html__( 'URL', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'teams',
            [
                'label' => esc_html__( 'Add Experts Information', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'shape',
            [
                'label'     => __('Shape', 'veliki-toolkit' ),
                'type'      => Controls_Manager::MEDIA,
            ]
        );
        $this-> end_controls_section();

        // Start Style content controls
        $this-> start_controls_section(
            'experts_style',
            [
                'label'=>esc_html__('Experts Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'toptitle_color',
            [
                'label'     => __( 'Top Title Color', 'veliki-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-wrap-content span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'     => 'typography_toptitle',
                'label'    => __( 'Top Title Typography', 'veliki-toolkit' ),
                'selector' => ' {{WRAPPER}} .team-wrap-content span',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'veliki-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-wrap-content .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'     => 'typography_title',
                'label'    => __( 'Title Typography', 'veliki-toolkit' ),
                 
                'selector' => ' {{WRAPPER}} .team-wrap-content .title',
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label'     => __( 'Button Color', 'veliki-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-wrap-content .team-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'     => 'typography_btn',
                'label'    => __( 'Button Typography', 'veliki-toolkit' ),
                 
                'selector' => ' {{WRAPPER}} .team-wrap-content .team-btn',
            ]
        );
        $this->add_control(
            'name_color',
            [
                'label'     => __( 'Name Color', 'veliki-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-wrap-box .content h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'     => 'typography_name',
                'label'    => __( 'Name Typography', 'veliki-toolkit' ),
                'selector' => ' {{WRAPPER}} .team-wrap-box .content h3',
            ]
        );
        $this->add_control(
            'des_color',
            [
                'label'     => __( 'Designation Color', 'veliki-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-wrap-box .content span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'     => 'typography_des',
                'label'    => __( 'Designation Typography', 'veliki-toolkit' ),
                'selector' => ' {{WRAPPER}} .team-wrap-box .content span',
            ]
        );
        $this-> end_controls_section(); 
    }
    protected function render() 
    {
        // Retrieve all controls value
        $settings = $this->get_settings_for_display();
        
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif; 
        
        $columns = $settings['columns'];
        if ($columns == 2) {
            $column = 'col-lg-6 col-md-6';
        } elseif ($columns == 3) {
            $column = 'col-lg-4 col-md-6 col-sm-6';
        } else {
            $column = 'col-lg-3 col-md-6 col-sm-6';
        }

        // Button link
        $link_source = '';
        if ( $settings['link_type'] == 1 ) :
            $link_source = get_page_link( $settings['link_to_page']); 
        else :
            $link_source = $settings['external_link'];
        endif; 
        ?>

        <!-- Start Team Area -->
        <div class="team-wrap-area pb-70">
            <div class="container">
                <div class="row align-items-center justify-content-center">
                    <div class="col-lg-5 col-md-12">
                        <div class="team-wrap-content">
                            <span><?php echo esc_html( $settings['top_title'] ); ?></span>

                            <<?php echo esc_attr( $settings['heading_tag'] ); ?> class="title"><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['heading_tag'] ); ?>>

                            <?php if ( $settings['button_text'] != '' ) : ?>
                                <?php if ( 'yes' === $settings['target_page'] ) { ?>
                                    <a target="_blank" href="<?php echo esc_url( $link_source ); ?>" class="team-btn">
                                        <i class="fas fa-long-arrow-alt-right"></i> 
                                        <?php echo esc_html( $settings['button_text'] ); ?>
                                    </a><?php
                                } else { ?>
                                    <a href="<?php echo esc_url( $link_source ); ?>" class="team-btn">
                                        <i class="fas fa-long-arrow-alt-right"></i> 
                                        <?php echo esc_html( $settings['button_text'] ); ?>
                                    </a><?php
                                } ?>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-lg-7 col-md-12">
                        <div class="row justify-content-center">
                            <?php foreach ( $settings['teams'] as $item ) : 
                                // Text Alignment
                                if( $item['card_text_alignment' ] == '1') {
                                    $alignment = 'text-center';
                                } 
                                elseif( $item['card_text_alignment' ] == '2') {
                                    $alignment = 'text-right';
                                } else {
                                    $alignment = 'text-left';
                                }
                            ?>
                                <div class="<?php echo esc_attr( $column ); ?>">
                                    <div class="team-wrap-box">
                                        <?php if( $item['member_img']['url'] != '') : ?>
                                            <div class="image">
                                                <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $item['member_img']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">
                
                                                <?php if( $item['icon'] !='' || $item['icon2'] !='' || $item['icon3'] !='' ): ?>
                                                    <div class="social">
                                                        <?php if( $item['icon'] !=''): ?>
                                                            <a href="<?php echo esc_url(  $item['url1'] ); ?>" target="_blank"><i class="<?php echo esc_attr(  $item['icon'] ); ?>"></i></a>
                                                        <?php endif; ?>
                                                        <?php if( $item['icon2'] !=''): ?>
                                                            <a href="<?php echo esc_url(  $item['url2'] ); ?>" target="_blank"><i class="<?php echo esc_attr(  $item['icon2'] ); ?>"></i></a>
                                                        <?php endif; ?>
                                                        <?php if( $item['icon3'] !=''): ?>
                                                            <a href="<?php echo esc_url(  $item['url3'] ); ?>" target="_blank"><i class="<?php echo esc_attr(  $item['icon3'] ); ?>"></i></a>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>

                                        <?php if($item['name'] !='' || $item['designation'] ) : ?>
                                            <div class="content <?php echo esc_attr( $alignment ); ?>">
                                                <h3><?php echo esc_html($item['name']);?></h3>
                                                <span><?php echo esc_html($item['designation']);?></span>
                                            </div> <?php
                                        endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>  

            <?php if( !empty( $settings['shape']['url'] ) ){ ?>
                <div class="team-wrap-shape">
                    <img src="<?php echo esc_url( $settings['shape']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                </div>
            <?php } ?>
        </div>
        <?php    
    }  
}
Plugin::instance()->widgets_manager->register_widget_type( new VelikiTeamTwo );