<?php
namespace Elementor;
class SingleResourceWidget extends Widget_Base{
    public function get_name(){
        return "single-resource-widget";
    }
    public function get_title(){
        return "Single Resource";
    }
    public function get_icon(){
        return "eicon-text";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'content_overview',
            [
                'label'=>esc_html__('Single Resource Overview', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'single_image1',
            [
                'label' => esc_html__('Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );
        $this->add_control(
            'section_text_alignment',
            [
                'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                    '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                    '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
                ],
                'default' => '3',
            ]
        ); 
        $this->add_control(
            'overview_title',
            [
                'label'=>esc_html__('Title', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'overview_desc',
            [
                'label'=>esc_html__('Content', 'veliki-toolkit'),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
            ]
        );
        $this-> end_controls_section();

        // services details overview bottom
        $this-> start_controls_section(
            'content_overview_two',
            [
                'label'=>esc_html__('Single Resource Overview Two', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'overview_title2',
            [
                'label'=>esc_html__('Title', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $this->add_control(
            'title_tag2',
            [
                'label' => __('Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'overview_desc2',
            [
                'label'=>esc_html__('Description', 'veliki-toolkit'),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
			'card_text_alignment',
			[
				'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '3'
			]
		);

        $repeater->add_control(
            'faq_title', [
                'label' => esc_html__( 'Accordion Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
    
        $repeater->add_control(
            'faq_details', [
                'label' => esc_html__( 'Accordion Details', 'veliki-toolkit' ),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
            ]
        );
    
        $this->add_control(
            'faq_content',
            [
                'label' => esc_html__( 'Add Accordion Content', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this->add_control(
            'single_image2',
            [
                'label' => esc_html__('Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );
        $this-> end_controls_section();

        // End Tab content controls

        // Start Style content controls
        $this-> start_controls_section(
            'all_content_style',
            [
                'label'=>esc_html__('Single Resources Style', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'overview_title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .resources-details-overview .resources-details-desc h3, .resources-details-overview .resources-details-desc h1, .resources-details-overview .resources-details-desc h2, .resources-details-overview .resources-details-desc h4, .resources-details-overview .resources-details-desc h5, .resources-details-overview .resources-details-desc h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'overview_title_sz',
            [
                'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 40,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .resources-details-overview .resources-details-desc h3, .resources-details-overview .resources-details-desc h1, .resources-details-overview .resources-details-desc h2, .resources-details-overview .resources-details-desc h4, .resources-details-overview .resources-details-desc h5, .resources-details-overview .resources-details-desc h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'overview_desc_sz',
            [
                'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 25,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .resources-details-overview .resources-details-desc p, .resources-details-overview .resources-details-desc ul li, .resources-details-overview .resources-details-desc ol li' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_control(
            'overview_accordion_title_color',
            [
                'label' => esc_html__( 'Accordion Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .resources-details-overview .resources-details-desc .resources-details-accordion .accordion .accordion-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'overview_accordion_title_sz',
            [
                'label' => esc_html__( 'Accordion Title Font Size', 'veliki-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 25,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .resources-details-overview .resources-details-desc .resources-details-accordion .accordion .accordion-title' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'overview_accordion_desc_sz',
            [
                'label' => esc_html__( 'Accordion Description Font Size', 'veliki-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 25,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .resources-details-overview .resources-details-desc .resources-details-accordion  .accordion .accordion-content' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this-> end_controls_section();
    }
    // Register control section end here

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        // Text Alignment
        if( $settings['section_text_alignment' ] == '1') {
            $alignment = 'text-center';
        } 
        elseif( $settings['section_text_alignment' ] == '2') {
            $alignment = 'text-right';
        } else {
            $alignment = 'text-left';
        }
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif; ?>

        <!-- Start Services Details Area -->
            <div class="resources-details-overview">
                <div class="resources-details-desc <?php echo esc_attr( $alignment); ?>">
                    <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['overview_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                    <?php echo wp_kses_post( $settings['overview_desc'] ); ?>
                </div>
                <div class="resources-details-image wow fadeInUp">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $settings['single_image1']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">
                </div>
            </div>

            <div class="resources-details-overview">
                <div class="resources-details-image wow fadeInUp">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $settings['single_image2']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">
                </div>
                <div class="resources-details-desc <?php echo esc_attr( $alignment); ?>">
                    <<?php echo esc_attr( $settings['title_tag2'] ); ?>><?php echo esc_html( $settings['overview_title2'] ); ?></<?php echo esc_attr( $settings['title_tag2'] ); ?>>

                    <?php echo wp_kses_post( $settings['overview_desc2'] ); ?>

                    <div class="resources-details-accordion">
                        <ul class="accordion">
                            <?php
                            if ( $settings['faq_content']!='' ){
                                $loop = 1;
                                foreach ( $settings['faq_content'] as $item ) {
                                    // Text Alignment
                                    if( $item['card_text_alignment' ] == '1') {
                                        $c_alignment = 'text-center';
                                    } 
                                    elseif( $item['card_text_alignment' ] == '2') {
                                        $c_alignment = 'text-right';
                                    } else {
                                        $c_alignment = 'text-left';
                                    }
                                    if ($loop == 1) {
                                        $active = 'active';
                                        $show = 'show';
                                    }else {
                                        $active = '';
                                        $show = '';
                                    }

                                    if($item['faq_title']!='' || $item['faq_details']!='') { ?>
                                    <li class="accordion-item <?php echo esc_attr( $c_alignment); ?>">
                                        <a class="accordion-title <?php echo esc_attr($active); ?>" href="javascript:void(0)"><?php echo esc_html($item['faq_title']); ?> <i class="fa fa-plus"></i></a>
                                        <p class="accordion-content <?php echo esc_attr($show); ?>"><?php echo wp_kses_post($item['faq_details']); ?></p>
                                    </li><?php
                                    } 
                                $loop++; 
                                } 
                            } ?>

                        </ul>
                    </div>
                </div>
            </div>
        <!-- End Services Details Area -->
        <?php
    }

       
}
Plugin::instance()->widgets_manager->register_widget_type( new SingleResourceWidget );