<?php
namespace Elementor;
class ServiceWidget extends Widget_Base{
    public function get_name(){
        return "service-widget";
    }
    public function get_title(){
        return "Services";
    }
    public function get_icon(){
        return "eicon-favorite";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){

        // Choose Services Style
        $this-> start_controls_section(
            'all_services_content',
            [
                'label'=>esc_html__('Services Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'services_style',
            [
                'label' => esc_html__( 'Choose a Style', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    '1'   => esc_html__( 'Slider Style', 'veliki-toolkit' ),
                    '2'   => esc_html__( 'Card Style', 'veliki-toolkit' ),
                ],
                'default' => '1',
            ]
        );

        $this->add_control(
            'card_text_alignment',
            [
                'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                    '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                    '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
                ],
                'default' => '1'
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'veliki-toolkit' ),
                    3   => __( '3', 'veliki-toolkit' ),
                    4   => __( '4', 'veliki-toolkit' ),
                ],
                'default' => 3,
                'condition' => [
                    'services_style' => '2',
                ]
            ]
        );

        $this->add_control(
            'count',
            [
                'label' => esc_html__( 'Post Per Page', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('if you went to see all post type -1','veliki-toolkit')
            ]
        );
    
        $this->add_control(
            'order',
            [
                'label' => esc_html__( 'Select Order', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC'  => esc_html__( 'DESC', 'veliki-toolkit' ),
                    'ASC'  => esc_html__( 'ASC', 'veliki-toolkit' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->add_control(
            'learn_more_btntext',
            [
                'label' => esc_html__( 'Learn More Button Text', 'veliki-toolkit' ),
                'default' => esc_html__( 'Learn More', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
			'section_shape',
			[
				'label' => esc_html__( 'Hide Shapes?', 'veliki-toolkit' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'veliki-toolkit' ),
				'label_off' => esc_html__( 'Hide', 'veliki-toolkit' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
        );
        $this-> end_controls_section();
        // End Tab content controls

        // Start Services card Style
        $this-> start_controls_section(
            'services_content_style',
            [
                'label'=>esc_html__('Services Style', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-services-box h3 a, .single-services-box h1 a, .single-services-box h2 a, .single-services-box h4 a, .single-services-box h5 a, .single-services-box h6 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 40,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .single-services-box h3, .single-services-box h1, .single-services-box h2, .single-services-box h4, .single-services-box h5, .single-services-box h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_responsive_control(
			'service_desc_font_size',
			[
				'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .single-services-box p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_responsive_control(
			'read_more_font_size',
			[
				'label' => esc_html__( 'Read More Button Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .learn-more-btn' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'title_hcolor',
            [
                'label' => esc_html__( 'Title Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-services-box:hover h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'desc_hcolor',
            [
                'label' => esc_html__( 'Description Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-services-box:hover p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hcolor',
            [
                'label' => esc_html__( 'Learn More Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-services-box:hover .learn-more-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this-> end_controls_section();
        // Start Services card Style
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        // Text Alignment
        if( $settings['card_text_alignment' ] == '1') {
            $c_alignment = 'text-center';
        } 
        elseif( $settings['card_text_alignment' ] == '2') {
            $c_alignment = 'text-right';
        } else {
            $c_alignment = 'text-left';
        }
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        $columns = $settings['columns'];
        if ($columns == 2) {
            $column = 'col-lg-6 col-md-6';
        } elseif ($columns == 4) {
            $column = 'col-lg-3 col-md-6 col-sm-6';
        } else {
            $column = 'col-lg-4 col-md-6 col-sm-6';
        }

        $args = array(
            'post_type' => 'service',
            'posts_per_page' => $settings['count'],
            'order' => $settings['order'],
        );

        $services_array = new \WP_Query( $args ); ?>

        <?php
        if( $settings['services_style'] == 1 ) { ?>
            <div class="featured-services-area ptb-110">
                <div class="container">
                    <div class="row">
                    <?php if ( $settings['count'] == '1' ) { ?>
                        <div class="col-lg-6 col-md-12 offset-lg-3"><?php
                    } elseif ( $settings['count'] == '2' ) { ?>
                        <div class="container">
                        <div class="row"><?php
                    } else { ?>
                        <div class="featured-services-slides owl-carousel owl-theme"><?php
                    }
                            while($services_array->have_posts()): $services_array->the_post();
                                // Color Class
                                if( class_exists( 'ACF') && get_field('choose_color')) {
                                    $color = get_field('choose_color');
                                    if( $color == 'green') {
                                        $color = " bg-dfffd7";
                                    } elseif( $color == 'pink' ) {
                                        $color = " bg-ffb8c8";
                                    } elseif( $color == 'aqua' ) {
                                        $color = " bg-cefffe";
                                    } else {
                                        $color = " ";
                                    }
                                } else {
                                    $color = " ";
                                }

                                if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                                    $post_link = get_the_permalink();
                                } else {
                                    $post_link = get_field('external_link');
                                }
                                
                                // ACF field access
                                if (class_exists( 'ACF') && get_field('choose_icon')){
                                    $icon = get_field('choose_icon');
                                } else{
                                    $icon = '';
                                } ?>
                                <?php if( $settings['count'] == '2' ) { ?>
                                    <div class="col-lg-6 col-md-6"> <?php
                                } else { ?>
                                <div class="col-lg-12 col-md-12"> <?php
                                } ?>
                                    <div class="single-services-box <?php echo esc_attr( $c_alignment); ?>">
                                        <div class="icon <?php echo esc_attr( $color ); ?>">
                                            <i class="<?php echo esc_attr( $icon ); ?>"></i>
                                        </div>
            
                                        <<?php echo esc_attr( $settings['title_tag'] ); ?>><a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                        <p><?php the_excerpt(); ?></p>
                                        <a href="<?php echo esc_url( $post_link ); ?>" target="_blank" class="learn-more-btn"><?php echo esc_html( $settings['learn_more_btntext'] ); ?> <i class="flaticon-add-1"></i></a>
                                    </div>
                                </div>
                            <?php
                                endwhile;
                                wp_reset_query();
                            ?>
                        <?php if( $settings['count'] == '2' ) { ?>
                            </div>
                        <?php } ?>
                        </div>
                    </div>
                </div>

                <?php if ( 'yes' === $settings['section_shape'] ) : ?>
                    <div class="shape4">
                        <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/shape/1.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                    </div>
                    <div class="shape5">
                        <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/shape/1.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                    </div>
                <?php endif; ?>
            </div>
            <?php
        } 
        else { ?>
            <div class="featured-services-area ptb-110">
                <div class="container">
                    <div class="row">
                        <?php while($services_array->have_posts()): $services_array->the_post();
                            // Color Class
                            if( class_exists( 'ACF') && get_field('choose_color')) {
                                $color = get_field('choose_color');
                                if( $color == 'green') {
                                    $color = " bg-dfffd7";
                                } elseif( $color == 'pink' ) {
                                    $color = " bg-ffb8c8";
                                } elseif( $color == 'aqua' ) {
                                    $color = " bg-cefffe";
                                } else {
                                    $color = " ";
                                }
                            } else {
                                $color = " ";
                            }

                            if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                                $post_link = get_the_permalink();
                            } else {
                                $post_link = get_field('external_link');
                            }
                            
                            // ACF field access
                            if (class_exists( 'ACF') && get_field('choose_icon')){
                                $icon = get_field('choose_icon');
                            } else{
                                $icon = '';
                            } ?>
                            <div class="<?php echo esc_attr( $column ); ?>">
                                <div class="single-services-box <?php echo esc_attr( $c_alignment); ?>">
                                    <div class="icon <?php echo esc_attr( $color ); ?>">
                                        <i class="<?php echo esc_attr( $icon ); ?>"></i>
                                    </div>
        
                                    <<?php echo esc_attr( $settings['title_tag'] ); ?>><a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                    <p><?php echo esc_html( wp_trim_words( get_the_excerpt(), 17, ' ' ) ); ?></p>
                                    <a href="<?php echo esc_url( $post_link ); ?>" target="_blank" class="learn-more-btn"><?php echo esc_html( $settings['learn_more_btntext'] ); ?> <i class="flaticon-add-1"></i></a>
                                </div>
                            </div>
                        <?php
                            endwhile;
                            wp_reset_query();
                        ?>
                    </div>
                </div>
                
                <?php if ( 'yes' === $settings['section_shape'] ) : ?>
                    <div class="shape4">
                        <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/shape/1.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                    </div>
                    <div class="shape5">
                        <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/shape/1.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                    </div>
                <?php endif; ?>
            </div> <?php
        } ?>
        <?php
    }

       
}
Plugin::instance()->widgets_manager->register_widget_type( new ServiceWidget );