<?php
namespace Elementor;
class ServicesTwo extends Widget_Base{
    public function get_name(){
        return "service-two";
    }
    public function get_title(){
        return "Services Two";
    }
    public function get_icon(){
        return "eicon-favorite";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){

        // Choose Services Style
        $this-> start_controls_section(
            'all_services_content',
            [
                'label' => esc_html__('Services Content', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'top_title',
            [
                'label'   => esc_html__('Top Title', 'veliki-toolkit'),
                'type'    => Controls_Manager:: TEXT,
                'default' => __('More Than Solutions', 'veliki-toolkit'),
            ]
        );
        $this->add_control(
            'sec_title',
            [
                'label'   => esc_html__('Section Title', 'veliki-toolkit'),
                'type'    => Controls_Manager:: TEXTAREA,
                'default' => __('Big Data Engineers & Architects | Deep Expertise In Aws And Azure', 'veliki-toolkit'),
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'card_text_alignment',
            [
                'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                    '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                    '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
                ],
                'default' => '1'
            ]
        );
        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'veliki-toolkit' ),
                    3   => __( '3', 'veliki-toolkit' ),
                    4   => __( '4', 'veliki-toolkit' ),
                ],
                'default' => 4,
            ]
        );

        $this->add_control(
            'post_title_tag',
            [
                'label' => __('Post Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'count',
            [
                'label' => esc_html__( 'Post Per Page', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('if you went to see all post type -1','veliki-toolkit')
            ]
        );
    
        $this->add_control(
            'order',
            [
                'label' => esc_html__( 'Select Order', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC'  => esc_html__( 'DESC', 'veliki-toolkit' ),
                    'ASC'  => esc_html__( 'ASC', 'veliki-toolkit' ),
                ],
                'default' => 'DESC',
            ]
        );
        $this->add_control(
            'excerpt_num',
            [
                'label'   => __( 'Excerpt', 'veliki-toolkit' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 14,
            ]
        );
        $this->add_control(
            'cat_name',
            [
                'label' => __( 'Choose Category', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => veliki_toolkit_get_page_services_cat_el(),
            ]
        );
        $this-> end_controls_section();
        // End Tab content controls

        // Start Services card Style
        $this-> start_controls_section(
            'services_content_style',
            [
                'label'=>esc_html__('Services Style', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'toptitle_color',
            [
                'label' => esc_html__( 'Top Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'toptitle_font_size',
			[
				'label' => esc_html__( 'Top Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 40,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title .sub-title' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 40,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_control(
            'card_color',
            [
                'label' => esc_html__( 'Card Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .solutions-wrap-card' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_hcolor',
            [
                'label' => esc_html__( 'Card Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .solutions-wrap-card::before' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .solutions-wrap-card .icon i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bgcolor',
            [
                'label' => esc_html__( 'Icon Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .solutions-wrap-card .icon i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'posttitle_tolor',
            [
                'label' => esc_html__( 'Posts Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .solutions-wrap-card .title a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'posttitle_hcolor',
            [
                'label' => esc_html__( 'Posts Title Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .solutions-wrap-card:hover h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'posttitle_font_size',
			[
				'label' => esc_html__( 'Posts Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 40,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .solutions-wrap-card .title a' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Description Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .solutions-wrap-card p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'desc_hcolor',
            [
                'label' => esc_html__( 'Description Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .solutions-wrap-card:hover p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'desc_font_size',
			[
				'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 40,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .solutions-wrap-card p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this-> end_controls_section();
        // Start Services card Style
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        // Text Alignment
        if( $settings['card_text_alignment' ] == '1') {
            $c_alignment = 'text-center';
        } 
        elseif( $settings['card_text_alignment' ] == '2') {
            $c_alignment = 'text-right';
        } else {
            $c_alignment = 'text-left';
        }
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        $columns = $settings['columns'];
        if ($columns == 2) {
            $column = 'col-lg-6 col-sm-6';
        } elseif ($columns == 4) {
            $column = 'col-lg-3 col-sm-6';
        } else {
            $column = 'col-lg-4 col-sm-6';
        }
        
        // Services Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'         => 'service',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'service_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'service',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
            );
        }
        $services_array = new \WP_Query( $args );
        
        ?>

        <div class="solutions-wrap-area pt-100 pb-70">
            <div class="container">
                <?php if($settings['top_title'] != '' || $settings['sec_title'] != ''): ?>
                    <div class="section-title">
                        <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                        <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo wp_kses_post( $settings['sec_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    </div>
                <?php endif; ?>
                <div class="row justify-content-center">
                    <?php while($services_array->have_posts()): $services_array->the_post();

                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }
                        
                        // ACF field access
                        if (class_exists( 'ACF') && get_field('choose_icon')){
                            $icon = get_field('choose_icon');
                        } else{
                            $icon = '';
                        } 
                    ?>

                    <div class="<?php echo esc_attr( $column ); ?>">
                        <div class="solutions-wrap-card <?php echo esc_attr( $c_alignment); ?>">
                            <<?php echo esc_attr( $settings['post_title_tag'] ); ?>><a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a></<?php echo esc_attr( $settings['post_title_tag'] ); ?>>
                            <?php if( $icon ): ?>
                                <div class="icon">
                                    <i class="<?php echo esc_attr( $icon ); ?>"></i>

                                    <div class="circles-box">
                                        <div class="circle-one"></div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>
                        </div>
                    </div>

                    <?php endwhile;
                        wp_reset_query();
                    ?>
                </div>
            </div>
        </div>

        <?php
    } 
}
Plugin::instance()->widgets_manager->register_widget_type( new ServicesTwo );