<?php
namespace Elementor;
class ServicesThree extends Widget_Base{
    public function get_name(){
        return "servicethree";
    }
    public function get_title(){
        return "Services Three";
    }
    public function get_icon(){
        return "eicon-favorite";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){

        // Choose Services Style
        $this-> start_controls_section(
            'all_services_content',
            [
                'label' => esc_html__('Services Content', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'top_title',
            [
                'label'   => esc_html__('Top Title', 'veliki-toolkit'),
                'type'    => Controls_Manager:: TEXT,
                'default' => __('More Than Solutions', 'veliki-toolkit'),
            ]
        );
        $this->add_control(
            'sec_title',
            [
                'label'   => esc_html__('Section Title', 'veliki-toolkit'),
                'type'    => Controls_Manager:: TEXTAREA,
                'default' => __('Big Data Engineers & Architects | Deep Expertise In Aws And Azure', 'veliki-toolkit'),
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'card_text_alignment',
            [
                'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                    '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                    '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
                ],
                'default' => '3'
            ]
        );
        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'veliki-toolkit' ),
                    3   => __( '3', 'veliki-toolkit' ),
                    4   => __( '4', 'veliki-toolkit' ),
                ],
                'default' => 2,
            ]
        );

        $this->add_control(
            'post_title_tag',
            [
                'label' => __('Post Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'count',
            [
                'label' => esc_html__( 'Post Per Page', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('if you went to see all post type -1','veliki-toolkit')
            ]
        );
    
        $this->add_control(
            'order',
            [
                'label' => esc_html__( 'Select Order', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC'  => esc_html__( 'DESC', 'veliki-toolkit' ),
                    'ASC'  => esc_html__( 'ASC', 'veliki-toolkit' ),
                ],
                'default' => 'DESC',
            ]
        );
        $this->add_control(
            'excerpt_num',
            [
                'label'   => __( 'Excerpt', 'veliki-toolkit' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 12,
            ]
        );
        $this->add_control(
            'cat_name',
            [
                'label' => __( 'Choose Category', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => veliki_toolkit_get_page_services_cat_el(),
            ]
        );
        $this-> end_controls_section();
        // End Tab content controls

        // Start Services card Style
        $this-> start_controls_section(
            'services_content_style',
            [
                'label'=>esc_html__('Services Style', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'secbg_color',
            [
                'label' => esc_html__( 'Section Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-area' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'toptitle_color',
            [
                'label' => esc_html__( 'Top Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'toptitle_font_size',
			[
				'label' => esc_html__( 'Top Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 40,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title .sub-title' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 40,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_control(
            'card_color',
            [
                'label' => esc_html__( 'Card Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-card' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_hcolor',
            [
                'label' => esc_html__( 'Card Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-card::before' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'posttitle_tolor',
            [
                'label' => esc_html__( 'Posts Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-card .content h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'posttitle_hcolor',
            [
                'label' => esc_html__( 'Posts Title Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-card:hover .content h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'posttitle_font_size',
			[
				'label' => esc_html__( 'Posts Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 40,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .services-wrap-card .content h3 a' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Description Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-card .content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'desc_hcolor',
            [
                'label' => esc_html__( 'Description Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-card:hover .content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'desc_font_size',
			[
				'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 40,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .services-wrap-card .content p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this-> end_controls_section();
        // Start Services card Style
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        // Text Alignment
        if( $settings['card_text_alignment' ] == '1') {
            $c_alignment = 'text-center';
        } 
        elseif( $settings['card_text_alignment' ] == '2') {
            $c_alignment = 'text-right';
        } else {
            $c_alignment = 'text-left';
        }

        $columns = $settings['columns'];
        if ($columns == 2) {
            $column = 'col-lg-6 col-md-6';
        } elseif ($columns == 4) {
            $column = 'col-lg-3 col-md-6';
        } else {
            $column = 'col-lg-4 col-md-6';
        }
        
        // Services Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'         => 'service',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'service_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'service',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
            );
        }
        $services_array = new \WP_Query( $args );
        
        ?>
        <div class="services-wrap-area pt-100 pb-70">
            <div class="container">
                <?php if($settings['top_title'] != '' || $settings['sec_title'] != ''): ?>
                    <div class="section-title">
                        <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                        <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo wp_kses_post( $settings['sec_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    </div>
                <?php endif; ?>

                <div class="row justify-content-center">
                    <?php while($services_array->have_posts()): $services_array->the_post();

                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        } 
                    ?>
                    <div class="<?php echo esc_attr( $column ); ?>">
                        <div class="services-wrap-card <?php echo esc_attr( $c_alignment); ?>">
                            <div class="d-flex justify-content-between align-items-center">
                                <?php if(has_post_thumbnail()) { ?>
                                    <div class="image-icon">
                                        <img src="<?php the_post_thumbnail_url('full') ?>" alt="<?php echo esc_attr__('blog image', 'veliki')?>">

                                        <div class="circles-box">
                                            <div class="circle-one"></div>
                                        </div>
                                    </div>
                                <?php } ?>

                                <div class="content">
                                    <<?php echo esc_attr( $settings['post_title_tag'] ); ?>><a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a></<?php echo esc_attr( $settings['post_title_tag'] ); ?>>
                                    <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php endwhile;
                        wp_reset_query();
                    ?>
                </div>
            </div>
        </div>
        <?php
    } 
}
Plugin::instance()->widgets_manager->register_widget_type( new ServicesThree );