<?php
namespace Elementor;
class ServicesFour extends Widget_Base{
    public function get_name(){
        return "servicesfour";
    }
    public function get_title(){
        return "Services Four";
    }
    public function get_icon(){
        return "eicon-favorite";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){

        // Choose Services Style
        $this-> start_controls_section(
            'all_services_content',
            [
                'label' => esc_html__('Services Content', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'top_title',
            [
                'label'   => esc_html__('Top Title', 'veliki-toolkit'),
                'type'    => Controls_Manager:: TEXT,
                'default' => __('More Than Solutions', 'veliki-toolkit'),
            ]
        );
        $this->add_control(
            'sec_title',
            [
                'label'   => esc_html__('Section Title', 'veliki-toolkit'),
                'type'    => Controls_Manager:: TEXTAREA,
                'default' => __('Big Data Engineers & Architects | Deep Expertise In Aws And Azure', 'veliki-toolkit'),
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'card_text_alignment',
            [
                'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                    '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                    '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
                ],
                'default' => '3'
            ]
        );
        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'veliki-toolkit' ),
                    3   => __( '3', 'veliki-toolkit' ),
                    4   => __( '4', 'veliki-toolkit' ),
                ],
                'default' => 3,
            ]
        );

        $this->add_control(
            'post_title_tag',
            [
                'label' => __('Post Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'count',
            [
                'label' => esc_html__( 'Post Per Page', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('if you went to see all post type -1','veliki-toolkit')
            ]
        );
    
        $this->add_control(
            'order',
            [
                'label' => esc_html__( 'Select Order', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC'  => esc_html__( 'DESC', 'veliki-toolkit' ),
                    'ASC'  => esc_html__( 'ASC', 'veliki-toolkit' ),
                ],
                'default' => 'DESC',
            ]
        );
        $this->add_control(
            'excerpt_num',
            [
                'label'   => __( 'Excerpt', 'veliki-toolkit' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 12,
            ]
        );
        $this->add_control(
            'cat_name',
            [
                'label' => __( 'Choose Category', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => veliki_toolkit_get_page_services_cat_el(),
            ]
        );
        $this->add_control(
            'read_more',
            [
                'label' => esc_html__( 'Read More', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Read More','veliki-toolkit')
            ]
        );
        $this-> end_controls_section();
        // End Tab content controls

        // Start Services card Style
        $this-> start_controls_section(
            'services_content_style',
            [
                'label'=>esc_html__('Services Style', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'secbg_color',
            [
                'label' => esc_html__( 'Section Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-area-with-main-color' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'toptitle_color',
            [
                'label' => esc_html__( 'Top Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-area-with-main-color .section-title .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'toptitle_typography',
                'label' => __( 'Top Title Typography', 'cyarb-toolkit' ),
                'selector' => '{{WRAPPER}} .services-area-with-main-color .section-title .sub-title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-area-with-main-color .section-title .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __( 'Title Typography', 'cyarb-toolkit' ),
                'selector' => '{{WRAPPER}} .services-area-with-main-color .section-title .title',
            ]
        );
        $this->add_control(
            'card_color',
            [
                'label' => esc_html__( 'Card Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'posttitle_tolor',
            [
                'label' => esc_html__( 'Posts Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-box .content h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'posttitle_hcolor',
            [
                'label' => esc_html__( 'Posts Title Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-box:hover .content h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ptitle_typography',
                'label' => __( 'Posts Title Typography', 'cyarb-toolkit' ),
                'selector' => '{{WRAPPER}} .services-wrap-box .content h3 a',
            ]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Description Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-box .content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'desc_hcolor',
            [
                'label' => esc_html__( 'Description Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-box:hover .content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'pdesc_typography',
                'label' => __( 'Description Typography', 'cyarb-toolkit' ),
                'selector' => '{{WRAPPER}} .services-wrap-box:hover .content p',
            ]
        );
        $this->add_control(
            'rmcolor',
            [
                'label' => esc_html__( 'Button Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-box .content .services-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'rm_hcolor',
            [
                'label' => esc_html__( 'Button Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-wrap-box:hover .content .services-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'rm_typography',
                'label' => __( 'Button Typography', 'cyarb-toolkit' ),
                'selector' => '{{WRAPPER}} .services-wrap-box .content .services-btn',
            ]
        );
        $this-> end_controls_section();
        // Start Services card Style
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        // Text Alignment
        if( $settings['card_text_alignment' ] == '1') {
            $c_alignment = 'text-center';
        } 
        elseif( $settings['card_text_alignment' ] == '2') {
            $c_alignment = 'text-right';
        } else {
            $c_alignment = 'text-left';
        }

        $columns = $settings['columns'];
        if ($columns == 2) {
            $column = 'col-lg-6 col-sm-6';
        } elseif ($columns == 4) {
            $column = 'col-lg-3 col-sm-6';
        } else {
            $column = 'col-lg-4 col-sm-6';
        }
        
        // Services Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'         => 'service',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'service_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'service',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
            );
        }
        $services_array = new \WP_Query( $args );
        
        ?>

        <div class="services-area-with-main-color pt-100 pb-70">
            <div class="container">
                <?php if($settings['top_title'] != '' || $settings['sec_title'] != ''): ?>
                    <div class="section-title">
                        <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                        <<?php echo esc_attr( $settings['title_tag'] ); ?> class="title"><?php echo wp_kses_post( $settings['sec_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    </div>
                <?php endif; ?>

                <div class="row justify-content-center">
                    <?php while($services_array->have_posts()): $services_array->the_post();
                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        } 
                    ?>
                        <div class="<?php echo esc_attr( $column ); ?>">
                            <div class="services-wrap-box <?php echo esc_attr( $c_alignment); ?>">
                                <?php if(has_post_thumbnail()) { ?>
                                    <img src="<?php the_post_thumbnail_url('full') ?>" alt="<?php echo esc_attr__('blog image', 'veliki')?>">
                                <?php } ?>
                                    
                                <div class="content">
                                    <<?php echo esc_attr( $settings['post_title_tag'] ); ?>><a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a></<?php echo esc_attr( $settings['post_title_tag'] ); ?>>
                                    <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>

                                    <?php if( $settings['read_more' ] != '' ): ?>
                                        <a href="<?php echo esc_url( $post_link ); ?>" class="services-btn"><?php echo esc_html( $settings['read_more' ] ); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;
                        wp_reset_query();
                    ?>
                </div>
            </div>
        </div>
        <?php
    } 
}
Plugin::instance()->widgets_manager->register_widget_type( new ServicesFour );