<?php
namespace Elementor;
class ResourcesWidget extends Widget_Base{
    public function get_name(){
        return "resource-widget";
    }
    public function get_title(){
        return "Resources";
    }
    public function get_icon(){
        return "eicon-posts-group";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){

        // Resources controls 
        $this-> start_controls_section(
            'all_content',
            [
                'label'=>esc_html__('Resources Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'choose_style',
            [
                'label' => esc_html__( 'Choose a Style', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    '1'   => esc_html__( 'Slider Style', 'veliki-toolkit' ),
                    '2'   => esc_html__( 'Card Style', 'veliki-toolkit' ),
                ],
                'default' => '1',
            ]
        );

        $this->add_control(
            'section_show',
            [
                'label' => esc_html__( 'Section Show?', 'veliki-toolkit' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'veliki-toolkit' ),
                'label_off' => esc_html__( 'Hide', 'veliki-toolkit' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'choose_style' => '1',
                ]
            ]
        );

        $this->add_control(
            'section_text_alignment',
            [
                'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                    '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                    '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
                ],
                'default' => '1',
                'condition' => [
                    'section_show' => 'yes',
                ]
            ]
        ); 

        $this->add_control(
            'section_title',
            [
                'label'=>esc_html__('Title', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
                'condition' => [
                    'section_show' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
                'condition' => [
                    'section_show' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'section_desc',
            [
                'label'=>esc_html__('Description', 'veliki-toolkit'),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
                'condition' => [
                    'section_show' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'card_text_alignment',
            [
                'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                    '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                    '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
                ],
                'default' => '3'
            ]
        );

        $this->add_control(
            'res_title_tag',
            [
                'label' => __('Card Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'veliki-toolkit' ),
                    3   => __( '3', 'veliki-toolkit' ),
                    4   => __( '4', 'veliki-toolkit' ),
                ],
                'default' => 3,
                'condition' => [
                    'choose_style' => '2',
                ]
            ]
        );

        $this->add_control(
            'count',
            [
                'label' => esc_html__( 'Post Per Page', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('if you went to see all post type -1','veliki-toolkit'),
                'default' => '6'
            ]
        );
    
        $this->add_control(
            'order',
            [
                'label' => esc_html__( 'Select Order', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC'  => esc_html__( 'DESC', 'veliki-toolkit' ),
                    'ASC'  => esc_html__( 'ASC', 'veliki-toolkit' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->add_control(
            'learn_more_btntext',
            [
                'label' => esc_html__( 'Read More Button Text', 'veliki-toolkit' ),
                'default' => esc_html__( 'Read More', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this-> end_controls_section();
        // End Tab content controls

        // Start Resources card Style
        $this-> start_controls_section(
            'all_content_style',
            [
                'label'=>esc_html__('Resources Style', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Section Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'section_show' => 'yes',
                ]
            ]
        );
        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Section Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 60,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'section_show' => 'yes',
                ]
			]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Section Description Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'section_show' => 'yes',
                ]
            ]
        );
        $this->add_responsive_control(
			'desc_font_size',
			[
				'label' => esc_html__( 'Section Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 30,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'section_show' => 'yes',
                ]
			]
        );
        $this->add_control(
            're_title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-resources-box .resources-content h3 a, .single-resources-box .resources-content h1 a, .single-resources-box .resources-content h2 a, .single-resources-box .resources-content h4 a, .single-resources-box .resources-content h5 a, .single-resources-box .resources-content h6 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			're_title_font_size',
			[
				'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 40,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .single-resources-box .resources-content h3, .single-resources-box .resources-content h1, .single-resources-box .resources-content h2, .single-resources-box .resources-content h4, .single-resources-box .resources-content h5, .single-resources-box .resources-content h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_responsive_control(
			're_desc_font_size',
			[
				'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .single-resources-box .resources-content p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_responsive_control(
			'read_more_font_size',
			[
				'label' => esc_html__( 'Read More Button Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .learn-more-btn' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this-> end_controls_section();
        // Start Services card Style
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        // Text Alignment
		if( $settings['section_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['section_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
        }
        // Text Alignment
        if( $settings['card_text_alignment' ] == '1') {
            $c_alignment = 'text-center';
        } 
        elseif( $settings['card_text_alignment' ] == '2') {
            $c_alignment = 'text-right';
        } else {
            $c_alignment = 'text-left';
        }
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        // Column
        $columns = $settings['columns'];
        if ($columns == 2) {
            $column = 'col-lg-6 col-md-6';
        } elseif ($columns == 4) {
            $column = 'col-lg-3 col-md-6';
        } else {
            $column = 'col-lg-4 col-md-6';
        }

        $args = array(
            'post_type' => 'resource',
            'posts_per_page' => $settings['count'],
            'order' => $settings['order'],
        );

        $query_array = new \WP_Query( $args ); ?>

        <?php
        if( $settings['choose_style'] == 1 ) { ?>
            <div class="resources-area ptb-110">
                <div class="container">
                    <?php if ( 'yes' === $settings['section_show'] ) : ?>
                        <div class="section-title <?php echo esc_attr( $alignment); ?>">
                            <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['section_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                            <?php echo wp_kses_post( $settings['section_desc'] ); ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <?php if ( $settings['count'] == '1' ) { ?>
                <div class="container">
                <div class="col-lg-6 col-md-12 offset-lg-3"><?php
                } elseif ( $settings['count'] == '2' || $settings['count'] == '3' ) { ?>
                <div class="container">
                <div class="row"><?php
                } else { ?>
                <div class="resources-slides owl-carousel owl-theme"><?php
                } ?>
                    <?php while($query_array->have_posts()): $query_array->the_post(); 
                    if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                        $post_link = get_the_permalink();
                    } else {
                        $post_link = get_field('external_link');
                    } ?>
                        <?php if ( $settings['count'] == '2' ) { ?>
                        <div class="col-lg-6 col-md-6">
                        <?php } elseif( $settings['count'] == '3' ){ ?>
                        <div class="col-lg-4 col-md-6"> <?php
                        } ?>
                        <div class="single-resources-box">
                            <div class="resources-image">
                                <a href="<?php echo esc_url( $post_link ); ?>"><img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'veliki_resource_thumb')); ?>" alt="image"></a>
                            </div>

                            <div class="resources-content <?php echo esc_attr( $c_alignment); ?>">
                                <<?php echo esc_attr( $settings['res_title_tag'] ); ?>><a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a></<?php echo esc_attr( $settings['res_title_tag'] ); ?>>
                                <p><?php the_excerpt(); ?></p>
                                <a href="<?php echo esc_url( $post_link ); ?>" target="_blank" class="learn-more-btn"><?php echo esc_html( $settings['learn_more_btntext'] ); ?> <i class="flaticon-add-1"></i></a>
                            </div>
                        </div>
                        <?php if ( $settings['count'] == '2' || $settings['count'] == '3' ) { ?>
                        </div>
                        <?php } ?>
                    <?php
                        endwhile;
                        wp_reset_query();
                    ?>
               <?php if ( $settings['count'] == '2' || $settings['count'] == '3' ) { ?>
                </div>
                </div>
                <?php } ?>
                </div>

            </div> <?php
        } 
        else { ?>
            <div class="resources-area ptb-110">
                <div class="container">
                    <div class="row">
                        <?php while($query_array->have_posts()): $query_array->the_post();
                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        } ?>
                            <div class="<?php echo esc_attr( $column ); ?>">
                                <div class="single-resources-box">
                                    <div class="resources-image">
                                        <a href="<?php echo esc_url( $post_link ); ?>"><img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'veliki_resource_thumb')); ?>" alt="image"></a>
                                    </div>

                                    <div class="resources-content <?php echo esc_attr( $c_alignment); ?>">
                                        <h3><a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a></h3>
                                        <p><?php the_excerpt(); ?></p>
                                        <a href="<?php echo esc_url( $post_link ); ?>" target="_blank" class="learn-more-btn"><?php echo esc_html( $settings['learn_more_btntext'] ); ?> <i class="flaticon-add-1"></i></a>
                                    </div>
                                </div>
                            </div>
                        <?php
                            endwhile;
                            wp_reset_query();
                        ?>
                    </div>
                </div>
            </div> <?php
        } ?>
        <?php
    }

       
}
Plugin::instance()->widgets_manager->register_widget_type( new ResourcesWidget );