<?php
namespace Elementor;
class ResourcesWidgetTwo extends Widget_Base{
    public function get_name(){
        return "resource-widgetTwo";
    }
    public function get_title(){
        return "Resources Two";
    }
    public function get_icon(){
        return "eicon-posts-group";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){

        // Resources controls 
        $this-> start_controls_section(
            'all_content',
            [
                'label'=>esc_html__('Resources Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'section_text_alignment',
            [
                'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                    '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                    '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
                ],
                'default' => '1',
            ]
        ); 

        $this->add_control(
            'top_title', [
                'label' => esc_html__( 'Top Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title', [
                'label' => esc_html__( 'Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'veliki-toolkit' ),
                    3   => __( '3', 'veliki-toolkit' ),
                    4   => __( '4', 'veliki-toolkit' ),
                ],
                'default' => 2,
            ]
        );

        $this->add_control(
            'count',
            [
                'label' => esc_html__( 'Post Per Page', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('if you went to see all post type -1','veliki-toolkit'),
                'default' => '6'
            ]
        );
    
        $this->add_control(
            'order',
            [
                'label' => esc_html__( 'Select Order', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC'  => esc_html__( 'DESC', 'veliki-toolkit' ),
                    'ASC'  => esc_html__( 'ASC', 'veliki-toolkit' ),
                ],
                'default' => 'DESC',
            ]
        );
        $this->add_control(
            'cat_name',
            [
                'label' => __( 'Choose Category', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => veliki_toolkit_get_page_resource_cat_el(),
            ]
        );

        $this->add_control(
            'learn_more_btntext',
            [
                'label' => esc_html__( 'Read More Button Text', 'veliki-toolkit' ),
                'default' => esc_html__( 'Read More', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'shape',
            [
                'label'     => __('Shape', 'veliki-toolkit' ),
                'type'      => Controls_Manager::MEDIA,
            ]
        );
        $this-> end_controls_section();
        // End Tab content controls

        // Start Resources card Style
        $this-> start_controls_section(
            'all_content_style',
            [
                'label' => esc_html__('Resources Style', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'toptitle_color',
                [
                    'label'     => __( 'Top Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_toptitle',
                    'label'    => __( 'Top Title Typography', 'veliki-toolkit' ),
                    
                    'selector' => ' {{WRAPPER}} .section-title .sub-title',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_title',
                    'label'    => __( 'Title Typography', 'veliki-toolkit' ),
                    
                    'selector' => ' {{WRAPPER}} .section-title .title',
                ]
            );
            $this->add_control(
                'card_bg_color',
                [
                    'label'     => __( 'Card Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .case-study-wrap-card' => 'background: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'cat_color',
                [
                    'label'     => __( 'Category Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .case-study-wrap-card .case-study-content .tag span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'cat_cbgolor',
                [
                    'label'     => __( 'Category Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .case-study-wrap-card .case-study-content .tag span' => 'background: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_cat',
                    'label'    => __( 'Category Typography', 'veliki-toolkit' ),
                    
                    'selector' => ' {{WRAPPER}} .case-study-wrap-card .case-study-content .tag span',
                ]
            );
            $this->add_control(
                'post_t_color',
                [
                    'label'     => __( 'Posts Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .case-study-wrap-card .case-study-content h3 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_ptt',
                    'label'    => __( 'Posts Title Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .case-study-wrap-card .case-study-content h3 a',
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label'     => __( 'Button Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .case-study-wrap-card .case-study-content h3 .case-study-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_btn',
                    'label'    => __( ' Button Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .case-study-wrap-card .case-study-content h3 .case-study-btn',
                ]
            );
        $this-> end_controls_section();
        // Start Services card Style
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        // Text Alignment
		if( $settings['section_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['section_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
        }
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        // Column
        $columns = $settings['columns'];
        if ($columns == 2) {
            $column = 'col-lg-6 col-md-12';
        } elseif ($columns == 4) {
            $column = 'col-lg-3 col-md-12';
        } else {
            $column = 'col-lg-4 col-md-12';
        }

        // Project Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'resource',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'resource_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'resource',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }
        $query_array = new \WP_Query( $args ); 
        
        ?>

        <div class="case-study-wrap-area pt-100 pb-70">
            <div class="container">
                <?php if( $settings['top_title'] != '' || $settings['title'] != ''): ?>
                    <div class="section-title <?php echo esc_attr( $alignment );?>">
                        <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>

                        <<?php echo esc_attr( $settings['title_tag'] ); ?> class="title"><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    </div>
                <?php endif; ?>

                <div class="row justify-content-center">
                    <?php while($query_array->have_posts()): $query_array->the_post();
                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        } 
                        
                        $terms = wp_get_post_terms(get_the_ID(), 'resource_cat');

                        $output = array();
                        if ($terms) {
                            $i = 1;
                            foreach ($terms as $term) {
                                if ($i == 1) :
                                    //$output[] = ' <div class="tag"><a href="'.get_term_link($term->slug, 'project_cat').'">' . $term->name . '</a></div>';

                                    $output[] = ' <div class="tag"><span>' . $term->name . '</span></div>';
                                    $id[] = $term->term_id;
                                endif;
                                $i++;
                            }
                        }
                    ?>
                        <div class="<?php echo esc_attr( $column ); ?>">
                            <div class="case-study-wrap-card">
                                <div class="case-study-image">
                                    <a href="<?php echo esc_url( $post_link ); ?>">
                                        <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'veliki_resource_thumb')); ?>" alt="<?php echo esc_attr__('image','veliki-toolkit'); ?>">
                                    </a>
                                </div>

                                <div class="case-study-content">
                                    <?php echo join(' ', $output); ?>

                                    <h3>
                                        <a href="<?php echo esc_url( $post_link ); ?>"><?php the_title(); ?></a>
                                        
                                        <a href="<?php echo esc_url( $post_link ); ?>" target="_blank" class="case-study-btn">  <i class="fas fa-long-arrow-alt-right"></i> <?php echo esc_html( $settings['learn_more_btntext'] ); ?> </a>
                                    </h3>
                                </div>
                            </div>
                        </div>
                    <?php
                        endwhile;
                        wp_reset_query();
                    ?>
                </div>
            </div>

            <?php if( !empty( $settings['shape']['url'] ) ){ ?>
                <div class="case-study-wrap-shape">
                    <img src="<?php echo esc_url( $settings['shape']['url'] ); ?>" alt="<?php echo esc_attr__( 'Image', 'veliki-toolkit' ); ?>">
                </div>
            <?php } ?>
        </div>
        <?php
    } 
}
Plugin::instance()->widgets_manager->register_widget_type( new ResourcesWidgetTwo );