<?php 
namespace Elementor;
class PostWidget extends Widget_Base{
    public function get_name(){
        return "post-widget";
    }
    public function get_title(){
        return "Posts";
    }
    public function get_icon(){
        return "eicon-post-list";
    }
    public function get_categories(){
        return ['velikicategory'];
    }
    protected function register_controls(){

    // Section controls
    $this-> start_controls_section(
        'veliki_section',
        [
            'label'=>esc_html__('Section', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_CONTENT,
        ]
    );

    $this->add_control(
        'section_text_alignment',
        [
            'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
            ],
            'default' => '1'
        ]
    );

    $this->add_control(
        'card_text_alignment',
        [
            'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
            ],
            'default' => '3'
        ]
    );

        $this->add_control(
            'section_title',
            [
                'label'=>esc_html__('Title', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'section_desc', [
                'label' => esc_html__( 'Description', 'veliki-toolkit' ),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
                'label_block' => true,
            ]
        );
    $this-> end_controls_section();
    // End Section controls

    $this-> start_controls_section(
        'layout_section',
        [
            'label'=>esc_html__('Posts Content', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_CONTENT,
        ]
    );
    $this->add_control(
        'columns',
        [
            'label' => __( 'Choose Columns', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                2   => __( '2', 'veliki-toolkit' ),
                3   => __( '3', 'veliki-toolkit' ),
                4   => __( '4', 'veliki-toolkit' ),
            ],
            'default' => 3,
        ]
    );
    $this->add_control(
        'post_title_tag',
        [
            'label' => __('Post Title Tag', 'veliki-toolkit'),
            'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                ],
            'default'     => 'h3',
            'label_block' => true,
        ]
    );

    $this->add_control(
        'cat_name',
        [
            'label' => __( 'Choose Category', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => veliki_toolkit_get_post_cat_list(),
        ]
    );

    $this->add_control(
        'count',
        [
            'label' => esc_html__( 'Post Per Page', 'veliki-toolkit' ),
            'default' => esc_html__( '3', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('if you went to see all post type -1','veliki-toolkit')
        ]
    );

    $this->add_control(
        'order',
        [
            'label' => esc_html__( 'Select Order', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                'DESC'  => esc_html__( 'DESC', 'veliki-toolkit' ),
                'ASC'  => esc_html__( 'ASC', 'veliki-toolkit' ),
            ],
            'default' => 'DESC',
        ]
    );
    $this-> end_controls_section();

    // Start Style content controls
    $this-> start_controls_section(
        'heading_style',
        [
            'label'=>esc_html__('Section Heading', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_STYLE,
        ]
    );

    $this->add_control(
        'title_style',
        [
            'label' => esc_html__( 'Title', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
        ]
    );

    $this->add_control(
        'title_color',
        [
            'label' => esc_html__( 'Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
            ],
        ]
    );

    $this->add_responsive_control(
        'title_font_size',
        [
            'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 60,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );

    $this->add_control(
        'desc_style',
        [
            'label' => esc_html__( 'Description', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
        ]
    );

    $this->add_responsive_control(
        'desc_size',
        [
            'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 30,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );

    $this-> end_controls_section();

    // Start Style controls
    $this-> start_controls_section(
        'layout_style',
        [
            'label'=>esc_html__('Posts', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_STYLE,
        ]
    );

    $this->add_control(
        'post_mata_info',
        [
            'label' => esc_html__( 'Post Meta', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
        ]
    );

    $this->add_control(
        'meta_info_color',
        [
            'label' => esc_html__( 'Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .single-blog-post .post-content .entry-meta li, .single-blog-post .post-content .entry-meta li a' => 'color: {{VALUE}}',
            ],
        ]
    );
    $this->add_control(
        'meta_info_separator_color',
        [
            'label' => esc_html__( 'Separator Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .single-blog-post .post-content .entry-meta li::before' => 'background-color: {{VALUE}}',
            ],
        ]
    );

    $this->add_responsive_control(
        'meta_info_sz',
        [
            'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 30,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .single-blog-post .post-content .entry-meta li, .single-blog-post .post-content .entry-meta li a' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );

    $this->add_control(
        'post_title',
        [
            'label' => esc_html__( 'Post Title', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
        ]
    );
    $this->add_control(
        'post_title_color',
        [
            'label' => esc_html__( 'Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .single-blog-post .post-content h3 a, .single-blog-post .post-content h1 a, .single-blog-post .post-content h2 a, .single-blog-post .post-content h4 a, .single-blog-post .post-content h5 a, .single-blog-post .post-content h6 a' => 'color: {{VALUE}}',
            ],
        ]
    );
    $this->add_responsive_control(
        'post_title_sz',
        [
            'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 50,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .single-blog-post .post-content h3, .single-blog-post .post-content h1, .single-blog-post .post-content h2, .single-blog-post .post-content h4, .single-blog-post .post-content h5, .single-blog-post .post-content h6' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );

    $this->add_control(
        'post_desc',
        [
            'label' => esc_html__( 'Description', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
        ]
    );
    $this->add_responsive_control(
        'post_desc_sz',
        [
            'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 20,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .single-blog-post .post-content p' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );

    $this->add_control(
        'post_readmore',
        [
            'label' => esc_html__( 'Read More', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
        ]
    );
    $this->add_responsive_control(
        'readmore_sz',
        [
            'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 30,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .single-blog-post .post-content .learn-more-btn' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );
    $this-> end_controls_section();
}

    protected function render() 
    {
        global $veliki_opt;
        $settings = $this->get_settings_for_display();

        // Text Alignment
		if( $settings['section_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['section_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
        }
        // Text Alignment
        if( $settings['card_text_alignment' ] == '1') {
            $c_alignment = 'text-center';
        } 
        elseif( $settings['card_text_alignment' ] == '2') {
            $c_alignment = 'text-right';
        } else {
            $c_alignment = 'text-left';
        }
        
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        $columns = $settings['columns'];
        if ($columns == 2) {
            $column = 'col-lg-6 col-md-6';
        } elseif ($columns == 4) {
            $column = 'col-lg-3 col-md-6';
        } else {
            $column = 'col-lg-4 col-md-6';
        } 
        
        // Post Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'post',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'meta_key'      => '_thumbnail_id',
                'ignore_sticky_posts' => 1,
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'category',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'post',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
                'meta_key'            => '_thumbnail_id',
                'ignore_sticky_posts' => 1,
            );
        }
        $post_array = new \WP_Query( $args );
        
        ?>

        <!-- Start Blog Area -->
        <div class="blog-area ptb-110">
            <div class="container">
                <div class="section-title <?php echo esc_attr( $alignment); ?>">
                    <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['section_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                    <?php echo wp_kses_post( $settings['section_desc'] ); ?>
                </div>

                <div class="row">
                    <?php
                        $loop = 1;
                        while($post_array->have_posts()): $post_array->the_post();
                        $id = get_the_ID();
                        $title = get_the_title(get_the_ID());
                        if ( $columns == 3 ) {
                            if($loop == 3 && $settings['count'] == 3){ 
                                $column = "col-lg-4 col-md-6 offset-lg-0 offset-md-3";
                            } else {
                                $column = "col-lg-4 col-md-6";
                            } 
                        }
                    ?>

                    <div class="<?php echo esc_attr($column); ?>">
                        <div class="single-blog-post home-blog-post">
                            <div class="entry-thumbnail">
                                <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_the_post_thumbnail_url($id, 'veliki_card_thumb')); ?>" alt="<?php echo esc_attr__('blog image','veliki-toolkit'); ?>"></a>
                            </div>

                            <div class="post-content <?php echo esc_attr( $c_alignment); ?>">
                                <?php if( isset( $veliki_opt['is_post_meta'] ) && $veliki_opt['is_post_meta'] == true ) { ?>
                                    <ul class="entry-meta">
                                        <li>
                                            <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ) ?>">
                                                <?php the_author() ?>
                                            </a>
                                        </li>
                                        <li><?php echo esc_html__(get_the_date('F d, Y'), 'veliki-toolkit'); ?></li>
                                    </ul>
                                <?php } ?>
                                <<?php echo esc_attr( $settings['post_title_tag'] ); ?>><a href="<?php echo esc_url(get_the_permalink($id)); ?>"><?php echo esc_html($title); ?></a></<?php echo esc_attr( $settings['post_title_tag'] ); ?>>

                                <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), 22, '...' )); ?></p>

                                <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="learn-more-btn"> <?php if(isset($veliki_opt['post_read_more'] ) && !$veliki_opt['post_read_more'] == ''){ echo esc_html($veliki_opt['post_read_more']); }else{ echo esc_html__('Read More','veliki-toolkit'); } ?> <i class="flaticon-add-1"></i></a> 
                            </div>
                        </div>
                    </div> 
                    <?php
                        $loop++;
                        endwhile;
                        wp_reset_query();
                    ?>
                </div>
            </div>
        </div>
        <?php 
    }

       
}
Plugin::instance()->widgets_manager->register_widget_type( new PostWidget );