<?php 
namespace Elementor;
class VelikiPostTwo extends Widget_Base{
    public function get_name(){
        return "post-wid-two";
    }
    public function get_title(){
        return "Posts Two";
    }
    public function get_icon(){
        return "eicon-post-list";
    }
    public function get_categories(){
        return ['velikicategory'];
    }
    protected function register_controls(){

        // Section controls
        $this-> start_controls_section(
            'veliki_section',
            [
                'label' => esc_html__('Section', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'section_text_alignment',
            [
                'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                    '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                    '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
                ],
                'default' => '1'
            ]
        );

        $this->add_control(
            'card_text_alignment',
            [
                'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                    '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                    '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
                ],
                'default' => '3'
            ]
        );

        $this->add_control(
            'top_title', [
                'label' => esc_html__( 'Top Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title', [
                'label' => esc_html__( 'Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );
        $this-> end_controls_section();
        // End Section controls

        $this-> start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Posts Content', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'veliki-toolkit' ),
                    3   => __( '3', 'veliki-toolkit' ),
                    4   => __( '4', 'veliki-toolkit' ),
                ],
                'default' => 3,
            ]
        );
        $this->add_control(
            'post_title_tag',
            [
                'label' => __('Post Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'cat_name',
            [
                'label' => __( 'Choose Category', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => veliki_toolkit_get_post_cat_list(),
            ]
        );

        $this->add_control(
            'count',
            [
                'label' => esc_html__( 'Post Per Page', 'veliki-toolkit' ),
                'default' => esc_html__( '3', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('if you went to see all post type -1','veliki-toolkit')
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__( 'Select Order', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC'  => esc_html__( 'DESC', 'veliki-toolkit' ),
                    'ASC'  => esc_html__( 'ASC', 'veliki-toolkit' ),
                ],
                'default' => 'DESC',
            ]
        );
        $this->add_control(
            'excerpt', [
                'label'       => __( 'Excerpt Character Limit', 'veliki-toolkit' ),
                'description' => __( 'Leave the field empty to show the full excerpt. And if excerpt not found in a post, then the excerpt will take from the post content.', 'veliki-toolkit' ),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '12',
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Read More', 'veliki-toolkit'),
            ]
        );
        $this->add_control(
            'by_text',
            [
                'label' => esc_html__( 'By Text', 'veliki-toolkit' ),
                'default' => esc_html__( 'By ', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'comments',
            [
                'label' 	=> esc_html__( 'Comments Text', 'veliki-toolkit' ),
                'type' 		=> Controls_Manager::TEXT,
                'default' 	=> esc_html__(' Comments', 'veliki-toolkit'),
            ]
        );
        $this-> end_controls_section();

        // Start Style content controls
        $this-> start_controls_section(
            'heading_style',
            [
                'label' => esc_html__('Section Heading', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'toptitle_color',
                [
                    'label'     => esc_html__( 'Top Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_responsive_control(
                'toptitle_font_size',
                [
                    'label' => esc_html__( 'Top Title Font Size', 'veliki-toolkit' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 60,
                        ],
                    ],
                    'devices' => [ 'desktop', 'tablet', 'mobile' ],
                    'unit' => 'px',
                    'selectors' => [
                        '{{WRAPPER}} .section-title .sub-title' => 'font-size: {{SIZE}}{{UNIT}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => esc_html__( 'Section Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_responsive_control(
                'title_font_size',
                [
                    'label' => esc_html__( 'Section Title Font Size', 'veliki-toolkit' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 60,
                        ],
                    ],
                    'devices' => [ 'desktop', 'tablet', 'mobile' ],
                    'unit' => 'px',
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
                    ],
                ]
            );

        $this-> end_controls_section();

        // Start Style controls
        $this-> start_controls_section(
            'layout_style',
            [
                'label' => esc_html__('Posts', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'post_mata_info',
            [
                'label' => esc_html__( 'Post Meta', 'veliki-toolkit' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'meta_info_color',
            [
                'label' => esc_html__( 'Meta Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-wrap-card .blog-content .entry-meta li a, .blog-wrap-card .blog-content .entry-meta li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'meta_info_separator_color',
            [
                'label' => esc_html__( 'Separator Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-wrap-card .blog-content .entry-meta li::before' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'meta_info_sz',
            [
                'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .blog-wrap-card .blog-content .entry-meta li a, .blog-wrap-card .blog-content .entry-meta li' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'post_title',
            [
                'label' => esc_html__( 'Post Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->add_control(
            'post_title_color',
            [
                'label' => esc_html__( 'Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-wrap-card .blog-content .title a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'post_title_sz',
            [
                'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .blog-wrap-card .blog-content .title a' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'post_desc',
            [
                'label' => esc_html__( 'Description', 'veliki-toolkit' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->add_control(
            'post_desc_color',
            [
                'label' => esc_html__( 'Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-wrap-card .blog-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'post_desc_sz',
            [
                'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .blog-wrap-card .blog-content p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'post_readmore',
            [
                'label' => esc_html__( 'Read More', 'veliki-toolkit' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->add_control(
            'readmore_color',
            [
                'label' => esc_html__( 'Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-wrap-card .blog-content .blog-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'readmore_sz',
            [
                'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 30,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .blog-wrap-card .blog-content .blog-btn' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this-> end_controls_section();
    }

    protected function render() 
    {
        global $veliki_opt;
        $settings = $this->get_settings_for_display();

        // Text Alignment
		if( $settings['section_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['section_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
        }
        // Text Alignment
        if( $settings['card_text_alignment' ] == '1') {
            $c_alignment = 'text-center';
        } 
        elseif( $settings['card_text_alignment' ] == '2') {
            $c_alignment = 'text-right';
        } else {
            $c_alignment = 'text-left';
        }
        
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        $columns = $settings['columns'];
        if ($columns == 2) {
            $column = 'col-lg-6 col-md-6';
        } elseif ($columns == 4) {
            $column = 'col-lg-3 col-md-6';
        } else {
            $column = 'col-lg-4 col-md-6';
        } 
        
        // Post Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'post',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'meta_key'      => '_thumbnail_id',
                'ignore_sticky_posts' => 1,
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'category',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'post',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
                'meta_key'            => '_thumbnail_id',
                'ignore_sticky_posts' => 1,
            );
        }
        $post_array = new \WP_Query( $args );
        
        ?>
        <div class="blog-wrap-area pt-100 pb-70">
            <div class="container">
                <?php if( $settings['top_title'] != '' || $settings['title'] != ''): ?>
                    <div class="section-title <?php echo esc_attr( $alignment );?>">
                        <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>

                        <<?php echo esc_attr( $settings['title_tag'] ); ?> class="title"><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    </div>
                <?php endif; ?>

                <div class="row justify-content-center">
                    <?php
                        $loop = 1;
                        while($post_array->have_posts()): $post_array->the_post();
                        $id = get_the_ID();
                        $title = get_the_title(get_the_ID());
                    ?>
                    <div class="<?php echo esc_attr($column); ?>">
                        <div class="blog-wrap-card">
                            <?php if(has_post_thumbnail()) { ?>
                                <div class="blog-image">
                                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_the_post_thumbnail_url($id, 'veliki_card_thumb')); ?>" alt="<?php echo esc_attr__('blog image','veliki-toolkit'); ?>"></a>

                                    <div class="date"><?php echo esc_html(get_the_date('j M')); ?></div>
                                </div>
                            <?php } ?>

                            <div class="blog-content <?php echo esc_attr( $c_alignment); ?>">
                                <?php if( isset( $veliki_opt['is_post_meta'] ) && $veliki_opt['is_post_meta'] == true ) { ?>
                                    <ul class="entry-meta">
                                        <li><?php echo esc_html($settings['by_text']); ?>
                                            <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php echo esc_html(get_the_author()); ?></a>
                                        </li>
                                        <li><?php echo esc_html(get_comments_number()); ?> <?php echo esc_html($settings['comments']); ?></li>
                                    </ul>
                                <?php } ?>

                                <<?php echo esc_attr( $settings['post_title_tag'] ); ?> class="title"><a href="<?php echo esc_url(get_the_permalink($id)); ?>"><?php echo esc_html($title); ?></a></<?php echo esc_attr( $settings['post_title_tag'] ); ?>>

                                <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt'], '' )); ?></p>

                                <?php if( $settings['button_text'] != ''): ?>
                                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="blog-btn"> <i class="fas fa-long-arrow-alt-right"></i> <?php echo esc_html($settings['button_text']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php
                        $loop++;
                        endwhile;
                        wp_reset_query();
                    ?>
                </div>
            </div>
        </div>

        <?php 
    }  
}
Plugin::instance()->widgets_manager->register_widget_type( new VelikiPostTwo );