<?php
namespace Elementor;
class PartnerWidget extends Widget_Base{
    public function get_name(){
        return "partner-widget";
    }
    public function get_title(){
        return "Partner Logo";
    }
    public function get_icon(){
        return "eicon-logo";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls() {
        // Start Partner section
        $this-> start_controls_section(
            'layout_section',
            [
                'label'=>esc_html__('Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'section_text_alignment',
			[
				'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '3'
			]
		);
        $this->add_control(
            'form_title',
            [
                'label'=>esc_html__('Form Title', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $this->add_control(
            'form_desc',
            [
                'label'=>esc_html__('Form Description', 'veliki-toolkit'),
                'type' => Controls_Manager::WYSIWYG,
            ]
        );
        $this->add_control(
            'form_shortcode',
            [
                'label' => esc_html__( 'Form Shortcode', 'plaby-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
			'card_text_alignment',
			[
				'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '3'
			]
		);
        $this->add_control(
            'logo_title',
            [
                'label'=>esc_html__('Partner Logo Title', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'logo_desc',
            [
                'label'=>esc_html__('Partner Logo Description', 'veliki-toolkit'),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'partner_logo', [
                'label' => esc_html__( 'Logo', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'logo_url', [
                'label' => esc_html__( 'URL', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'logo',
            [
                'label' => esc_html__( 'Add Partner Logo', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this-> end_controls_section();

        // Start Section Title Style
        $this-> start_controls_section(
            'section_style',
            [
                'label'=>esc_html__('Section Style', 'plaby-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'formtitle_color',
            [
                'label' => esc_html__( 'Form Title Color', 'plaby-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .question-form h3' => 'color: {{VALUE}}',
                ],
            ]
        );
    
        $this->add_responsive_control(
            'formtitle_font_size',
            [
                'label' => esc_html__( 'Form Title Font Size', 'plaby-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .question-form h3' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_control(
            'formdesc_color',
            [
                'label' => esc_html__( 'Form Description Color', 'plaby-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .question-form p' => 'color: {{VALUE}}',
                ],
            ]
        );
    
        $this->add_responsive_control(
            'formdesc_font_size',
            [
                'label' => esc_html__( 'Form Description Font Size', 'plaby-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .question-form p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'logotitle_color',
            [
                'label' => esc_html__( 'Logo Title Color', 'plaby-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .partner-inner-content h2, .partner-inner-content h1, .partner-inner-content h3, .partner-inner-content h4, .partner-inner-content h5, .partner-inner-content h6' => 'color: {{VALUE}}',
                ],
            ]
        );
    
        $this->add_responsive_control(
            'logotitle_font_size',
            [
                'label' => esc_html__( 'Logo Title Font Size', 'plaby-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 60,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .partner-inner-content h2, .partner-inner-content h1, .partner-inner-content h3, .partner-inner-content h4, .partner-inner-content h5, .partner-inner-content h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'logodesc_font_size',
            [
                'label' => esc_html__( 'Logo Description Font Size', 'plaby-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 20,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .partner-inner-content p, .partner-inner-content ul li, .partner-inner-content ol li' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this-> end_controls_section();
    }

    protected function render() 
    {
        $settings = $this->get_settings_for_display();

        // Text Alignment
		if( $settings['section_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['section_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
        }
        // Text Alignment
        if( $settings['card_text_alignment' ] == '1') {
            $c_alignment = 'text-center';
        } 
        elseif( $settings['card_text_alignment' ] == '2') {
            $c_alignment = 'text-right';
        } else {
            $c_alignment = 'text-left';
        }
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif; ?>
        <!-- Start Partner Area -->
        <div class="partner-area ptb-110">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-4 col-md-12">
                        <?php if( $settings['form_title'] || $settings['form_desc']) : ?>
                            <div class="question-form <?php echo esc_attr( $alignment); ?>">
                                <h3><?php echo esc_html( $settings['form_title'] ); ?></h3>
                                <p><?php echo wp_kses_post( $settings['form_desc'] ); ?></p>

                                <div class="form">
                                    <?php $form = $settings['form_shortcode']; 
                                    echo do_shortcode($form); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="col-lg-8 col-md-12">
                        <div class="partner-inner-content <?php echo esc_attr( $c_alignment); ?>">

                            <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['logo_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                            <?php echo wp_kses_post( $settings['logo_desc'] ); ?>

                            <div class="our-clients-list">
                                <?php if ( $settings['logo']!='' ) :
                                    foreach ( $settings['logo'] as $item ) :
                                        if($item['partner_logo']!=''): ?>
                                            <div class="single-clients">
                                                <a href="<?php echo esc_html($item['logo_url']); ?>">
                                                <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $item['partner_logo']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">
                                                </a>
                                            </div> <?php
                                        endif;
                                    endforeach; 
                                endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php    
    }

       
}
Plugin::instance()->widgets_manager->register_widget_type( new PartnerWidget );