<?php
namespace Elementor;
class PartnerTwo extends Widget_Base{
    public function get_name(){
        return "partner-two";
    }
    public function get_title(){
        return "Partner Two";
    }
    public function get_icon(){
        return "eicon-logo";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls() {
        // Start Partner section
        $this-> start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Content', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'section_text_alignment',
			[
				'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '1'
			]
		);
        
        $this->add_control(
            'title', [
                'label' => esc_html__( 'Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'desc',
            [
                'label'       => esc_html__(' Description', 'veliki-toolkit'),
                'type'        => Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'partner_logo', [
                'label'       => esc_html__( 'Logo', 'veliki-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'logo_url', [
                'label'       => esc_html__( 'URL', 'veliki-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'logo',
            [
                'label' => esc_html__( 'Add Partner Logo', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this-> end_controls_section();

        // Start Section Title Style
        $this-> start_controls_section(
            'section_style',
            [
                'label'=>esc_html__('Section Style', 'plaby-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'ssec_color',
            [
                'label' => esc_html__( 'Section Background', 'plaby-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .partner-wrap-area' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Section Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Section Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 60,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Description Color', 'plaby-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .partner-wrap-area .section-title p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'desc_font_size',
            [
                'label' => esc_html__( 'Description Font Size', 'plaby-toolkit' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 60,
                    ],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
                'selectors' => [
                    '{{WRAPPER}} .partner-wrap-area .section-title p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this-> end_controls_section();
    }

    protected function render() 
    {
        $settings = $this->get_settings_for_display();

        // Text Alignment
		if( $settings['section_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['section_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
        }
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif; ?>

        <div class="partner-wrap-area pt-100 pb-70">
            <div class="container">
                <?php if( $settings['desc'] != '' || $settings['title'] != ''): ?>
                    <div class="section-title <?php echo $alignment; ?>">
                        <<?php echo esc_attr( $settings['title_tag'] ); ?> class="title"><?php echo wp_kses_post( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                        <p><?php echo wp_kses_post( $settings['desc'] ); ?></p>
                    </div>
                <?php endif; ?>

                <div class="row align-items-center partner-wrap-with-max-width">
                    <?php if ( $settings['logo']!='' ) :
                        foreach ( $settings['logo'] as $item ) :
                            if($item['partner_logo']['url'] !=''): ?>
                                <div class="col-lg-2 col-6 col-sm-3 col-md-3">
                                    <div class="partner-wrap-card">
                                        <a href="<?php echo esc_html($item['logo_url']); ?>">
                                            <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $item['partner_logo']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">
                                        </a>
                                    </div>
                                </div>
                            <?php endif;
                        endforeach; 
                    endif; ?>
                </div>
            </div>
        </div>
    <?php    
    }  
}
Plugin::instance()->widgets_manager->register_widget_type( new PartnerTwo );