<?php
namespace Elementor;
class Veliki_OverviewWrap extends Widget_Base{
    public function get_name(){
        return "VelikiOverview";
    }
    public function get_title(){
        return "Veliki Overview";
    }
    public function get_icon(){
        return "eicon-info-box";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'section_content',
            [
                'label' => __('Content', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $this->add_control(
                'title', [
                    'label'       => __( 'Title', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'heading_tag', [
                    'label'   => __( 'Title Heading Tag', 'veliki-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                    'default'     => 'h3',
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'desc', 
                [
                    'label'       => __( 'Description', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::WYSIWYG,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'desc_note1', [
                    'label' => '',
                    'type'  => Controls_Manager::RAW_HTML,
                    'raw'   => __( 'In description editor use a class in p tag. When editing the editor its remove existing p, span tag', 'veliki-toolkit' ),
                    'content_classes' => 'elementor-warning',
                ]
            );
               
            $this->add_control(
                'button_text',
                [
                    'label'   => __( 'Button Text', 'veliki-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('Get Started', 'veliki-toolkit'),
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label'       => __( 'Link Type', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => [
                        '1'  => __( 'Link To Page', 'veliki-toolkit' ),
                        '2'  => __( 'External Link', 'veliki-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label'       => __( 'Link Page', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => veliki_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type'    => '1',
                    ]
                ]
            );
            $this->add_control(
                'external_link',
                [
                    'label'     => __('External Link', 'veliki-toolkit'),
                    'type'      => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type'    => '2',
                    ]
                ]
            );
            //Target Page
            $this->add_control(
                'target_page',
                [
                    'label' => __( 'Link Open In New Tab?', 'veliki-toolkit' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Yes', 'veliki-toolkit' ),
                    'label_off' => __( 'No', 'veliki-toolkit' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );

            $this->add_control(
                'shape',
                [
                    'label'     => __('Shape', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::MEDIA,
                ]
            );
        $this-> end_controls_section();

        // End Tab content controls

        // Start style1 content controls
        $this-> start_controls_section(
            'content_style',
            [
                'label'     => __('Style', 'veliki-toolkit'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'card_bg_color',
                [
                    'label'     => __( 'Section Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .overview-wrap-inner-box' => 'background: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'bottom_bg_color',
                [
                    'label'     => __( 'Section Bottom Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .overview-wrap-area::before' => 'background: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .overview-wrap-content .title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_title',
                    'label'    => __( 'Title Typography', 'veliki-toolkit' ),
                     
                    'selector' => ' {{WRAPPER}} .overview-wrap-content .title',
                ]
            );
            $this->add_control(
                'desc_color',
                [
                    'label'     => __( 'Description Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .overview-wrap-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_desc',
                    'label'    => __( 'Description Typography', 'veliki-toolkit' ),
                     
                    'selector' => ' {{WRAPPER}} .overview-wrap-content p',
                ]
            );
           
            $this->add_control(
                'btn_color',
                [
                    'label'     => __( 'Button Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .overview-wrap-btn .btn-primary' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_bgcolor',
                [
                    'label'     => __( 'Button Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .overview-wrap-btn .btn-primary::before' => 'background: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_btn',
                    'label'    => __( 'Button Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .btn-primary',
                ]
            );
            $this->add_control(
                'btn_hbgcolor',
                [
                    'label'     => __( 'Button Hover Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .btn-primary::after' => 'background: {{VALUE}}',
                    ],
                ]
            );
        $this-> end_controls_section();
    }

    protected function render()
    {
        // Retrieve all controls value
        $settings = $this->get_settings_for_display();

        // Button link
        $link_source = '';
        if ( $settings['link_type'] == 1 ) :
            $link_source = get_page_link( $settings['link_to_page']); 
        else :
            $link_source = $settings['external_link'];
        endif; ?>

        <div class="overview-wrap-area">
            <div class="container">
                <div class="overview-wrap-inner-box">
                    <div class="row justify-content-center align-items-center">
                        <div class="col-lg-9 col-md-12">
                            <div class="overview-wrap-content">
                                <<?php echo esc_attr( $settings['heading_tag'] ); ?> class="title"><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['heading_tag'] ); ?>>

                                <p><?php echo wp_kses_post( $settings['desc'] ); ?></p>
                            </div>
                        </div>

                        <?php if ( $settings['button_text'] != '' ) : ?>
                            <div class="col-lg-3 col-md-12">
                                <div class="overview-wrap-btn">
                                    <?php if ( 'yes' === $settings['target_page'] ) { ?>
                                        <a target="_blank" href="<?php echo esc_url( $link_source ); ?>" class="btn btn-primary">
                                            <?php echo esc_html( $settings['button_text'] ); ?>
                                        </a><?php
                                    } else { ?>
                                        <a href="<?php echo esc_url( $link_source ); ?>" class="btn btn-primary">
                                            <?php echo esc_html( $settings['button_text'] ); ?>
                                        </a><?php
                                    } ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if( !empty( $settings['shape']['url'] ) ){ ?>
                        <div class="white-graph-shape">
                            <img src="<?php echo esc_url( $settings['shape']['url'] ); ?>" alt="<?php echo esc_attr__( 'Image', 'veliki-toolkit' ); ?>">
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new Veliki_OverviewWrap );