<?php
namespace Elementor;
class HowItWorkWidget extends Widget_Base{
    public function get_name(){
        return "how-it-work-widget";
    }
    public function get_title(){
        return "How It Works";
    }
    public function get_icon(){
        return "eicon-favorite";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'work_section_content',
            [
                'label'=>esc_html__('Section Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'section_text_alignment',
			[
				'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '1'
			]
		);
        $this->add_control(
            'title', [
                'label' => esc_html__( 'Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'desc', [
                'label' => esc_html__( 'Description', 'veliki-toolkit' ),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'veliki-toolkit' ),
                    3   => __( '3', 'veliki-toolkit' ),
                    4   => __( '4', 'veliki-toolkit' ),
                ],
                'default' => 3,
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
			'card_text_alignment',
			[
				'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '3'
			]
		);
        $repeater->add_control(
            'card_icon',
            [
                'label' => esc_html__( 'Choose Card Icon', 'alpas-toolkit' ),
                'type' 			=> Controls_Manager::ICON,
                'label_block' 	=> true,
                'options' 		=> domain_font_awesome(),
                'default' 		=> 'fab fa-facebook-f',
            ]
        );
        
        $repeater->add_control(
            'card_title', [
                'label' => esc_html__( 'Card Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'card_title_tag',
            [
                'label' => __('Card Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'card_details', [
                'label' => esc_html__( 'Card Details', 'veliki-toolkit' ),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'card_list',
            [
                'label' => esc_html__( 'Add Card Content', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this-> end_controls_section();
        // End Tab content controls

        // Start Features Card Style
        $this-> start_controls_section(
            'it_works_style',
            [
                'label'=>esc_html__('Works Style', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 60,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Description Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'desc_font_size',
			[
				'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 30,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'card_title_color',
            [
                'label' => esc_html__( 'Card Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-how-it-work-box h3, .single-how-it-work-box h1, .single-how-it-work-box h2, .single-how-it-work-box h4, .single-how-it-work-box h5, .single-how-it-work-box h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'card_title_font_size',
			[
				'label' => esc_html__( 'Card Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .single-how-it-work-box h3, .single-how-it-work-box h1, .single-how-it-work-box h2, .single-how-it-work-box h4, .single-how-it-work-box h5, .single-how-it-work-box h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_responsive_control(
			'card_details_font_size',
			[
				'label' => esc_html__( 'Card Details Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .single-how-it-work-box p, .single-how-it-work-box ul li, .single-how-it-work-box ol li' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'card_num_color',
            [
                'label' => esc_html__( 'Card Number Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-how-it-work-box .number-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'card_number_font_size',
			[
				'label' => esc_html__( 'Card Number Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 70,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .single-how-it-work-box .number-text' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this-> end_controls_section();
    }
    // Register control section end here

    protected function render()
    {
        $settings = $this->get_settings_for_display(); 
            // Text Alignment
            if( $settings['section_text_alignment' ] == '1') {
                $alignment = 'text-center';
            } 
            elseif( $settings['section_text_alignment' ] == '2') {
                $alignment = 'text-right';
            } else {
                $alignment = 'text-left';
            }

            $columns = $settings['columns'];
            if ($columns == 2) {
                $column = 'col-lg-6 col-md-6';
            } elseif ($columns == 4) {
                $column = 'col-lg-3 col-md-6 col-sm-6';
            } else {
                $column = 'col-lg-4 col-md-6 col-sm-6';
            } 
        
        ?>

        <!-- Start How It Works Area -->
        <div class="how-it-works-area ptb-110">
            <div class="container">
                <div class="section-title <?php echo esc_attr( $alignment); ?>">
                    <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                    <?php echo wp_kses_post( $settings['desc'] ); ?>
                </div>

                <div class="row">
                    <?php if ($settings['card_list'] !='') : 
                        $i = 1;
                        foreach ( $settings['card_list'] as $item ) :
                            // Text Alignment
                            if( $item['card_text_alignment' ] == '1') {
                                $c_alignment = 'text-center';
                            } 
                            elseif( $item['card_text_alignment' ] == '2') {
                                $c_alignment = 'text-right';
                            } else {
                                $c_alignment = 'text-left';
                            }
                            if ( $columns == 3 ) {
                                if( $i == 3 ){ 
                                    $column = "col-lg-4 col-md-6 col-sm-6 offset-lg-0 offset-md-3 offset-sm-3";
                                } else {
                                    $column = "col-lg-4 col-md-6 col-sm-6";
                                }
                            }
                            
                            if ( $item['card_title'] !='' || $item['card_details'] !='' || $item['card_icon'] !='' ) : ?>
                                <div class="<?php echo esc_attr($column); ?>">
                                    <div class="single-how-it-work-box <?php echo esc_attr( $c_alignment); ?>">
                                        <div class="icon">
                                            <i class="<?php echo esc_attr( $item['card_icon'] ); ?>"></i>
                                        </div>
                                        <<?php echo esc_attr( $item['card_title_tag'] ); ?>><?php echo esc_html( $item['card_title'] ); ?></<?php echo esc_attr( $item['card_title_tag'] ); ?>>
                                        <?php echo wp_kses_post( $item['card_details'] ); ?>

                                        <div class="number-text"><?php echo esc_html( $i ); ?></div>
                                    </div>
                                </div><?php 
                            endif;
                        $i++;
                        endforeach;
                    endif; ?>

                </div>
            </div>
        </div>
        <!-- End How It Works Area -->
        <?php
    }

       
}
Plugin::instance()->widgets_manager->register_widget_type( new HowItWorkWidget );