<?php
namespace Elementor;
class TestimonialWidget extends Widget_Base{
    public function get_name(){
        return "testimonial-widget";
    }
    public function get_title(){
        return "Testimonial Widget";
    }
    public function get_icon(){
        return "eicon-testimonial-carousel";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
    
        $this-> start_controls_section(
            'veliki_testimonial',
            [
                'label'=>esc_html__('Testimonials', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'section_show',
            [
                'label' => esc_html__( 'Section Show?', 'veliki-toolkit' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'veliki-toolkit' ),
                'label_off' => esc_html__( 'Hide', 'veliki-toolkit' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
			'section_text_alignment',
			[
				'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '1'
			]
		);
        $this->add_control(
            'section_title',
            [
                'label'=>esc_html__('Title', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
                'condition' => [
                    'section_show' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
                'condition' => [
                    'section_show' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'section_desc',
            [
                'label'=>esc_html__('Description', 'veliki-toolkit'),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
                'condition' => [
                    'section_show' => 'yes',
                ]
            ]
        );
        // Feedback with image
        $repeater = new Repeater();
        $repeater->add_control(
			'card_text_alignment',
			[
				'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '1',
			]
		);
        $repeater->add_control(
            'feedback', [
                'label' => esc_html__( 'Feedback', 'veliki-toolkit' ),
                'type' => Controls_Manager::WYSIWYG,
            ]
        );
        $repeater->add_control(
            'client_image',
            [
                'label' => esc_html__('Client Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'client_name', [
                'label' => esc_html__( 'Name', 'veliki-toolkit' ),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $repeater->add_control(
            'client_desig', [
                'label' => esc_html__( 'Designation', 'veliki-toolkit' ),
                'type'=>Controls_Manager:: TEXT,
            ]
        );

        $this->add_control(
            'all_feedback',
            [
                'label' => esc_html__( 'All Feedback', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this-> end_controls_section();

        // Start Style Controls
        $this-> start_controls_section(
            'feedback_style',
            [
                'label'=>esc_html__('Feedback Styles', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Section Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'section_show' => 'yes',
                ]
            ]
        );
        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Section Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 60,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'section_show' => 'yes',
                ]
			]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Section Description Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'section_show' => 'yes',
                ]
            ]
        );
        $this->add_responsive_control(
			'desc_font_size',
			[
				'label' => esc_html__( 'Section Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 30,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'section_show' => 'yes',
                ]
			]
        );

        $this->add_responsive_control(
			'feed_font_size',
			[
				'label' => esc_html__( 'Feedback Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .single-feedback-item .feedback-desc p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__( 'Name Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-feedback-item .client-info h3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
			'name_font_size',
			[
				'label' => esc_html__( 'Name Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .single-feedback-item .client-info h3' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_responsive_control(
			'desig_font_size',
			[
				'label' => esc_html__( 'Designation Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .single-feedback-item .client-info span' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this-> end_controls_section();
    }

    protected function render() 
    {
        $settings = $this->get_settings_for_display();
        
        // Text Alignment
		if( $settings['section_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['section_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
        }
        
        $slider = $settings['all_feedback'];
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr  = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr  = '';
        endif; 
        
        $count = 0;
        foreach ( $slider as $value ) {
            $count++;
        } ?>

        <!-- Start Feedback Area -->
        <div class="feedback-area ptb-110">
            <div class="container">
                <?php if ( 'yes' === $settings['section_show'] ) : ?>
                    <div class="section-title <?php echo esc_attr( $alignment); ?>">
                        <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['section_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                        <?php echo wp_kses_post( $settings['section_desc'] ); ?>
                    </div>
                <?php endif; ?>
            </div>

            <?php if ( $count == '1' ) { ?>
            <div class="container">
            <div class="col-lg-6 col-md-12 offset-lg-3"><?php
            } elseif ( $count == '2' ) { ?>
            <div class="container">
            <div class="row"><?php
            } else { ?>
            <div class="feedback-slides owl-carousel owl-theme"><?php
            } ?>
                <?php if ( $settings['all_feedback'] !='' ) : 
                    foreach( $settings['all_feedback'] as $item ) :
                        // Text Alignment
                        if( $item['card_text_alignment' ] == '1') {
                            $c_alignment = 'text-center';
                        } 
                        elseif( $item['card_text_alignment' ] == '2') {
                            $c_alignment = 'text-right';
                        } else {
                            $c_alignment = 'text-left';
                        }
                        if( $item['feedback'] !='' || $item['client_name'] !='' || $item['client_desig'] !='' ) : ?>
                            <?php if( $count == 2 ){ ?>
                            <div class="col-lg-6 col-md-6"> <?php
                            } ?>
                            <div class="single-feedback-item">
                                <div class="feedback-desc <?php echo esc_attr( $c_alignment); ?>">
                                    <?php echo wp_kses_post( $item['feedback'] ); ?>
                                </div>

                                <div class="client-info">
                                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $item['client_image']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">
                                    <h3><?php echo esc_html( $item['client_name'] ); ?></h3>
                                    <span><?php echo esc_html( $item['client_desig'] ); ?></span>
                                </div>
                            </div>
                            <?php if( $count == 2 ){ ?>
                            </div> <?php
                            } ?><?php 
                        endif;
                    endforeach;
                endif; ?>
            </div>
            <?php if( $count == '2' || $count == '1' ) { ?>
            </div>
            <?php } ?>
        </div>
        <!-- End Feedback Area -->
    <?php
    } 
       

}
Plugin::instance()->widgets_manager->register_widget_type( new TestimonialWidget );