<?php
namespace Elementor;
class TestimonialTwo extends Widget_Base{
    public function get_name(){
        return "testimonialTwo";
    }
    public function get_title(){
        return "Testimonial Two";
    }
    public function get_icon(){
        return "eicon-testimonial-carousel";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
    
        $this-> start_controls_section(
            'veliki_testimonial',
            [
                'label' => esc_html__('Testimonials Two', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
       
        $this->add_control(
            'top_title', [
                'label' => esc_html__( 'Top Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title', [
                'label' => esc_html__( 'Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );

        $this->add_control(
			'card_text_alignment',
			[
				'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '1',
			]
		);
        // Feedback with image
        $repeater = new Repeater();
        $repeater->add_control(
            'feedback_title', [
                'label' => esc_html__( 'Feedback Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $repeater->add_control(
            'feedback', [
                'label' => esc_html__( 'Feedback', 'veliki-toolkit' ),
                'type' => Controls_Manager::WYSIWYG,
            ]
        );
        $repeater->add_control(
            'client_image',
            [
                'label' => esc_html__('Client Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'client_name', [
                'label' => esc_html__( 'Name', 'veliki-toolkit' ),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $repeater->add_control(
            'client_desig', [
                'label' => esc_html__( 'Designation', 'veliki-toolkit' ),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $this->add_control(
            'all_feedback',
            [
                'label' => esc_html__( 'All Feedback', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this->add_control(
            'quote_image',
            [
                'label' => esc_html__('Quote Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this-> end_controls_section();

        // Start Style Controls
        $this-> start_controls_section(
            'feedback_style',
            [
                'label'=>esc_html__('Feedback Styles', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'sec_color',
            [
                'label' => esc_html__( 'Section Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .clients-review-area' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'toptitle_color',
            [
                'label' => esc_html__( 'Top Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'toptitle_font_size',
			[
				'label' => esc_html__( 'Top Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 60,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title .sub-title' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Section Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Section Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 60,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'feedbg_color',
            [
                'label' => esc_html__( 'Feedback Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .clients-review-item' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'feed_title_color',
            [
                'label' => esc_html__( 'Feedback Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .clients-review-item span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'ft_font_size',
			[
				'label' => esc_html__( 'Feedback Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .clients-review-item span' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'feed_color',
            [
                'label' => esc_html__( 'Feedback Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .clients-review-item p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'feed_font_size',
			[
				'label' => esc_html__( 'Feedback Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .clients-review-item p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__( 'Name Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .clients-review-item .client-info h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'name_font_size',
			[
				'label' => esc_html__( 'Name Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .clients-review-item .client-info h3' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'desig_color',
            [
                'label' => esc_html__( 'Designation Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .clients-review-item .client-info p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'desig_font_size',
			[
				'label' => esc_html__( 'Designation Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .clients-review-item .client-info p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this-> end_controls_section();
    }

    protected function render() 
    {
        $settings = $this->get_settings_for_display();

        global $veliki_opt;
        
        // Text Alignment
		if( $settings['card_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} elseif( $settings['card_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
        }
        
        $slider = $settings['all_feedback'];
        
        $count = 0;
        foreach ( $slider as $value ) {
            $count++;
        } ?>

        <div class="clients-review-area ptb-100">
            <div class="container">
                <?php if( $settings['top_title'] != '' || $settings['title'] != ''): ?>
                    <div class="section-title">
                        <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                        <<?php echo esc_attr( $settings['title_tag'] ); ?> class="title"><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    </div>
                <?php endif; ?>
                
                <div class="clients-review-slides owl-carousel owl-theme">
                    <?php foreach( $settings['all_feedback'] as $item ) : ?>
                        <div class="clients-review-item <?php echo esc_attr( $alignment); ?>">

                            <span><?php echo esc_html( $item['feedback_title'] ); ?></span>

                            <p><?php echo wp_kses_post( $item['feedback'] ); ?></p>
        
                            <div class="client-info">
                                <?php if( $item['client_image']['url'] != ''): ?>
                                    <img src="<?php echo esc_url( $item['client_image']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'veliki-toolkit'); ?>">
                                <?php endif; ?>

                                <h3><?php echo esc_html( $item['client_name'] ); ?></h3>
                                <p><?php echo esc_html( $item['client_desig'] ); ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <style>
            .clients-review-item::before {
                background-image: url(<?php echo esc_url( $settings['quote_image']['url'] ); ?>);
            }
        </style>
    <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new TestimonialTwo );