<?php
namespace Elementor;
class FeatureWrap extends Widget_Base{
    public function get_name(){
        return "feature-wrap";
    }
    public function get_title(){
        return "Feature Wrap";
    }
    public function get_icon(){
        return "eicon-favorite";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'feature_section_content',
            [
                'label' => esc_html__('Feature Content', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'veliki-toolkit' ),
                    3   => __( '3', 'veliki-toolkit' ),
                    4   => __( '4', 'veliki-toolkit' ),
                ],
                'default' => 3,
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control(
            'feature_image',
            [
                'label' => esc_html__('Image', 'veliki-toolkit' ),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'feature_title', [
                'label' => esc_html__( 'Feature Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'feature_title_tag',
            [
                'label' => __('Feature Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'feature_details', [
                'label' => esc_html__( 'Feature Details', 'veliki-toolkit' ),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'feature_content',
            [
                'label' => esc_html__( 'Add Feature Content', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this-> end_controls_section();
        // End Tab content controls

        // Start Features Card Style
        $this-> start_controls_section(
            'featured_style',
            [
                'label'=>esc_html__('Features Style', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'card_color',
                [
                    'label' => esc_html__( 'Card Color', 'cyarb-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .features-wrap-card' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'cyarb-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .features-wrap-card .content .title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'cyarb-toolkit' ),
                    'selector' => '{{WRAPPER}} .features-wrap-card .content .title',
                ]
            );
            $this->add_control(
                'desc_color',
                [
                    'label' => esc_html__( 'Description Color', 'cyarb-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .features-wrap-card .content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'desc_typography',
                    'label' => __( 'Description Typography', 'cyarb-toolkit' ),
                    'selector' => '{{WRAPPER}} .features-wrap-card .content p',
                ]
            );

        $this-> end_controls_section();
    }
    // Register control section end here

    protected function render()
    {
        $settings = $this->get_settings_for_display();
   
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif; 
        
        $columns = $settings['columns'];
        if ($columns == 2) {
            $column = 'col-lg-6 col-md-6';
        } elseif ($columns == 4) {
            $column = 'col-lg-3 col-md-6';
        } else {
            $column = 'col-lg-4 col-md-6';
        } 
        
        ?>

        <div class="features-wrap-area pb-70">
            <div class="container">
                <div class="row justify-content-center">
                    <?php foreach ( $settings['feature_content'] as $item ) { ?>
                        <div class="<?php echo esc_attr($column); ?>">
                            <div class="features-wrap-card">
                                <div class="content">
                                    <?php if( $item['feature_image']['url'] != ''): ?>
                                        <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $item['feature_image']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">
                                    <?php endif; ?>

                                    <<?php echo esc_attr( $item['feature_title_tag'] ); ?> class="title"><?php echo esc_html( $item['feature_title'] ); ?></<?php echo esc_attr( $item['feature_title_tag'] ); ?>>
                                    <p><?php echo wp_kses_post( $item['feature_details'] ); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <?php
    } 
}
Plugin::instance()->widgets_manager->register_widget_type( new FeatureWrap );