<?php
namespace Elementor;
class FeatureWidget extends Widget_Base{
    public function get_name(){
        return "feature-widget";
    }
    public function get_title(){
        return "Feature Widget";
    }
    public function get_icon(){
        return "eicon-favorite";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'feature_section_content',
            [
                'label'=>esc_html__('Feature Section Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'about_text_alignment',
			[
				'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '1'
			]
		);
        $this->add_control(
            'title', [
                'label' => esc_html__( 'Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'desc', [
                'label' => esc_html__( 'Description', 'veliki-toolkit' ),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
                'label_block' => true,
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'feature_image',
            [
                'label' => esc_html__('Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'feature_title', [
                'label' => esc_html__( 'Feature Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'feature_title_tag',
            [
                'label' => __('Feature Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'feature_details', [
                'label' => esc_html__( 'Feature Details', 'veliki-toolkit' ),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'feature_list', [
                'label' => esc_html__( 'Feature Lists', 'veliki-toolkit' ),
                'type' => Controls_Manager::WYSIWYG,
            ]
        );

        $repeater->add_control(
			'card_text_alignment',
			[
				'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '3'
			]
		);
        $this->add_control(
            'feature_content',
            [
                'label' => esc_html__( 'Add Feature Content', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        // Box Shape
        $this->add_control(
			'section_shape',
			[
				'label' => esc_html__( 'Show Shape?', 'veliki-toolkit' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'veliki-toolkit' ),
				'label_off' => esc_html__( 'Hide', 'veliki-toolkit' ),
				'return_value' => 'yes',
                'default' => 'yes',
			]
        );
        $this-> end_controls_section();
        // End Tab content controls

        // Start Features Card Style
        $this-> start_controls_section(
            'featured_style',
            [
                'label'=>esc_html__('Features Style', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 60,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Description Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'desc_font_size',
			[
				'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'feature_title_color',
            [
                'label' => esc_html__( 'Feature Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .overview-box .content h3, .overview-box .content h1, .overview-box .content h2, .overview-box .content h4, .overview-box .content h5, .overview-box .content h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_responsive_control(
			'feature_title_font_size',
			[
				'label' => esc_html__( 'Feature Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 60,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .overview-box .content h3, .overview-box .content h1, .overview-box .content h2, .overview-box .content h4, .overview-box .content h5, .overview-box .content h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_responsive_control(
			'feature_desc_font_size',
			[
				'label' => esc_html__( 'Feature Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .overview-box .content p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'feature_list_icon_color',
            [
                'label' => esc_html__( 'Feature List Icon Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .overview-box .content .features-list li span i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'feature_list_title_color',
            [
                'label' => esc_html__( 'Feature List Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .overview-box .content .features-list li span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'feature_list_title_font_size',
			[
				'label' => esc_html__( 'Feature List Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .overview-box .content .features-list li span' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this-> end_controls_section();
    }
    // Register control section end here

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        // Text Alignment
		if( $settings['about_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['about_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
		}
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif; ?>

        <!-- Start Features Area -->
        <div class="features-area ptb-110">
            <div class="container">
                <div class="section-title <?php echo esc_attr( $alignment); ?>">
                    <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                    <?php echo wp_kses_post( $settings['desc'] ); ?>
                </div>

                <?php if ($settings['feature_content'] !='') { 
                    $i = 1; 
                    foreach ( $settings['feature_content'] as $item ) { 

                        // Text Alignment
                        if( $item['card_text_alignment' ] == '1') {
                            $c_alignment = 'text-center';
                        } 
                        elseif( $item['card_text_alignment' ] == '2') {
                            $c_alignment = 'text-right';
                        } else {
                            $c_alignment = 'text-left';
                        }

                        if( $i % 2 != 0) { ?>
                            <div class="overview-box">
                                <div class="image">
                                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $item['feature_image']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">
                                </div>

                                <div class="content <?php echo esc_attr( $c_alignment); ?>">
                                    <<?php echo esc_attr( $item['feature_title_tag'] ); ?>><?php echo esc_html( $item['feature_title'] ); ?></<?php echo esc_attr( $item['feature_title_tag'] ); ?>>
                                    <p><?php echo wp_kses_post( $item['feature_details'] ); ?></p>
                                    <?php echo wp_kses_post( $item['feature_list'] ); ?>
                                </div>
                            </div> 
                            <?php
                        } else { ?>
                            <div class="overview-box">
                                <div class="content <?php echo esc_attr( $c_alignment); ?>">
                                    <<?php echo esc_attr( $item['feature_title_tag'] ); ?>><?php echo esc_html( $item['feature_title'] ); ?></<?php echo esc_attr( $item['feature_title_tag'] ); ?>>
                                    <p><?php echo wp_kses_post( $item['feature_details'] ); ?></p>
                                    <?php echo wp_kses_post( $item['feature_list'] ); ?>
                                </div>

                                <div class="image">
                                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $item['feature_image']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">
                                </div>
                            </div>
                            <?php
                        }
                        $i++;
                    }
                } ?>
            </div>

            <?php 
            if ( 'yes' === $settings['section_shape'] ) { ?>
                <div class="rectangle-shape1">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/rectangle-shape1.png' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                </div>
                <div class="rectangle-shape2">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/rectangle-shape2.png' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                </div>
                <div class="shape1">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/shape/1.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                </div>
                <div class="shape2">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/shape/1.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                </div>
                <div class="shape3">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/shape/1.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                </div>
            <?php
            } ?>
        </div>
        <?php
    }

       
}
Plugin::instance()->widgets_manager->register_widget_type( new FeatureWidget );