<?php namespace Elementor;

class FAQContactWidget extends Widget_Base{
    public function get_name(){
        return "faq-contact-widget";
    }
    public function get_title(){
        return "FAQ Contact Widget";
    }
    public function get_icon(){
        return "eicon-call-to-action";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){

    // Start FAQ Contact Controls
    $this-> start_controls_section(
        'top_content',
        [
            'label'=>esc_html__('Contact Content', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_CONTENT,
        ]
    );

    $this->add_control(
        'section_title',
        [
            'label' => esc_html__( 'Title', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );
    $this->add_control(
        'title_tag',
        [
            'label' => __('Title Tag', 'veliki-toolkit'),
            'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                ],
            'default'     => 'h2',
            'label_block' => true,
        ]
    );
    $this->add_control(
        'section_desc',
        [
            'label' => esc_html__( 'Description', 'veliki-toolkit' ),
            'type'=>Controls_Manager:: WYSIWYG,
            'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
        ]
    );

    $this->add_control(
        'faq_text_alignment',
        [
            'label' => __( 'Faq Title Alignment', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
            ],
            'default' => '1'
        ]
    );

    $this->add_control(
        'contact_shortcode',
        [
            'label' => esc_html__( 'FAQ Form Shortcode', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );
    $this-> end_controls_section();
    // End FAQ Contact Controls

    // Start FAQ  Style
    $this-> start_controls_section(
        'faq_contact_style',
        [
            'label'=>esc_html__('Content', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_STYLE,
        ]
    );
    $this->add_control(
        'title_color',
        [
            'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
            ],
        ]
    );
    $this->add_responsive_control(
        'title_font_size',
        [
            'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 60,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );
    $this->add_responsive_control(
        'desc_size',
        [
            'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 30,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );
    $this-> end_controls_section();  
}
    // Register control section end here
    protected function render() 
    {
        $settings = $this->get_settings_for_display(); 
            // Text Alignment
            if( $settings['faq_text_alignment' ] == '1') {
                $alignment = 'text-center';
            } 
            elseif( $settings['faq_text_alignment' ] == '2') {
                $alignment = 'text-right';
            } else {
                $alignment = 'text-left';
            }
        ?>
        <div class="faq-area pb-110">
            <div class="container">
                <div class="faq-contact">
                    <div class="section-title <?php echo esc_attr( $alignment); ?>">
                        <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['section_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                        <?php echo wp_kses_post( $settings['section_desc'] ); ?>
                    </div>
                    <div class="faq-contact-form">
                        <div class="form">
                            <?php $form = $settings['contact_shortcode']; 
                            echo do_shortcode($form); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div> <?php    
    }
       
}
Plugin::instance()->widgets_manager->register_widget_type( new FAQContactWidget );