<?php namespace Elementor;

class ContactWidget extends Widget_Base{
    public function get_name(){
        return "contact-widget";
    }
    public function get_title(){
        return "Contact Widget";
    }
    public function get_icon(){
        return "eicon-form-horizontal";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){

    // Start FAQ Contact Controls
    $this-> start_controls_section(
        'top_content',
        [
            'label'=>esc_html__('Contact Content', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_CONTENT,
        ]
    );
    
    $this->add_control(
        'top_title',
        [
            'label' => esc_html__( 'Top Title', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );

    $this->add_control(
        'section_title',
        [
            'label' => esc_html__( 'Title', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );
    $this->add_control(
        'title_tag',
        [
            'label' => __('Title Tag', 'veliki-toolkit'),
            'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                ],
            'default'     => 'h2',
            'label_block' => true,
        ]
    );
    $this->add_control(
        'section_desc',
        [
            'label' => esc_html__( 'Description', 'veliki-toolkit' ),
            'type'=>Controls_Manager:: WYSIWYG,
            'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
        ]
    );
    $this->add_control(
        'choose_text_alignment',
        [
            'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
            ],
            'default' => '1'
        ]
    );

    $this->add_control(
        'card_text_alignment',
        [
            'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                '1'     => __( 'Text Align Center', 'veliki-toolkit' ),
                '2'     => __( 'Text Align Right', 'veliki-toolkit' ),
                '3'     => __( 'Text Align Left', 'veliki-toolkit' ),
            ],
            'default' => '1'
        ]
    );
    $this->add_control(
        'contact_shortcode',
        [
            'label' => esc_html__( 'Contact Form Shortcode', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );
    $this-> end_controls_section();

    $this-> start_controls_section(
        'bottom_content',
        [
            'label'=>esc_html__('Contact Information', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_CONTENT,
        ]
    );

    $this->add_control(
        'section_sub_title',
        [
            'label' => esc_html__( 'Contact Subtitle', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );

    $this->add_control(
        'phone_number',
        [
            'label' => esc_html__( 'Contact Number', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );

    
    $this->add_control(
        'or_text',
        [
            'label' => esc_html__( 'OR', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );

    $this->add_control(
        'gmail_address',
        [
            'label' => esc_html__( 'Mail Address', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );

    
    $repeater = new Repeater();

    $repeater->add_control(
        'icon',
        [
            'label' => esc_html__( 'Social Icons', 'veliki-toolkit' ),
            'type' 			=> Controls_Manager::ICON,
            'label_block' 	=> true,
            'options' 		=> domain_font_awesome(),
            'default' 		=> 'fab fa-facebook-f',
        ]
    );
    $repeater->add_control(
        'social_url',
        [
            'label' => esc_html__( 'URL', 'veliki-toolkit' ),
            'type' => Controls_Manager::TEXT,
        ]
    );
    $this->add_control(
        'icon_list',
        [
            'label' => esc_html__( 'Add Social List', 'veliki-toolkit' ),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]
    );

    $this-> end_controls_section();
    // End Contact Controls

    // Start Contact Style
    $this-> start_controls_section(
        'contact_style',
        [
            'label'=>esc_html__('Content', 'veliki-toolkit'),
            'tab'=> Controls_Manager::TAB_STYLE,
        ]
    );
    $this->add_responsive_control(
        'con_top_font_size',
        [
            'label' => esc_html__( 'Top Title Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 30,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .section-title span' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );
    $this->add_control(
        'con_title_color',
        [
            'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
            ],
        ]
    );
    $this->add_responsive_control(
        'con_title_font_size',
        [
            'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 60,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );
    $this->add_responsive_control(
        'con_desc_size',
        [
            'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 30,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );

    // Button
    $this->add_control(
        'con_btn_color',
        [
            'label' => esc_html__( 'Button Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .btn-primary' => 'color: {{VALUE}}',
            ],
        ]
    );
    $this->add_control(
        'con_btn_hcolor',
        [
            'label' => esc_html__( 'Hover Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .btn-primary:hover, .btn-primary:focus' => 'color: {{VALUE}} !important',
            ],
        ]
    );

    // Subtitle style
    $this->add_control(
        'con_subtitle_color',
        [
            'label' => esc_html__( 'Subtitle Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact-info .contact-info-content h3' => 'color: {{VALUE}}',
            ],
        ]
    );
    $this->add_responsive_control(
        'con_subtitle_size',
        [
            'label' => esc_html__( 'Subtitle Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 40,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .contact-info .contact-info-content h3' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );

    // Number style
    $this->add_responsive_control(
        'con_num_size',
        [
            'label' => esc_html__( 'Contact Number Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 50,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .contact-info .contact-info-content h2 a' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );

    // OR style
    $this->add_control(
        'con_or_color',
        [
            'label' => esc_html__( 'OR Text Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact-info .contact-info-content h2 span' => 'color: {{VALUE}}',
            ],
        ]
    );
    $this->add_responsive_control(
        'con_or_size',
        [
            'label' => esc_html__( 'OR Text Font Size', 'veliki-toolkit' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 30,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'unit' => 'px',
            'selectors' => [
                '{{WRAPPER}} .contact-info .contact-info-content h2 span' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]
    );

    // Social style
    $this->add_control(
        'con_social_style',
        [
            'label' => esc_html__( 'Social', 'veliki-toolkit' ),
            'type' => Controls_Manager::HEADING,
        ]
    );
    $this->add_control(
        'con_social_color',
        [
            'label' => esc_html__( 'Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact-info .contact-info-content .social li a' => 'color: {{VALUE}}',
            ],
        ]
    );
    $this->add_control(
        'con_social_border',
        [
            'label' => esc_html__( 'Border Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact-info .contact-info-content .social li a' => 'border-color: {{VALUE}}',
            ],
        ]
    );
    $this->add_control(
        'con_social_hcolor',
        [
            'label' => esc_html__( 'Hover Color', 'veliki-toolkit' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact-info .contact-info-content .social li a:hover' => 'color: {{VALUE}}',
            ],
        ]
    );
    $this-> end_controls_section();   
}
    // Register control section end here

    protected function render() 
    {
        $settings = $this->get_settings_for_display(); 
        
        // Text Alignment
		if( $settings['choose_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['choose_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
        }
        
        // Text Alignment
        if( $settings['card_text_alignment' ] == '1') {
            $c_alignment = 'text-center';
        } 
        elseif( $settings['card_text_alignment' ] == '2') {
            $c_alignment = 'text-right';
        } else {
            $c_alignment = 'text-left';
        }
        ?>
        <div class="contact-area ptb-110">
            <div class="container">
                <div class="section-title <?php echo esc_attr( $alignment); ?>">
                    <span><?php echo esc_html($settings['top_title']); ?></span>
                    <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['section_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                    <?php echo wp_kses_post( $settings['section_desc'] ); ?>
                </div>

                <div class="contact-form">
                    <div class="form">
                        <?php $form = $settings['contact_shortcode']; 
                        echo do_shortcode($form); ?>
                    </div>
                </div>

                <div class="contact-info">
                    <div class="contact-info-content <?php echo esc_attr( $c_alignment); ?>">
                        <h3><?php echo esc_html($settings['section_sub_title']); ?></h3>
                        <h2>
                            <a href="<?php echo esc_attr__("tel:","veliki-toolkit")?><?php echo wp_kses_post(str_replace(' ', '', $settings['phone_number']), "veliki-toolkit") ?>"><?php echo esc_html($settings['phone_number']); ?></a>

                            <span><?php echo esc_html($settings['or_text']); ?></span>

                            <a href="<?php echo esc_attr__("mailto:","veliki-toolkit")?><?php echo esc_url($settings['gmail_address']); ?>"><?php echo esc_html($settings['gmail_address']); ?></a>
                        </h2>

                        <ul class="social">
                            <?php
                            if ( $settings['icon_list']!='' ){ 
                                foreach ( $settings['icon_list'] as $item ) {
                                    if($item['icon']!=''){ ?>
                                        <li><a href="<?php echo esc_url($item['social_url']); ?>" target="_blank"><i class="<?php echo esc_attr($item['icon']); ?>"></i></a></li>
                                    <?php
                            } } } ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    <?php    
    }

       
}
Plugin::instance()->widgets_manager->register_widget_type( new ContactWidget );