<?php 
namespace Elementor;
class ComingSoonWidget extends Widget_Base{
    public function get_name(){
        return "comingsoon-widget";
    }
    public function get_title(){
        return "Coming Soon";
    }
    public function get_icon(){
        return "fa fa-creative-commons";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Start Left Content
        $this-> start_controls_section(
            'comingsoon_section',
            [
                'label'=>esc_html__('Left Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'default' =>'full',
                'name' => 'imagesz',
            ]
        );
        $this-> end_controls_section();
        // End Left Content

        // Start Right Content
        $this-> start_controls_section(
            'comingsoon_right',
            [
                'label'=>esc_html__('Right Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'choose_text_alignment',
			[
				'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '3'
			]
		);

        $this->add_control(
            'title',
            [
                'label'=> esc_html__('Title','veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'fname',
            [
                'label'=> esc_html__('Name Placeholder','veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
                'default'=> esc_html__('Your Name','veliki-toolkit'),
            ]
        );
        $this->add_control(
            'emailadd',
            [
                'label'=> esc_html__('Email Placeholder','veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
                'default'=> esc_html__('Your Email','veliki-toolkit'),
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label'=> esc_html__('Button Text','veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $this->add_control(
            'desc',
            [
                'label'=> esc_html__('Description','veliki-toolkit'),
                'type' => Controls_Manager::WYSIWYG,
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__( 'Social Icons', 'veliki-toolkit' ),
                'type' 			=> Controls_Manager::ICON,
                'label_block' 	=> true,
                'options' 		=> domain_font_awesome(),
                'default' 		=> 'fab fa-facebook-f',
            ]
        );
        $repeater->add_control(
            'social_link',
            [
                'label' => esc_html__( 'URL', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'social_color',
            [
                'label' => esc_html__( 'Choose Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'  => esc_html__( 'Facebook Color', 'veliki-toolkit' ),
                    '2'  => esc_html__( 'Youtube Color', 'veliki-toolkit' ),
                    '3'  => esc_html__( 'Twitter Color', 'veliki-toolkit' ),
                    '4'  => esc_html__( 'Linkedin Color', 'veliki-toolkit' ),
                    '5'  => esc_html__( 'Instagram Color', 'veliki-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'social_list',
            [
                'label' => esc_html__( 'Add Social List', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this->add_control(
            'select_mod',
            [
                'label' => esc_html__( 'Newsletter Option', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'mailchimp'             => esc_html__( 'Mailchimp', 'veliki-toolkit' ),
                ],
                'default' => 'mailchimp',
            ]
        );

        $this->add_control(
            'action_url', [
                'label' => esc_html__( 'Action URL', 'veliki-toolkit' ),
                'description' => __( 'Enter here your MailChimp action URL. <a href="https://www.docs.envytheme.com/docs/veliki-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a>', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'condition' => [
                    'select_mod' => 'mailchimp',
                ],
                'default' => 'https://envytheme.us20.list-manage.com/subscribe/post?u=60e1ffe2e8a68ce1204cd39a5&amp;id=42d6d188d9
                ',
            ]
        );
        $this-> end_controls_section();
        // End Right Content

        // Start Comingsoon Styling
        $this-> start_controls_section(
            'coming_style',
            [
                'label'=>esc_html__('Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'title_style',
			[
				'label' => esc_html__( 'Title', 'veliki-toolkit' ),
				'type' => Controls_Manager::HEADING,
			]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .coming-soon-content h3, .coming-soon-content h1, .coming-soon-content h2, .coming-soon-content h4, .coming-soon-content h5, .coming-soon-content h6' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
			'title_size',
			[
				'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 70,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}}  .coming-soon-content h3, .coming-soon-content h1, .coming-soon-content h2, .coming-soon-content h4, .coming-soon-content h5, .coming-soon-content h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__( 'Button Text Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-primary' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
			'btn_size',
			[
				'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}}  .btn-primary' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        
        $this->add_control(
			'timer_style',
			[
				'label' => esc_html__( 'Timer', 'veliki-toolkit' ),
				'type' => Controls_Manager::HEADING,
			]
        );
        $this->add_control(
            'timer_color',
            [
                'label' => esc_html__( 'Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .coming-soon-area .coming-soon-time #timer div' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'timer_size',
			[
				'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}}  .coming-soon-area .coming-soon-time #timer div' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this-> end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        // Text Alignment
		if( $settings['choose_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['choose_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
		}

        // Black Logo
        if(isset($veliki_opt['black_logo']['url']) && $veliki_opt['black_logo']['url'] !='' ) {
            $black_logo = $veliki_opt['black_logo']['url'];
        } else {
            $black_logo = "null";
        } ?>

        <!-- Start Coming Soon Area -->
        <div class="coming-soon-area">
            <div class="container-fluid p-0">
                <div class="row m-0">
                    <div class="col-lg-6 col-md-12 p-0">
                        <div class="coming-soon-time" style="background-image: url(<?php echo esc_url( $settings['bg_image']['url']); ?> )">
                            <?php echo Group_Control_Image_Size::get_attachment_image_html($settings,'imagesz','bg_image'); ?>

                            <div id="timer">
                                <div id="days"></div>
                                <div id="hours"></div>
                                <div id="minutes"></div>
                                <div id="seconds"></div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6 col-md-12 p-0">
                        <div class="coming-soon-content <?php echo esc_attr( $alignment); ?>">
                            <div class="d-table">
                                <div class="d-table-cell">
                                    <div class="logo">
                                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                            <?php
                                            // Black Logo
                                            if ( $black_logo != 'null' ) { ?>
                                                <img src="<?php echo esc_url($black_logo); ?>" alt="<?php bloginfo( 'title' ); ?>"><?php
                                            }else{ ?>
                                                <h2><?php bloginfo( 'name' ); ?></h2>
                                            <?php }  ?>
                                        </a>
                                    </div>
                                    
                                    <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                    <form class="newsletter-form mailchimp" data-toggle="validator" method="post" action="<?php echo get_bloginfo();?>/?na=s" onsubmit="return newsletter_check(this)">
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="nn" placeholder="<?php echo esc_attr($settings['fname']);?>" required autocomplete="off">
                                        </div>

                                        <div class="form-group">
                                            <input type="email" class="form-control" placeholder="<?php echo esc_attr($settings['emailadd']);?>" name="EMAIL" required autocomplete="off">
                                        </div>
                                        
                                        <?php 
                                        if($settings['btn_text']!=''){ ?>
                                            <button type="submit" class="btn btn-primary"><?php echo esc_html($settings['btn_text']);?></button> <?php
                                        } ?>

                                        <p><?php echo wp_kses_post($settings['desc']);?></p>

                                        <p class="mchimp-errmessage" style="display: none;"></p>
                                        <p class="mchimp-sucmessage" style="display: none;"></p>
                                    </form>

                                    <div class="social">
                                        <ul>
                                            <?php if ( $settings['social_list']!='' ) :
                                                foreach ( $settings['social_list'] as $item ) :
                                                    if ($item['social_color'] == 1) {
                                                        $cls="facebook";
                                                    } elseif ($item['social_color'] == 2) {
                                                        $cls="youtube";
                                                    } elseif ($item['social_color'] == 3) {
                                                        $cls="twitter";
                                                    } elseif ($item['social_color'] == 4) {
                                                        $cls="linkedin";
                                                    } else {
                                                        $cls="instagram";
                                                    }
                                                    if($item['icon']!='') : ?>
                                                        <li>
                                                            <a href="<?php echo esc_url( $item['social_link'] ); ?>" target="_blank" class="<?php echo esc_attr( $cls ); ?>"><i class="<?php echo esc_attr( $item['icon'] ); ?>"></i></a>
                                                        </li><?php
                                                    endif; 
                                                endforeach; 
                                            endif;?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Coming Soon Area -->

        <script>
            ;(function($){
                "use strict";
                $(document).ready(function () {
                    // MAILCHIMP
                    if ($(".mailchimp").length > 0) {
                        $(".mailchimp").ajaxChimp({
                            callback: mailchimpCallback,
                            url: "<?php echo esc_js($settings['action_url']) ?>" //Replace this with your own mailchimp post URL. Don't remove the "". Just paste the url inside "".
                        });
                    }
                    $(".memail").on("focus", function () {
                        $(".mchimp-errmessage").fadeOut();
                        $(".mchimp-sucmessage").fadeOut();
                    });
                    $(".memail").on("keydown", function () {
                        $(".mchimp-errmessage").fadeOut();
                        $(".mchimp-sucmessage").fadeOut();
                    });
                    $(".memail").on("click", function () {
                        $(".memail").val("");
                    });

                    function mailchimpCallback(resp) {
                        if (resp.result === "success") {
                            $(".mchimp-sucmessage").html(resp.msg).fadeIn(1000);
                            $(".mchimp-sucmessage").fadeOut(500);
                        } else if (resp.result === "error") {
                            $(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
                        }
                    }
                });
            })(jQuery)
        </script>
        <?php
    }
       
}
Plugin::instance()->widgets_manager->register_widget_type( new ComingSoonWidget );