<?php
namespace Elementor;
class ChooseUsWidget extends Widget_Base{
    public function get_name(){
        return "choose-us-widget";
    }
    public function get_title(){
        return "Choose Us";
    }
    public function get_icon(){
        return "eicon-favorite";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'section_content',
            [
                'label'=>esc_html__('Section Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__( 'Background Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
			'about_text_alignment',
			[
				'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '3'
			]
		);
        $this->add_control(
            'title', [
                'label' => esc_html__( 'Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'desc', [
                'label' => esc_html__( 'Description', 'veliki-toolkit' ),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
                'label_block' => true,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
			'card_text_alignment',
			[
				'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '1'
			]
		);

        $repeater->add_control(
            'card_icon',
            [
                'label' => esc_html__( 'Choose Card Icon', 'veliki-toolkit' ),
                'type' 			=> Controls_Manager::ICON,
                'label_block' 	=> true,
                'options' 		=> domain_font_awesome(),
                'default' 		=> 'fab fa-facebook-f',
            ]
        );
        
        $repeater->add_control(
            'card_title', [
                'label' => esc_html__( 'Card Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'card_title_tag',
            [
                'label' => __('Card Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'card_details', [
                'label' => esc_html__( 'Card Details', 'veliki-toolkit' ),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'card_list',
            [
                'label' => esc_html__( 'Add Card Content', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
			'lines_show',
			[
				'label' => esc_html__( 'Lines Show?', 'veliki-toolkit' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'veliki-toolkit' ),
				'label_off' => esc_html__( 'Hide', 'veliki-toolkit' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
        );

        $this-> end_controls_section();
        // End Tab content controls

        // Start Features Card Style
        $this-> start_controls_section(
            'choose_us_style',
            [
                'label'=>esc_html__('Choose Us Style', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bannerbg_color',
            [
                'label' => esc_html__( 'Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .why-choose-us-area' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 60,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Description Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'desc_font_size',
			[
				'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 30,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .section-title p, .section-title ul li, .section-title ol li' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'card_title_color',
            [
                'label' => esc_html__( 'Card Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-choose-us-box .title h3, .single-choose-us-box .content h3, .single-choose-us-box .title h1, .single-choose-us-box .content h1, .single-choose-us-box .title h2, .single-choose-us-box .content h2, .single-choose-us-box .title h4, .single-choose-us-box .content h4, .single-choose-us-box .title h5, .single-choose-us-box .content h5, .single-choose-us-box .title h6, .single-choose-us-box .content h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'card_title_font_size',
			[
				'label' => esc_html__( 'Card Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 40,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .single-choose-us-box .title h3, .single-choose-us-box .content h3, .single-choose-us-box .title h1, .single-choose-us-box .content h1, .single-choose-us-box .title h2, .single-choose-us-box .content h2, .single-choose-us-box .title h4, .single-choose-us-box .content h4, .single-choose-us-box .title h5, .single-choose-us-box .content h5, .single-choose-us-box .title h6, .single-choose-us-box .content h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_responsive_control(
			'card_details_font_size',
			[
				'label' => esc_html__( 'Card Hover Details Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .single-choose-us-box .content p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this-> end_controls_section();
    }
    // Register control section end here

    protected function render()
    {
        $settings = $this->get_settings_for_display(); 
            // Text Alignment
            if( $settings['about_text_alignment' ] == '1') {
                $alignment = 'text-center';
            } 
            elseif( $settings['about_text_alignment' ] == '2') {
                $alignment = 'text-right';
            } else {
                $alignment = 'text-left';
            }
        ?>
        <!-- Start Why Choose Us Area -->
        <div class="why-choose-us-area ptb-110" style="background-image: url(<?php echo esc_url( $settings['bg_image']['url']); ?> )">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12 col-sm-12">
                        <div class="section-title <?php echo esc_attr( $alignment); ?>">
                            <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                            <?php echo wp_kses_post( $settings['desc'] ); ?>
                        </div>
                    </div>

                    <?php if ($settings['card_list'] !='') : 
                        foreach ( $settings['card_list'] as $item ) : 
                            // Text Alignment
                            if( $item['card_text_alignment' ] == '1') {
                                $c_alignment = 'text-center';
                            } 
                            elseif( $item['card_text_alignment' ] == '2') {
                                $c_alignment = 'text-right';
                            } else {
                                $c_alignment = 'text-left';
                            }
                        
                        ?>
                            <div class="col-lg-3 col-md-4 col-sm-6">
                                <div class="single-choose-us-box <?php echo esc_attr( $c_alignment); ?>">
                                    <div class="title">
                                        <div class="icon">
                                            <i class="<?php echo esc_attr( $item['card_icon'] ); ?>"></i>
                                        </div>
                                        <<?php echo esc_attr( $item['card_title_tag'] ); ?>><?php echo esc_html( $item['card_title'] ); ?></<?php echo esc_attr( $item['card_title_tag'] ); ?>>
                                    </div>

                                    <div class="content">
                                        <<?php echo esc_attr( $item['card_title_tag'] ); ?>><?php echo esc_html( $item['card_title'] ); ?></<?php echo esc_attr( $item['card_title_tag'] ); ?>>
                                        <p><?php echo wp_kses_post( $item['card_details'] ); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach;
                    endif; ?>
                </div>
            </div>

            <?php if ( 'yes' === $settings['lines_show'] ) : ?>
                <div class="lines">
                    <div class="line"></div>
                    <div class="line"></div>
                    <div class="line"></div>
                </div>
            <?php endif; ?>
        </div>
        <!-- End Why Choose Us Area -->
        <?php
    }

       
}
Plugin::instance()->widgets_manager->register_widget_type( new ChooseUsWidget );