<?php
namespace Elementor;
class BannerWidget extends Widget_Base{
    public function get_name(){
        return "banner-widget";
    }
    public function get_title(){
        return "Main Banner";
    }
    public function get_icon(){
        return "eicon-banner";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'section_content',
            [
                'label'=>esc_html__('Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'section_shape',
			[
				'label' => esc_html__( 'Hide Shapes?', 'veliki-toolkit' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'veliki-toolkit' ),
				'label_off' => esc_html__( 'Hide', 'veliki-toolkit' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
        );
        $this->add_control(
			'lines_show',
			[
				'label' => esc_html__( 'Lines Show?', 'veliki-toolkit' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'veliki-toolkit' ),
				'label_off' => esc_html__( 'Hide', 'veliki-toolkit' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
        );

        $this->add_control(
            'banner_bg_image',
            [
                'label' => esc_html__( 'Banner Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
			'banner_text_alignment',
			[
				'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '3'
			]
		);
        $this->add_control(
            'banner_title',
            [
                'label'=>esc_html__('Title', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h1',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_desc',
            [
                'label'=>esc_html__('Description', 'veliki-toolkit'),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
            ]
        );

        // Button One
        $this->add_control(
            'button_one_text',
            [
                'label'=>esc_html__('Button One Text', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );

        $this->add_control(
            'link_type',
            [
                'label' => esc_html__( 'Link Type', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    '1'  => esc_html__( 'Link To Page', 'veliki-toolkit' ),
                    '2' => esc_html__( 'External Link', 'veliki-toolkit' ),
                ], 
            ]
        );

        $this->add_control(
            'link_to_page',
            [
                'label' => esc_html__( 'Link Page', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => veliki_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type' => '1',
                ]
            ]
        );

        $this->add_control(
            'external_link',
            [
                'label'=>esc_html__('External Link', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
                'condition' => [
                    'link_type' => '2',
                ]
            ]
        );

        //Target Page
        $this->add_control(
            'target_page',
            [
                'label' => __( 'Link Open In New Tab?', 'plaby-toolkit' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'plaby-toolkit' ),
                'label_off' => __( 'No', 'plaby-toolkit' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // Button Two
        $this->add_control(
            'button_two_text',
            [
                'label'=>esc_html__('Button Two Text', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );

        $this->add_control(
            'link_type2',
            [
                'label' => esc_html__( 'Link Type', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    '1'  => esc_html__( 'Link To Page', 'veliki-toolkit' ),
                    '2' => esc_html__( 'External Link', 'veliki-toolkit' ),
                ], 
            ]
        );

        $this->add_control(
            'link_to_page2',
            [
                'label' => esc_html__( 'Link Page', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => veliki_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type2' => '1',
                ]
            ]
        );

        $this->add_control(
            'external_link2',
            [
                'label'=>esc_html__('External Link', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
                'condition' => [
                    'link_type2' => '2',
                ]
            ]
        );

        //Target Page
        $this->add_control(
            'target_page2',
            [
                'label' => __( 'Link Open In New Tab?', 'plaby-toolkit' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'plaby-toolkit' ),
                'label_off' => __( 'No', 'plaby-toolkit' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this-> end_controls_section();

        // End Tab content controls

        // Start Style content controls
        $this-> start_controls_section(
            'content_style',
            [
                'label'=>esc_html__('Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'banner_color',
            [
                'label' => esc_html__( 'Banner Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-banner' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-banner-content h1, .main-banner-content h2, .main-banner-content h3, .main-banner-content h4, .main-banner-content h5, .main-banner-content h6' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 80,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .main-banner-content h1, .main-banner-content h2, .main-banner-content h3, .main-banner-content h4, .main-banner-content h5, .main-banner-content h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Description Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-banner-content p, .main-banner-content ul li, .main-banner-content ol li' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
			'desc_size',
			[
				'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .main-banner-content p, .main-banner-content ul li, .main-banner-content ol li' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_responsive_control(
			'btn_font_size',
			[
				'label' => esc_html__( 'Button Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .btn' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__( 'Button One Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-primary' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn_hcolor',
            [
                'label' => esc_html__( 'Button Hover Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .main-banner-content .btn-box .btn-primary::after' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn2_bgcolor',
            [
                'label' => esc_html__( 'Button Two Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-light' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn2_hcolor',
            [
                'label' => esc_html__( 'Button Hover Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .btn-light:hover, .btn-light:focus' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this-> end_controls_section();
        // End Style content controls
    }

    protected function render()
    {
        // Retrieve all controls value
        $settings = $this->get_settings_for_display();
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

         // Text Alignment
		if( $settings['banner_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['banner_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
		}

        $title = $settings['banner_title'];
        $desc  = $settings['banner_desc'];
        $btn1_text  = $settings['button_one_text'];
        $btn2_text  = $settings['button_two_text'];

        //  Button Link
        $link_one = '';
        if( $settings['link_type'] == 1 ){
            $link_one = get_page_link($settings['link_to_page']); 
        } else {
            $link_one = $settings['external_link'];
        } 
        
        $link_two = '';
        if( $settings['link_type2'] == 1 ){
            $link_two = get_page_link($settings['link_to_page2']); 
        } else {
            $link_two = $settings['external_link2'];
        } ?>

        <!-- Start Main Banner Area -->

        <div class="main-banner">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-7 col-md-12">
                        <div class="main-banner-content <?php echo esc_attr( $alignment); ?>">
                            <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $title ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                            <?php echo wp_kses_post( $desc ); ?>

                            <?php if( $btn1_text != '' || $btn2_text != '') : ?>
                                <div class="btn-box">
                                    <?php if( $btn1_text != '' ): ?>
                                        <?php if ( 'yes' === $settings['target_page'] ) { ?>
                                            <a target="_blank" href="<?php echo esc_url($link_one); ?>" class="btn btn-primary"><?php echo esc_html( $btn1_text ); ?></a><?php
									    } else { ?>
                                            <a href="<?php echo esc_url($link_one); ?>" class="btn btn-primary"><?php echo esc_html( $btn1_text ); ?></a><?php
								        } ?>
                                    <?php endif; ?>
                                    
                                    <?php if( $btn2_text != '' ): ?>
                                        <?php if ( 'yes' === $settings['target_page2'] ) { ?>
                                            <a target="_blank" href="<?php echo esc_url($link_two); ?>" class="btn btn-light"><?php echo esc_html( $btn2_text ); ?></a><?php
									    } else { ?>
                                            <a href="<?php echo esc_url($link_two); ?>" class="btn btn-light"><?php echo esc_html( $btn2_text ); ?></a><?php
                                        } ?>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>

                    <div class="col-lg-5 col-md-12">
                        <div class="main-banner-image">
                            <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $settings['banner_bg_image']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">
                        </div>
                    </div>
                </div>
            </div>

            <?php if ( 'yes' === $settings['section_shape'] ) : ?>
                <div class="banner-shape">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/banner-shape.png' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                </div>
                <div class="banner-white-shape">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/white-shape.png' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                </div>
                <div class="shape3">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/shape/1.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                </div>
                <div class="shape2">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/shape/1.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki-toolkit' ); ?>">
                </div>
            <?php endif; ?>

            <?php if ( 'yes' === $settings['lines_show'] ) : ?>
                <div class="lines">
                    <div class="line"></div>
                    <div class="line"></div>
                    <div class="line"></div>
                </div>
            <?php endif; ?>
        </div>
        <!-- End Main Banner Area -->
        <?php
    }

       
}
Plugin::instance()->widgets_manager->register_widget_type( new BannerWidget );