<?php
namespace Elementor;
class VelikiBannerThree extends Widget_Base{
    public function get_name(){
        return "VelikiBannerThree";
    }
    public function get_title(){
        return "User Analysis Banner";
    }
    public function get_icon(){
        return "eicon-banner";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'banner_bg',
            [
                'label' => esc_html__( 'Background Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'top_title',
            [
                'label' => esc_html__('Top Title', 'veliki-toolkit'),
                'type'  => Controls_Manager:: TEXT,
            ]
        );
        $this->add_control(
            'banner_title',
            [
                'label' => esc_html__('Title', 'veliki-toolkit'),
                'type'  => Controls_Manager:: TEXTAREA,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h1',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'banner_desc',
            [
                'label'=>esc_html__('Description', 'veliki-toolkit'),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
            ]
        );
        // Button One
        $this->add_control(
            'button_one_text',
            [
                'label'=>esc_html__('Button One Text', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $this->add_control(
            'link_type',
            [
                'label' => esc_html__( 'Link Type', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    '1'  => esc_html__( 'Link To Page', 'veliki-toolkit' ),
                    '2' => esc_html__( 'External Link', 'veliki-toolkit' ),
                ], 
            ]
        );

        $this->add_control(
            'link_to_page',
            [
                'label' => esc_html__( 'Link Page', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => veliki_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type' => '1',
                ]
            ]
        );

        $this->add_control(
            'external_link',
            [
                'label'=>esc_html__('External Link', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
                'condition' => [
                    'link_type' => '2',
                ]
            ]
        );

        //Target Page
        $this->add_control(
            'target_page',
            [
                'label' => __( 'Link Open In New Tab?', 'plaby-toolkit' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'plaby-toolkit' ),
                'label_off' => __( 'No', 'plaby-toolkit' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'banner_image',
            [
                'label' => esc_html__( 'Banner Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape1',
            [
                'label' => esc_html__( 'Banner Shape ', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'shape2',
            [
                'label' => esc_html__( 'Shape', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this-> end_controls_section();

        // End Tab content controls

        // Start Style content controls
        $this-> start_controls_section(
            'content_style',
            [
                'label'=>esc_html__('Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'toptitle_color',
            [
                'label' => esc_html__( 'Top Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .user-analysis-banner-content .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'toptitle_bgcolor',
            [
                'label' => esc_html__( 'Top Title Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .user-analysis-banner-content .sub-title' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
			'toptitle_font_size',
			[
				'label' => esc_html__( 'Top Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 80,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .user-analysis-banner-content .sub-title' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .user-analysis-banner-content .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 80,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}}  .user-analysis-banner-content .title' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Description Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .user-analysis-banner-content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
			'desc_size',
			[
				'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .user-analysis-banner-content p' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_responsive_control(
			'btn_font_size',
			[
				'label' => esc_html__( 'Button Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .btn-primary' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__( 'Button One Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-primary' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'btn_bgcolor',
            [
                'label' => esc_html__( 'Button Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .btn-primary::before' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hcolor',
            [
                'label' => esc_html__( 'Button Hover Background Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .btn-primary::after' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this-> end_controls_section();
        // End Style content controls
    }

    protected function render()
    {
        // Retrieve all controls value
        $settings = $this->get_settings_for_display();
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        $title = $settings['banner_title'];
        $desc  = $settings['banner_desc'];
        $btn1_text  = $settings['button_one_text'];

        //  Button Link
        $link_one = '';
        if( $settings['link_type'] == 1 ){
            $link_one = get_page_link($settings['link_to_page']); 
        } else {
            $link_one = $settings['external_link'];
        } ?>

        <div class="user-analysis-banner" style="background-image:url(<?php echo esc_url( $settings['banner_bg']['url'] ); ?>);">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="user-analysis-banner-content">
                            <?php if( $settings['top_title'] != '' ) : ?>
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                            <?php endif; ?>

                            <<?php echo esc_attr( $settings['title_tag'] ); ?> class="title"><?php echo esc_html( $title ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                            <p><?php echo wp_kses_post( $desc ); ?></p>

                            <?php if( $btn1_text != '' ): ?>
                                <div class="banner-btn">
                                    <?php if ( 'yes' === $settings['target_page'] ) { ?>
                                        <a target="_blank" href="<?php echo esc_url($link_one); ?>" class="btn btn-primary"><?php echo esc_html( $btn1_text ); ?></a><?php
                                    } else { ?>
                                        <a href="<?php echo esc_url($link_one); ?>" class="btn btn-primary"><?php echo esc_html( $btn1_text ); ?></a><?php
                                    } ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php if( $settings['banner_image']['url']  !='') : ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="user-analysis-banner-image">
                                <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $settings['banner_image']['url'] ); ?>" alt="<?php echo esc_attr__('image','veliki-toolkit'); ?>">
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <?php if( $settings['shape1']['url']  !='') : ?>
                <div class="user-analysis-shape-1">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__('image','veliki-toolkit'); ?>">
                </div>
            <?php endif; ?>
            <?php if( $settings['shape2']['url']  !='') : ?>
                <div class="user-analysis-shape-2">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__('image','veliki-toolkit'); ?>">
                </div>
            <?php endif; ?>
        </div>
        <?php
    }  
}
Plugin::instance()->widgets_manager->register_widget_type( new VelikiBannerThree );