<?php
/**
 * Banner Widget
 */

namespace Elementor;
class Veliki_Banner_Four extends Widget_Base {

	public function get_name() {
        return 'Veliki_BannerFour';
    }

	public function get_title() {
        return __( 'Banner Four', 'veliki-toolkit' );
    }

	public function get_icon() {
        return 'eicon-banner';
    }

	public function get_categories() {
        return ['velikicategory'];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Veliki_Banner_Area',
			[
				'label' => __( 'Veliki Banner Area', 'veliki-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'banner_bg',
            [
                'label' => esc_html__( 'Background Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'banner_image',
            [
                'label' => esc_html__( 'Banner Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'top_title',
            [
                'label' => esc_html__('Top Title', 'veliki-toolkit'),
                'type'  => Controls_Manager:: TEXT,
            ]
        );
        $this->add_control(
            'banner_title',
            [
                'label' => esc_html__('Title', 'veliki-toolkit'),
                'type'  => Controls_Manager:: TEXTAREA,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Heading Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h1',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'banner_desc',
            [
                'label'=>esc_html__('Description', 'veliki-toolkit'),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
            ]
        );
      

        $this->add_control(
            'placeholder_text', [
                'label' => __( 'Placeholder Text', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_text', [
                'label' => __( 'Button text', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Get Strated', 'veliki-toolkit'),
            ]
        );

        $this->add_control(
            'action_url', [
                'label' => esc_html__( 'Action URL', 'veliki-toolkit' ),
                'description' => __( 'Enter here your MailChimp action URL. <a href="https://docs.envytheme.com/docs/veliki-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a>', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'https://envytheme.us20.list-manage.com/subscribe/post?u=60e1ffe2e8a68ce1204cd39a5&amp;id=42d6d188d9
                ',
            ]
        );
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'veliki-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

            $this->add_control(
                'toptitle_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'veliki-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .data-science-banner-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'toptitle_bgcolor',
                [
                    'label' => esc_html__( 'Top Title Background Color', 'veliki-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .data-science-banner-content .sub-title' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_toptitle',
                    'label'    => __( 'Top Title Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .data-science-banner-content .sub-title',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .data-science-banner-content .title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'title_font_size',
                    'label'    => __( ' Title Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .data-science-banner-content .title',
                ]
            );
            $this->add_control(
                'desc_color',
                [
                    'label' => esc_html__( 'Description Color', 'veliki-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .data-science-banner-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'desc_size',
                    'label'    => __( ' Description Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .data-science-banner-content p',
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label'     => __( 'Button Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .data-science-banner-content .banner-form button' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_bgcolor',
                [
                    'label'     => __( 'Button Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .data-science-banner-content .banner-form button' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_btn',
                    'label'    => __( 'Button Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .data-science-banner-content .banner-form button',
                ]
            );
            $this->add_control(
                'btn_hcolor',
                [
                    'label'     => __( 'Button Hover Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .data-science-banner-content .banner-form button:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_hbgcolor',
                [
                    'label'     => __( 'Button Hover Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .data-science-banner-content .banner-form button:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

		$settings = $this->get_settings_for_display();
        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        $title = $settings['banner_title'];
        $desc  = $settings['banner_desc'];
        
        ?> 

        <div class="data-science-banner" style="background-image:url(<?php echo esc_url( $settings['banner_bg']['url'] ); ?>);">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="data-science-banner-content">
                            <?php if( $settings['top_title'] != '' ) : ?>
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                            <?php endif; ?>

                            <<?php echo esc_attr( $settings['title_tag'] ); ?> class="title"><?php echo esc_html( $title ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                            <p><?php echo wp_kses_post( $desc ); ?></p>

                            <form class="mailchimp banner-form" method="post"> 
                                <div class="form-group">
                                    <input type="email" class="input-newsletter" placeholder="<?php echo esc_html( $settings['placeholder_text'] ); ?>" name="EMAIL" required autocomplete="off">
                                    <button type="submit"><?php echo esc_html( $settings['button_text'] ); ?></button>
                                </div>

                                <p class="mchimp-errmessage" style="display: none;"></p>
                                <p class="mchimp-sucmessage" style="display: none;"></p>
                            </form>
                        </div>
                    </div>

                    <?php if( $settings['banner_image']['url']  !='') : ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="data-science-banner-image">
                                <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $settings['banner_image']['url'] ); ?>" alt="<?php echo esc_attr__('image','veliki-toolkit'); ?>">
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <script>
            ;(function($){
                "use strict";
                $(document).ready(function () {
                    // MAILCHIMP
                    if ($(".mailchimp").length > 0) {
                        $(".mailchimp").ajaxChimp({
                            callback: mailchimpCallback,
                            url: "<?php echo esc_js($settings['action_url']) ?>" //Replace this with your own mailchimp post URL. Don't remove the "". Just paste the url inside "".
                        });
                    }
                    $(".memail").on("focus", function () {
                        $(".mchimp-errmessage").fadeOut();
                        $(".mchimp-sucmessage").fadeOut();
                    });
                    $(".memail").on("keydown", function () {
                        $(".mchimp-errmessage").fadeOut();
                        $(".mchimp-sucmessage").fadeOut();
                    });
                    $(".memail").on("click", function () {
                        $(".memail").val("");
                    });

                    function mailchimpCallback(resp) {
                        if (resp.result === "success") {
                            $(".mchimp-sucmessage").html(resp.msg).fadeIn(1000);
                            $(".mchimp-sucmessage").fadeOut(500);
                        } else if (resp.result === "error") {
                            $(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
                        }
                    }
                });
            })(jQuery)
        </script>

        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Veliki_Banner_Four );