<?php
namespace Elementor;
class Veliki_Awesome_Solutions extends Widget_Base{
    public function get_name(){
        return "VelikiAwesomeSolutions";
    }
    public function get_title(){
        return "Awesome Solutions";
    }
    public function get_icon(){
        return "eicon-info-box";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'section_content',
            [
                'label' => __('Content', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            // $this->add_control(
            //     'choose_style',
            //     [
            //         'label' => __( 'Choose Style', 'veliki-toolkit' ),
            //         'type'  => Controls_Manager::SELECT,
            //         'options' => [
            //             '1'   => __( 'Style one', 'veliki-toolkit' ),
            //             '2'   => __( 'Style two', 'veliki-toolkit' ),
            //         ],
            //         'default' => '1',
            //     ]
            // );
            
            $this->add_control(
                'top_title', [
                    'label'       => __( 'Top Title', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'title', [
                    'label'       => __( 'Title', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'heading_tag', [
                    'label'   => __( 'Title Heading Tag', 'veliki-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                    'default'     => 'h2',
                    'label_block' => true,
                ]
            );
                $card_items = new Repeater();
                $card_items->add_control(
                    'list_check_icon',
                    [
                        'label'   => __( 'Icon', 'veliki-toolkit' ),
                        'type' 	  => Controls_Manager::TEXT,
                        'default' => 'fa fa-photo-film',
                    ]
                );
                $card_items->add_control(
                    'list_title',
                    [
                        'label' => __('Title', 'veliki-toolkit'),
                        'type'  => Controls_Manager:: TEXT,
                        'label_block' => true,
                    ]
                );
                $this->add_control(
                    'lists_content',
                    [
                        'label'       => __( 'Add List', 'veliki-toolkit' ),
                        'type'        => Controls_Manager::REPEATER,
                        'fields'      => $card_items->get_controls(),
                    ]
                );

            $this->add_control(
                'shape1',
                [
                    'label'     => __('Upload Shape1', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'shape2',
                [
                    'label'     => __('Upload Shape2', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::MEDIA,
                ]
            );
        $this-> end_controls_section();

        // End Tab content controls

        // Start style1 content controls
        $this-> start_controls_section(
            'content_style',
            [
                'label'     => __('Style', 'veliki-toolkit'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'secbg_color',
                [
                    'label'     => __( 'Section Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .awesome-solutions-area' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'toptitle_color',
                [
                    'label'     => __( 'Top Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_toptitle',
                    'label'    => __( 'Top Title Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .section-title .sub-title',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .awesome-solutions-area .section-title .title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_title',
                    'label'    => __( 'Title Typography', 'veliki-toolkit' ),
                     
                    'selector' => ' {{WRAPPER}} .awesome-solutions-area .section-title .title',
                ]
            );

            $this->add_control(
                'card_bg_color',
                [
                    'label'     => __( 'Card Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .awesome-solutions-card' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
           
            // List
            $this->add_control(
                'icon_color',
                [
                    'label'     => __( 'Icon Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .awesome-solutions-card .icon' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_bgcolor',
                [
                    'label'     => __( 'Icon Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .awesome-solutions-card .icon' => 'background: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'list_color',
                [
                    'label'     => __( 'List Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .awesome-solutions-card h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_list',
                    'label'    => __( 'List Typography', 'veliki-toolkit' ),
                     
                    'selector' => ' {{WRAPPER}} .awesome-solutions-card h3',
                ]
            );
        $this-> end_controls_section();
    }

    protected function render()
    {
        // Retrieve all controls value
        $settings = $this->get_settings_for_display();

        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        $lists    = $settings['lists_content']; ?>

        <div class="awesome-solutions-area pt-100 pb-70">
            <div class="container">
                <div class="row align-items-center">

                    <?php if( $settings['top_title'] != '' || $settings['title'] != '') : ?>
                        <div class="col-lg-6 col-md-12 col-sm-12">
                            <div class="section-title">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>

                                <<?php echo esc_attr( $settings['heading_tag'] ); ?> class="title"><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['heading_tag'] ); ?>>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php $i = 1; foreach ( $lists as $item ) : ?>
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            <div class="awesome-solutions-card">
                                <?php if( $item['list_check_icon'] != '' ) : ?>
                                <div class="icon">
                                    <i class="<?php echo esc_attr( $item['list_check_icon'] ); ?>"></i>

                                    <div class="circles-box">
                                        <div class="circle-one"></div>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <h3><?php echo esc_html( $item['list_title'] ); ?></h3>
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
            <?php if( !empty( $settings['shape1']['url'] ) ){ ?>
                <div class="awesome-solutions-bg-shape">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__( 'Image', 'veliki-toolkit' ); ?>">
                </div>
            <?php } ?>
            <?php if( !empty( $settings['shape2']['url'] ) ){ ?>
                <div class="awesome-solutions-line-shape">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__( 'Image', 'veliki-toolkit' ); ?>">
                </div>
            <?php } ?>
        </div>
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new Veliki_Awesome_Solutions );