<?php
namespace Elementor;
class AboutWidget extends Widget_Base{
    public function get_name(){
        return "about-us-widget";
    }
    public function get_title(){
        return "About Us";
    }
    public function get_icon(){
        return "eicon-info-box";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'section_content',
            [
                'label'=>esc_html__('Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'right_image',
            [
                'label' => esc_html__('Image', 'veliki-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );

        $this->add_control(
			'about_text_alignment',
			[
				'label' => __( 'Choose Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '3'
			]
		);

        $this->add_control(
            'about_top_title',
            [
                'label'=>esc_html__('Top Title', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $this->add_control(
            'about_title',
            [
                'label'=>esc_html__('Title', 'veliki-toolkit'),
                'type'=>Controls_Manager:: TEXT,
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h2',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'about_desc',
            [
                'label'=>esc_html__('Description', 'veliki-toolkit'),
                'type'=>Controls_Manager:: WYSIWYG,
                'description' => esc_html__('This text editor for p, ul - ol list tag','veliki-toolkit'),
            ]
        );

        $this->add_control(
            'about_card_content',
            [
                'label' => esc_html__( 'About Card', 'veliki-toolkit' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'veliki-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'veliki-toolkit' ),
                    3   => __( '3', 'veliki-toolkit' ),
                    4   => __( '4', 'veliki-toolkit' ),
                ],
                'default' => 3,
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
			'card_text_alignment',
			[
				'label' => __( 'Choose Card Title Alignment', 'veliki-toolkit' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1'     => __( 'Text Align Center', 'veliki-toolkit' ),
					'2'     => __( 'Text Align Right', 'veliki-toolkit' ),
					'3'     => __( 'Text Align Left', 'veliki-toolkit' ),
				],
				'default' => '3'
			]
		);
        $repeater->add_control(
            'card_title', [
                'label' => esc_html__( 'Card Title', 'veliki-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'card_title_tag',
            [
                'label' => __('Card Title Tag', 'veliki-toolkit'),
                'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                'default'     => 'h3',
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'card_details', [
                'label' => esc_html__( 'Card Details', 'veliki-toolkit' ),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
            ]
        );
    
        $this->add_control(
            'card_content',
            [
                'label' => esc_html__( 'Add Card Content', 'veliki-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this-> end_controls_section();

        // End Tab content controls

        // Start Style content controls
        $this-> start_controls_section(
            'content_style',
            [
                'label'=>esc_html__('Content', 'veliki-toolkit'),
                'tab'=> Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'top_title_style',
			[
				'label' => esc_html__( 'Top Title', 'veliki-toolkit' ),
				'type' => Controls_Manager::HEADING,
			]
        );

        $this->add_responsive_control(
			'top_title_font_size',
			[
				'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .about-content span' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_control(
			'title_style',
			[
				'label' => esc_html__( 'Title', 'veliki-toolkit' ),
				'type' => Controls_Manager::HEADING,
			]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-content h2, .about-content h1, .about-content h3, .about-content h4, .about-content h5, .about-content h6' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
			'title_font_size',
			[
				'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 60,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .about-content h2, .about-content h1, .about-content h3, .about-content h4, .about-content h5, .about-content h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_control(
			'description_style',
			[
				'label' => esc_html__( 'Description', 'veliki-toolkit' ),
				'type' => Controls_Manager::HEADING,
			]
        );

        $this->add_responsive_control(
			'desc_font_size',
			[
				'label' => esc_html__( 'Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .about-content p, .about-content ul li, .about-content ol li' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_control(
			'card_style',
			[
				'label' => esc_html__( 'About Card Style', 'veliki-toolkit' ),
                'type' => Controls_Manager::HEADING,
			]
        );
        $this->add_control(
            'card_title_color',
            [
                'label' => esc_html__( 'Title Color', 'veliki-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-text h3, .about-text h1, .about-text h2, .about-text h4, .about-text h5, .about-text h6' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
			'card_titlefont_size',
			[
				'label' => esc_html__( 'Title Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .about-text h3, .about-text h1, .about-text h2, .about-text h4, .about-text h5, .about-text h6' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this->add_responsive_control(
			'card_descfont_size',
			[
				'label' => esc_html__( 'Description Font Size', 'veliki-toolkit' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
					],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'unit' => 'px',
				'selectors' => [
					'{{WRAPPER}} .about-text p, .about-text ul li, .about-text ol li' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
			]
        );

        $this-> end_controls_section();
    }

    protected function render()
    {
        // Retrieve all controls value
        $settings = $this->get_settings_for_display();

        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        // Text Alignment
		if( $settings['about_text_alignment' ] == '1') {
			$alignment = 'text-center';
		} 
		elseif( $settings['about_text_alignment' ] == '2') {
			$alignment = 'text-right';
		} else {
			$alignment = 'text-left';
		}

        // Tag allowed for about content
        $about_text_allowed_tags = array(
            'a' =>array(
                'href' => array(),
                'title' => array(),
                'class' => array()
            ),
            'p' => array(),
            'br' => array(),
            'em' => array(),
            'strong' => array()
        );

        $columns = $settings['columns'];
        if ($columns == 2) {
            $column = 'col-lg-6 col-md-6';
        } elseif ($columns == 4) {
            $column = 'col-lg-3 col-md-6 col-sm-6';
        } else {
            $column = 'col-lg-4 col-md-6 col-sm-6';
        } ?>

        <!-- Start About Area -->
        <div class="about-area ptb-110">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="about-image">
                            <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $settings['right_image']['url'] ); ?>" alt="<?php echo esc_attr('image'); ?>">
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12">
                        <div class="about-content <?php echo esc_attr( $alignment); ?>">
                            <span><?php echo esc_html($settings['about_top_title']); ?></span>
                            <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['about_title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                            <?php echo wp_kses_post( $settings['about_desc'] ); ?>
                        </div>
                    </div>
                </div>

                <div class="about-inner-area">
					<div class="row"> <?php
                        if ( $settings['card_content']!='' ):
                            $loop = 1;
                            foreach ( $settings['card_content'] as $item ) :

                                if ( $columns == 3 ) {
                                    if ($loop == 3) {
                                        $column = 'col-lg-4 col-md-6 col-sm-6 offset-lg-0 offset-md-3 offset-sm-3';
                                    } else {
                                        $column = 'col-lg-4 col-md-6 col-sm-6';
                                    }
                                }
                                // Text Alignment
                                if( $item['card_text_alignment' ] == '1') {
                                    $c_alignment = 'text-center';
                                } 
                                elseif( $item['card_text_alignment' ] == '2') {
                                    $c_alignment = 'text-right';
                                } else {
                                    $c_alignment = 'text-left';
                                }

                                if( $item['card_title']!='' || $item['card_details']!='' ) : ?>
                                    <div class="<?php echo esc_attr( $column ); ?> ">
                                        <div class="about-text <?php echo esc_attr( $c_alignment); ?>">
                                            <<?php echo esc_attr( $item['card_title_tag'] ); ?>><?php echo esc_html( $item['card_title'] ); ?></<?php echo esc_attr( $item['card_title_tag'] ); ?>>
                                            <?php echo wp_kses_post( $item['card_details'] ); ?>
                                        </div>
                                    </div><?php
                                endif; 
                            $loop++; 
                            endforeach; 
                        endif; ?>
					</div>
				</div>
            </div>
        </div>
        <!-- End About Area -->
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new AboutWidget );