<?php
namespace Elementor;
class Veliki_AboutTwo extends Widget_Base{
    public function get_name(){
        return "VelikiAboutTwo";
    }
    public function get_title(){
        return "Veliki About Two";
    }
    public function get_icon(){
        return "eicon-info-box";
    }
    public function get_categories(){
        return ['velikicategory'];
    }

    protected function register_controls(){
        // Tab content controls
        $this-> start_controls_section(
            'section_content',
            [
                'label' => __('Content', 'veliki-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            // $this->add_control(
            //     'choose_style',
            //     [
            //         'label' => __( 'Choose Style', 'veliki-toolkit' ),
            //         'type'  => Controls_Manager::SELECT,
            //         'options' => [
            //             '1'   => __( 'Style one', 'veliki-toolkit' ),
            //             '2'   => __( 'Style two', 'veliki-toolkit' ),
            //         ],
            //         'default' => '1',
            //     ]
            // );
            $this->add_control(
                'image',
                [
                    'label'     => __('Upload Image', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'top_title', [
                    'label'       => __( 'Top Title', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'title', [
                    'label'       => __( 'Title', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'heading_tag', [
                    'label'   => __( 'Title Heading Tag', 'veliki-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                    'default'     => 'h3',
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'desc', 
                [
                    'label'       => __( 'Description', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::WYSIWYG,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'desc_note1', [
                    'label' => '',
                    'type'  => Controls_Manager::RAW_HTML,
                    'raw'   => __( 'In description editor use a class in p tag. When editing the editor its remove existing p, span tag', 'veliki-toolkit' ),
                    'content_classes' => 'elementor-warning',
                ]
            );
                $card_items = new Repeater();
                $card_items->add_control(
                    'list_check_icon',
                    [
                        'label'   => __( 'Icon', 'veliki-toolkit' ),
                        'type' 	  => Controls_Manager::TEXT,
                        'default' => 'fa fa-check',
                    ]
                );
                $card_items->add_control(
                    'list_title',
                    [
                        'label' => __('Title', 'veliki-toolkit'),
                        'type'  => Controls_Manager:: TEXT,
                        'label_block' => true,
                    ]
                );
                $this->add_control(
                    'lists_content',
                    [
                        'label'       => __( 'Add List', 'veliki-toolkit' ),
                        'type'        => Controls_Manager::REPEATER,
                        'fields'      => $card_items->get_controls(),
                    ]
                );
            $this->add_control(
                'button_text',
                [
                    'label'   => __( 'Button Text', 'veliki-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('About Us', 'veliki-toolkit'),
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label'       => __( 'Link Type', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => [
                        '1'  => __( 'Link To Page', 'veliki-toolkit' ),
                        '2'  => __( 'External Link', 'veliki-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label'       => __( 'Link Page', 'veliki-toolkit' ),
                    'type'        => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options'     => veliki_toolkit_get_page_as_list(),
                    'condition'   => [
                        'link_type'    => '1',
                    ]
                ]
            );
            $this->add_control(
                'external_link',
                [
                    'label'     => __('External Link', 'veliki-toolkit'),
                    'type'      => Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type'    => '2',
                    ]
                ]
            );
            //Target Page
            $this->add_control(
                'target_page',
                [
                    'label' => __( 'Link Open In New Tab?', 'veliki-toolkit' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Yes', 'veliki-toolkit' ),
                    'label_off' => __( 'No', 'veliki-toolkit' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );
        $this-> end_controls_section();

        // End Tab content controls

        // Start style1 content controls
        $this-> start_controls_section(
            'content_style',
            [
                'label'     => __('Style', 'veliki-toolkit'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'toptitle_color',
                [
                    'label'     => __( 'Top Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrap-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_toptitle',
                    'label'    => __( 'Top Title Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .about-wrap-content span',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrap-content .title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_title',
                    'label'    => __( 'Title Typography', 'veliki-toolkit' ),
                     
                    'selector' => ' {{WRAPPER}} .about-wrap-content .title',
                ]
            );
            $this->add_control(
                'desc_color',
                [
                    'label'     => __( 'Description Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrap-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_desc',
                    'label'    => __( 'Description Typography', 'veliki-toolkit' ),
                     
                    'selector' => ' {{WRAPPER}} .about-wrap-content p',
                ]
            );
            // List
            $this->add_control(
                'icon_color',
                [
                    'label'     => __( 'Icon Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrap-content .wrap-list li i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'list_color',
                [
                    'label'     => __( 'List Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrap-content .wrap-list li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_list',
                    'label'    => __( 'List Typography', 'veliki-toolkit' ),
                     
                    'selector' => ' {{WRAPPER}} .about-wrap-content .wrap-list li',
                ]
            );
            $this->add_control(
                'card_bg_color',
                [
                    'label'     => __( 'Card Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrap-content .wrap-list li' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card_bg_hcolor',
                [
                    'label'     => __( 'Card Hover Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrap-content .wrap-list li:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card_hcolor',
                [
                    'label'     => __( 'Card Hover Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrap-content .wrap-list li:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'icon_hcolor',
                [
                    'label'     => __( 'Icon Hover Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrap-content .wrap-list li:hover i' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'btn_color',
                [
                    'label'     => __( 'Button Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .btn-primary' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_bgcolor',
                [
                    'label'     => __( 'Button Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .btn-primary::before' => 'background: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(), [
                    'name'     => 'typography_btn',
                    'label'    => __( 'Button Typography', 'veliki-toolkit' ),
                    'selector' => ' {{WRAPPER}} .btn-primary',
                ]
            );
            $this->add_control(
                'btn_hbgcolor',
                [
                    'label'     => __( 'Button Hover Background Color', 'veliki-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .btn-primary::after' => 'background: {{VALUE}}',
                    ],
                ]
            );
        $this-> end_controls_section();
    }

    protected function render()
    {
        // Retrieve all controls value
        $settings = $this->get_settings_for_display();

        global $veliki_opt;
        if( isset( $veliki_opt['enable_lazyloader'] ) ):
            $is_lazyloader = $veliki_opt['enable_lazyloader'];
        else:
            $is_lazyloader = true;
        endif;

        if( $is_lazyloader == true ):
            $lazy_class = 'smartify';
            $lazy_attr = 'sm-';
        else:
            $lazy_class = '';
            $lazy_attr = '';
        endif;

        $lists    = $settings['lists_content']; 
        // Button link
        $link_source = '';
        if ( $settings['link_type'] == 1 ) :
            $link_source = get_page_link( $settings['link_to_page']); 
        else :
            $link_source = $settings['external_link'];
        endif; ?>


        <div class="about-wrap-area pb-100">
            <div class="container">
                <div class="row align-items-center">
                    <?php if( !empty( $settings['image']['url'] ) ){ ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="about-wrap-image">
                                <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__( 'Image', 'veliki-toolkit' ); ?>">
                            </div>
                        </div>
                    <?php } ?>

                    <div class="col-lg-6 col-md-12">
                        <div class="about-wrap-content">
                            <span><?php echo esc_html( $settings['top_title'] ); ?></span>
                            <<?php echo esc_attr( $settings['heading_tag'] ); ?> class="title"><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['heading_tag'] ); ?>>
                            <p><?php echo wp_kses_post( $settings['desc'] ); ?></p>

                            <div class="row justify-content-center">
                                <div class="col-lg-6 col-md-6">
                                    <ul class="wrap-list">
                                        <?php $i = 1; foreach ( $lists as $item ) : 
                                            if($i % 2 != 0 ){ ?>
                                                <li>
                                                    <i class="<?php echo esc_attr( $item['list_check_icon'] ); ?>"></i>
                                                    <?php echo esc_html( $item['list_title'] ); ?>
                                                </li>
                                            <?php }       
                                        $i++; endforeach; ?>
                                    </ul>
                                </div>

                                <div class="col-lg-6 col-md-6">
                                    <ul class="wrap-list">
                                        <?php $i = 1; foreach ( $lists as $item ) : 
                                            if($i % 2 == 0 ){ ?>
                                                <li>
                                                    <i class="<?php echo esc_attr( $item['list_check_icon'] ); ?>"></i>
                                                    <?php echo esc_html( $item['list_title'] ); ?>
                                                </li>
                                            <?php }       
                                        $i++; endforeach; ?>
                                    </ul>
                                </div>
                            </div>

                            <?php if ( $settings['button_text'] != '' ) : ?>
                                <div class="about-btn">
                                    <?php if ( 'yes' === $settings['target_page'] ) { ?>
                                        <a target="_blank" href="<?php echo esc_url( $link_source ); ?>" class="btn btn-primary">
                                            <?php echo esc_html( $settings['button_text'] ); ?>
                                        </a><?php
                                    } else { ?>
                                        <a href="<?php echo esc_url( $link_source ); ?>" class="btn btn-primary">
                                            <?php echo esc_html( $settings['button_text'] ); ?>
                                        </a><?php
                                    } ?>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new Veliki_AboutTwo );