<?php
/* 
 * Plugin Name: Veliki Toolkit
 * Author: EnvyTheme
 * Author URI: envytheme.com
 * Description: A Light weight and easy toolkit for Elementor page builder widgets.
 * Version: 2.7
 */

if (!defined('ABSPATH')) {
    exit; //Exit if accessed directly
}

define('VELIKI_ACC_PATH', plugin_dir_path(__FILE__));

if( !defined('VELIKI_FRAMEWORK_VAR') ) define('VELIKI_FRAMEWORK_VAR', 'veliki_opt');

$theme = wp_get_theme(); // gets the current theme
if ( 'Veliki' == $theme->name || 'Veliki' == $theme->parent_theme ) {
	/**	
	 * Classes
	 */
	require_once(VELIKI_ACC_PATH . 'inc/classes/Veliki_base.php');
	require_once(VELIKI_ACC_PATH . 'inc/classes/Veliki_rt.php');
	require_once(VELIKI_ACC_PATH . 'inc/classes/Veliki_admin_page.php');
	require_once(VELIKI_ACC_PATH . 'inc/admin/dashboard/Veliki_admin_dashboard.php');
	require_once(VELIKI_ACC_PATH . 'inc/functions.php');

	/**
     * Redirect after theme activation
     */
    add_action( 'after_switch_theme', function() {
        if ( isset( $_GET['activated'] ) ) {
            wp_safe_redirect( admin_url('admin.php?page=veliki') );
            update_option( 'veliki_purchase_code_status', '', 'yes' );
            update_option( 'veliki_purchase_code', '', 'yes' );
            exit;
        }
        update_option('notice_dismissed', '0');
    });
}

// Select page for link
function veliki_toolkit_get_page_as_list() {
    $args = wp_parse_args(array(
        'post_type' => 'page',
        'numberposts' => -1,
    ));

    $posts = get_posts($args);
    $post_options = array(esc_html__('--Select Page--', 'veliki-toolkit') => '');

    if ($posts) {
        foreach ($posts as $post) {
            $post_options[$post->post_title] = $post->ID;
        }
    }
    $flipped = array_flip($post_options);
    return $flipped;
}
function veliki_toolkit_get_page_services_cat_el()
{
    $arg = array(
        'taxonomy' => 'service_cat',
        'orderby' => 'name',
        'order'   => 'ASC'
    );
    $args = get_categories($arg);
    $args_options = array(esc_html__('', 'veliki-toolkit') => '');
    if ($args) {
        foreach ($args as $args) {
            $args_options[$args->name] = $args->slug;
        }
    }
    return $args_options;
}
function veliki_toolkit_get_page_resource_cat_el()
{
    $arg = array(
        'taxonomy' => 'resource_cat',
        'orderby' => 'name',
        'order'   => 'ASC'
    );
    $args = get_categories($arg);
    $args_options = array(esc_html__('', 'veliki-toolkit') => '');
    if ($args) {
        foreach ($args as $args) {
            $args_options[$args->name] = $args->slug;
        }
    }
    return $args_options;
}

//Custom Post
function veliki_toolkit_custom_post()
{
	global $veliki_opt;
	if( isset( $veliki_opt['ser_post_text'] ) ) {
		$ser_post_type = $veliki_opt['ser_post_text'];
		$res_post_type = $veliki_opt['res_post_text'];
	} else {
		$ser_post_type = 'service';
		$res_post_type = 'resource';
	}
	// Services Custom Post
 	register_post_type('service',
        array(
            'labels' => array(
                'name' => esc_html__('Services', 'veliki-toolkit'),
                'singular_name' => esc_html__('Service', 'veliki-toolkit'),
            ),
            'menu_icon' => 'dashicons-images-alt',
            'supports' => array('title', 'thumbnail', 'editor', 'page-attributes','excerpt'),
            'has_archive' => true,
			'public'   => true,
			'rewrite' => array( 'slug' => $ser_post_type ),
        )
	);
    
	// Resource Custom Post
	register_post_type('resource',
		array(
			'labels' => array(
				'name' => esc_html__('Resources', 'veliki-toolkit'),
				'singular_name' => esc_html__('Resource', 'veliki-toolkit'),
			),
			'menu_icon' => 'dashicons-pressthis',
			'supports' => array('title', 'thumbnail', 'editor', 'page-attributes','excerpt'),
			'has_archive' => true,
			'public'   => true,
			'rewrite' => array( 'slug' => $res_post_type ),
		)
	);
}

add_action('init', 'veliki_toolkit_custom_post');

//Taxonomy Custom Post
function veliki_custom_post_taxonomy(){
    register_taxonomy(
        'service_cat',
        'service',
            array(
            'hierarchical'      => true,
            'label'             => esc_html__('Service Category', 'veliki-toolkit' ),
            'query_var'         => true,
            'show_admin_column' => true,
                'rewrite'       => array(
                'slug'          => 'service-category',
                'with_front'    => true
            )
        )
    );
    register_taxonomy(
        'resource_cat',
        'resource',
            array(
            'hierarchical'      => true,
            'label'             => esc_html__('Resources Category', 'veliki-toolkit' ),
            'query_var'         => true,
            'show_admin_column' => true,
                'rewrite'       => array(
                'slug'          => 'resource-category',
                'with_front'    => true
            )
        )
    );
}
add_action('init', 'veliki_custom_post_taxonomy');

/**
 * Post category list
*/
function veliki_toolkit_get_post_cat_list() {
	$post_category_id = get_queried_object_id();
	$args = array(
		'parent' => $post_category_id
	);

	$terms = get_terms( 'category', get_the_ID());
	$cat_options = array(esc_html__('', 'veliki-toolkit') => '');

	if ($terms) {
		foreach ($terms as $term) {
			$cat_options[$term->name] = $term->name;
		}
	}
	return $cat_options;
}

// Add this to your theme's functions.php
function veliki_add_script_to_footer(){
    if( ! is_admin() ) { 
		global $veliki_opt;
		$action_url  = isset( $veliki_opt['action_url']) ? $veliki_opt['action_url'] : '';
		?>

		<script>
			<?php if( !empty($action_url) ) : ?>
				;(function($){
					"use strict";
					$(document).ready(function () {
						// MAILCHIMP
						if ($(".mailchimp").length > 0) {
							$(".mailchimp").ajaxChimp({
								callback: mailchimpCallback,
								url: "<?php echo esc_js($action_url) ?>"
							});
						}
						$(".memail").on("focus", function () {
							$(".mchimp-errmessage").fadeOut();
							$(".mchimp-sucmessage").fadeOut();
						});
						$(".memail").on("keydown", function () {
							$(".mchimp-errmessage").fadeOut();
							$(".mchimp-sucmessage").fadeOut();
						});
						$(".memail").on("click", function () {
							$(".memail").val("");
						});

						function mailchimpCallback(resp) {
							if (resp.result === "success") {
								$(".mchimp-sucmessage").html(resp.msg).fadeIn(1000);
								$(".mchimp-sucmessage").fadeOut(500);
							} else if (resp.result === "error") {
								$(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
							}
						}
					});
				})(jQuery)
			<?php endif; ?>
		</script>

	<?php 
	}
}
add_action( 'wp_footer', 'veliki_add_script_to_footer' );

// Main veliki Toolkit Class
final class Elementor_Test_Extension {

	const VERSION = '1.0.0';
	const MINIMUM_ELEMENTOR_VERSION = '2.0.0';
	const MINIMUM_PHP_VERSION = '7.0';

	// Instance
    private static $_instance = null;
    
	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;

	}

	// Constructor
	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'init' ] );

	}

	// init
	public function init() {
        load_plugin_textdomain( 'veliki-toolkit' );

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
			return;
		}

		// Add Plugin actions
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );
        
        add_action('elementor/elements/categories_registered',[ $this, 'register_new_category'] );
        
    }

    public function register_new_category($manager){
        $manager->add_category('velikicategory',[
            'title'=>esc_html__('Veliki Category','veliki-toolkit'),
            'icon'=> 'fa fa-image'
        ]);
    }

	//Admin notice
	public function admin_notice_missing_main_plugin() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'veliki-toolkit' ),
			'<strong>' . esc_html__( 'Veliki Toolkit', 'veliki-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'veliki-toolkit' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'veliki-toolkit' ),
			'<strong>' . esc_html__( 'Veliki Toolkit', 'veliki-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'veliki-toolkit' ) . '</strong>',
			 self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'veliki-toolkit' ),
			'<strong>' . esc_html__( 'Veliki Toolkit', 'veliki-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'veliki-toolkit' ) . '</strong>',
			 self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	// Toolkit Widgets
	public function init_widgets() {
		// Include Widget files
		$pcs = trim( get_option( 'veliki_purchase_code_status' ) );
		if ( $pcs == 'valid' ) {
			require_once( __DIR__ . '/widgets/banner-widget.php' );
			require_once( __DIR__ . '/widgets/services-widget.php' );
			require_once( __DIR__ . '/widgets/feature-widget.php' );
			require_once( __DIR__ . '/widgets/how-it-works-widget.php' );
			require_once( __DIR__ . '/widgets/choose-us-widget.php' );
			require_once( __DIR__ . '/widgets/resources-widget.php' );
			require_once( __DIR__ . '/widgets/partner-widget.php' );
			require_once( __DIR__ . '/widgets/feedback-widget.php' );
			require_once( __DIR__ . '/widgets/post-widget.php' );
			require_once( __DIR__ . '/widgets/about-widget.php' );
			require_once( __DIR__ . '/widgets/team-widget.php' );
			require_once( __DIR__ . '/widgets/contact-widget.php' );
			require_once( __DIR__ . '/widgets/top-faq-widget.php' );
			require_once( __DIR__ . '/widgets/faq-contact-widget.php' );
			require_once( __DIR__ . '/widgets/coming-soon-widget.php' );
			require_once( __DIR__ . '/widgets/single-service-widget.php' );
			require_once( __DIR__ . '/widgets/single-resource-widget.php' );


            // V2.7
            require_once( __DIR__ . '/widgets/banner-two.php' );
            require_once( __DIR__ . '/widgets/services-two.php' );
            require_once( __DIR__ . '/widgets/about-two.php' );
            require_once( __DIR__ . '/widgets/services-three.php' );
            require_once( __DIR__ . '/widgets/value-benefits-tabs.php' );
            require_once( __DIR__ . '/widgets/overview-wrap.php' );
            require_once( __DIR__ . '/widgets/awesome-solutions.php' );
            require_once( __DIR__ . '/widgets/work-process.php' );
            require_once( __DIR__ . '/widgets/feedback-two.php' );
            require_once( __DIR__ . '/widgets/post-two.php' );
            require_once( __DIR__ . '/widgets/partner-two.php' );
            require_once( __DIR__ . '/widgets/banner-three.php' );
            require_once( __DIR__ . '/widgets/feature-wrap.php' );
            require_once( __DIR__ . '/widgets/services-four.php' );
            require_once( __DIR__ . '/widgets/value-benefits.php' );
            require_once( __DIR__ . '/widgets/banner-four.php' );
            require_once( __DIR__ . '/widgets/award-area.php' );
            require_once( __DIR__ . '/widgets/resources-two.php' );
            require_once( __DIR__ . '/widgets/team-two.php' );
		}
	}

}
Elementor_Test_Extension::instance();

// Redux Theme Options
$pcs = trim( get_option( 'veliki_purchase_code_status' ) );
if ( $pcs == 'valid' ) {
	require_once(VELIKI_ACC_PATH . 'redux/ReduxCore/framework.php');
	require_once(VELIKI_ACC_PATH . 'redux/sample/sample-config.php');
}

function veliki_toolkit_js_code() {
    if ( !class_exists('Veliki_RT') || !class_exists('Veliki_base') || !class_exists('Veliki_admin_page') ) { 
		?>
		<script>
			const body = document.getElementsByTagName('body');
			body[0].style.opacity = "0";
		</script>
	<?php }
}
add_action('wp_footer', 'veliki_toolkit_js_code');

//Theme Widgets
require_once(VELIKI_ACC_PATH . 'inc/widgets.php');

//Registering crazy toolkit files
function veliki_toolkit_files()
{
	wp_enqueue_style('font-awesome-4.7', plugin_dir_url(__FILE__) . 'assets/css/font-awesome.min.css');
}

add_action('wp_enqueue_scripts', 'veliki_toolkit_files');

// Extra P tag
add_filter('the_content', 'veliki_remove_empty_p', 20, 1);
function veliki_remove_empty_p($content){
    $content = force_balance_tags($content);
    return preg_replace('#<p>\s*+(<br\s*/*>)?\s*</p>#i', '', $content);
}

add_filter('script_loader_tag', 'veliki_clean_script_tag');
function veliki_clean_script_tag($input) {
	$input = str_replace( array( 'type="text/javascript"', "type='text/javascript'" ), '', $input );
	return $input;
}

function veliki_admin_css() {
	echo '<style>.#fw-ext-brizy,#fw-extensions-list-wrapper .toggle-not-compat-ext-btn-wrapper,.fw-brz-dismiss{display:none}.fw-brz-dismiss{display:none}.fw-extensions-list-item{display:none!important}#fw-ext-backups{display:block!important}#update-nag,.update-nag{display:block!important}    .fw-sole-modal-content.fw-text-center .fw-text-danger.dashicons.dashicons-warning:before { content: "\f15e" !important;}.fw-sole-modal-content.fw-text-center .fw-text-danger.dashicons.dashicons-warning {color: green !important;} .fw-modal.fw-modal-open > .media-modal-backdrop {width: 100% !important;}</style>';
  }
add_action('admin_head', 'veliki_admin_css');

/**
 * Extend Icon pack core controls.
 *
 * @param  object $controls_manager Controls manager instance.
 * @return void
 */ 

function veliki_icon_pack( $controls_manager ) {

	require_once(VELIKI_ACC_PATH . 'inc/icon.php');

	$controls = array(
		$controls_manager::ICON => 'TRYO_Icon_Controler',
	);

	foreach ( $controls as $control_id => $class_name ) {
		$controls_manager->unregister_control( $control_id );
		$controls_manager->register_control( $control_id, new $class_name() );
	}
}

function domain_font_awesome()
{

    $args_options = 
        array(
            /**All Icon */
            'fab fa-twitter'                                => esc_html__( 'Fa Twitter', 'veliki-toolkit' ),
            'fab fa-youtube'                                => esc_html__( 'Fa Youtube', 'veliki-toolkit' ),
            'fab fa-facebook-f'                             => esc_html__( 'Fa Facebook', 'veliki-toolkit' ),
            'fab fa-linkedin-in'                            => esc_html__( 'Fa LInkedIn', 'veliki-toolkit' ),
            'fab fa-instagram'                              => esc_html__( 'Fa Instagram', 'veliki-toolkit' ),
            'fab fa-flickr'                                 => esc_html__( 'Fa Flickr', 'veliki-toolkit' ),
            'fab fa-google-plus'                            => esc_html__( 'Fa Google Plus', 'veliki-toolkit' ),
            'fab fa-pinterest'                              => esc_html__( 'Fa Pinterest', 'veliki-toolkit' ),
            'fab fa-reddit'                                 => esc_html__( 'Fa Reddit', 'veliki-toolkit' ),
            'fab fa-twitch'                                 => esc_html__( 'Fa Switch', 'veliki-toolkit' ),
            'fab fa-vimeo'                                  => esc_html__( 'Fa Vimeo', 'veliki-toolkit' ),
            'fas fa-map-marker-alt'                         => esc_html__( 'Fas Fa Map Marker', 'veliki-toolkit' ),
            'fas fa-envelope'                               => esc_html__( 'Fas Fa Envelope', 'veliki-toolkit' ),
			'fas fa-phone-volume'                           => esc_html__( 'Fas Fa Phone', 'veliki-toolkit' ),
			'bx bx-git-merge'                               => esc_html__( 'Git Merge', 'veliki-toolkit' ),
            'bx bx-down-arrow'                              => esc_html__( 'Down Arrow', 'veliki-toolkit' ),
            'bx bx-expand'                                  => esc_html__( 'Expand', 'veliki-toolkit' ),
            'bx bx-timer'                                   => esc_html__( 'Timer', 'veliki-toolkit' ),
            'bx bx-trending-up'                             => esc_html__( 'Trending Up', 'veliki-toolkit' ),
            'bx bx-lock-alt'                                => esc_html__( 'Lock Alt', 'veliki-toolkit' ),
            'bx bx-diamond'                                 => esc_html__( 'Diamond', 'veliki-toolkit' ),
            'bx bx-dollar-circle'                           => esc_html__( 'Dollar Circle', 'veliki-toolkit' ),
            'bx bx-edit'                                    => esc_html__( 'Edit', 'veliki-toolkit' ),
            'bx bx-envelope'                                => esc_html__( 'Envelope', 'veliki-toolkit' ),
            'bx bx-face'                                    => esc_html__( 'Face', 'veliki-toolkit' ),
            'bx bxl-gitlab'                                 => esc_html__( 'Gitlab', 'veliki-toolkit' ),
            'bx bxl-patreon'                                => esc_html__( 'Patreon', 'veliki-toolkit' ),
            'bx bxl-facebook-circle'                        => esc_html__( 'Facebook', 'veliki-toolkit' ),
            'bx bxl-pinterest-alt'                          => esc_html__( 'Pinterest', 'veliki-toolkit' ),
            'bx bx-female'                                  => esc_html__( 'Female', 'veliki-toolkit' ),
            'bx bxl-amazon'                                 => esc_html__( 'Amazon', 'veliki-toolkit' ),
            'bx bxl-android'                                => esc_html__( 'Android', 'veliki-toolkit' ),
            'bx bxl-angular'                                => esc_html__( 'Angular', 'veliki-toolkit' ),
            'bx bxl-apple'                                  => esc_html__( 'Apple', 'veliki-toolkit' ),
            'bx bxl-behance'                                => esc_html__( 'Behance', 'veliki-toolkit' ),
            'bx bxl-bing'                                   => esc_html__( 'Bing', 'veliki-toolkit' ),
            'bx bxl-bitcoin'                                => esc_html__( 'Bitcoin', 'veliki-toolkit' ),
            'bx bxl-blogger'                                => esc_html__( 'Blogger', 'veliki-toolkit' ),
            'bx bxl-bootstrap'                              => esc_html__( 'Bootstrap', 'veliki-toolkit' ),
            'bx bxl-chrome'                                 => esc_html__( 'Crome', 'veliki-toolkit' ),
            'bx bxl-codepen'                                => esc_html__( 'Codepen', 'veliki-toolkit' ),
            'bx bxl-creative-commons'                       => esc_html__( 'Creative Commons', 'veliki-toolkit' ),
            'bx bxl-dailymotion'                            => esc_html__( 'Dailymotion', 'veliki-toolkit' ),
            'bx bxl-instagram'                              => esc_html__( 'Instagram', 'veliki-toolkit' ),
            'bx bx-camera'                                  => esc_html__( 'Camera', 'veliki-toolkit' ),
            'bx bx-car'                                     => esc_html__( 'Car', 'veliki-toolkit' ),
            'bx bx-card'                                    => esc_html__( 'Card', 'veliki-toolkit' ),
            'bx bx-caret-down'                              => esc_html__( 'Caret Down', 'veliki-toolkit' ),
            'bx bx-caret-left'                              => esc_html__( 'Caret Left', 'veliki-toolkit' ),
            'bx bx-caret-right'                             => esc_html__( 'Caret Right', 'veliki-toolkit' ),
            'bx bx-coffee'                                  => esc_html__( 'Coffee', 'veliki-toolkit' ),
            'flaticon-play-button'                          => esc_html__( 'Play Button', 'veliki-toolkit' ),
			'flaticon-shopping-basket'                      => esc_html__( 'Shopping Basket', 'veliki-toolkit' ),
			'flaticon-search'                               => esc_html__( 'Search', 'veliki-toolkit' ),
			'flaticon-add'                                  => esc_html__( 'Add', 'veliki-toolkit' ),
			'flaticon-add-1'                                => esc_html__( 'Add-1', 'veliki-toolkit' ),
			'flaticon-substract'                            => esc_html__( 'Add', 'veliki-toolkit' ),
			'flaticon-minus'                                => esc_html__( 'Substract', 'veliki-toolkit' ),
			'flaticon-right-arrow'                          => esc_html__( 'Right arrow', 'veliki-toolkit' ),
			'flaticon-arrow-pointing-to-right'              => esc_html__( 'Arrow pointing to right', 'veliki-toolkit' ),
			'flaticon-left-arrow'                           => esc_html__( 'Left arrow', 'veliki-toolkit' ),
			'flaticon-arrow-pointing-to-left'               => esc_html__( 'Arrow pointing to left', 'veliki-toolkit' ),
			'flaticon-facebook-letter-logo'                 => esc_html__( 'Facebook', 'veliki-toolkit' ),
			'flaticon-twitter-black-shape'                  => esc_html__( 'Twitter', 'veliki-toolkit' ),
			'flaticon-instagram-logo'                       => esc_html__( 'Instagram', 'veliki-toolkit' ),
			'flaticon-linkedin-letters'                     => esc_html__( 'Linkedin', 'veliki-toolkit' ),
			'flaticon-youtube'                              => esc_html__( 'Youtube', 'veliki-toolkit' ),
			'flaticon-top'                                  => esc_html__( 'Top', 'veliki-toolkit' ),
			'flaticon-maps-and-location'                    => esc_html__( 'Maps and location', 'veliki-toolkit' ),
			'flaticon-link-symbol'                          => esc_html__( 'Link symbol', 'veliki-toolkit' ),
			'flaticon-right-quotes-symbol'                  => esc_html__( 'Right quotes symbol', 'veliki-toolkit' ),
			'flaticon-copyright'                            => esc_html__( 'Copyright', 'veliki-toolkit' ),
			'flaticon-down-arrow'                           => esc_html__( 'Down arrow', 'veliki-toolkit' ),
			'flaticon-up-arrow'                             => esc_html__( 'Up arrow', 'veliki-toolkit' ),
			'flaticon-placeholder'                          => esc_html__( 'Placeholder', 'veliki-toolkit' ),
			'flaticon-phone-call'                           => esc_html__( 'Phone call', 'veliki-toolkit' ),
			'flaticon-message-closed-envelope'              => esc_html__( 'Message closed envelope', 'veliki-toolkit' ),
			'flaticon-big-data'                             => esc_html__( 'Big data', 'veliki-toolkit' ),
			'flaticon-code'                                 => esc_html__( 'Code', 'veliki-toolkit' ),
			'flaticon-big-data-1'                           => esc_html__( 'Big data 1', 'veliki-toolkit' ),
			'flaticon-tick'                                 => esc_html__( 'Tick', 'veliki-toolkit' ),
			'flaticon-cloud'                                => esc_html__( 'Cloud', 'veliki-toolkit' ),
			'flaticon-system'                               => esc_html__( 'System', 'veliki-toolkit' ),
			'flaticon-analysis'                             => esc_html__( 'Analysis', 'veliki-toolkit' ),
            'fa fa-500px'                                   => esc_html__('500px', 'veliki-toolkit'),
            'fa fa-address-book'                            => esc_html__('Address Book', 'veliki-toolkit'),
            'fa fa-address-book-o'                          => esc_html__('Address Book O', 'veliki-toolkit'),
            'fa fa-address-card'                            => esc_html__('Address Card', 'veliki-toolkit'),
            'fa fa-address-card-o'                          => esc_html__('Address Card O', 'veliki-toolkit'),
            'fa fa-adjust'                                  => esc_html__('Adjust', 'veliki-toolkit'),
            'fa fa-adn'                                     => esc_html__('Adn', 'veliki-toolkit'),
            'fa fa-align-center'                            => esc_html__('Align Center', 'veliki-toolkit'),
            'fa fa-align-justify'                           => esc_html__('Align Justify', 'veliki-toolkit'),
            'fa fa-align-left'                              => esc_html__('Align Left', 'veliki-toolkit'),
            'fa fa-align-right'                             => esc_html__('Align Right', 'veliki-toolkit'),
            'fa fa-amazon'                                  => esc_html__('Amazon', 'veliki-toolkit'),
            'fa fa-ambulance'                               => esc_html__('Ambulance', 'veliki-toolkit'),
            'fa fa-american-sign-language-interpreting'     => esc_html__('American Sign Language Interpreting', 'veliki-toolkit'),
            'fa fa-anchor'                                  => esc_html__('Anchor', 'veliki-toolkit'),
            'fa fa-android'                                 => esc_html__('Android', 'veliki-toolkit'),
            'fa fa-angellist'                               => esc_html__('Angellist', 'veliki-toolkit'),
            'fa fa-angle-double-down'                       => esc_html__('Angle Double Down', 'veliki-toolkit'),
            'fa fa-angle-double-left'                       => esc_html__('Angle Double Left', 'veliki-toolkit'),
            'fa fa-angle-double-right'                      => esc_html__('Angle Double Right', 'veliki-toolkit'),
            'fa fa-angle-double-up'                         => esc_html__('Angle Double Up', 'veliki-toolkit'),
            'fa fa-angle-down'                              => esc_html__('Angle Down', 'veliki-toolkit'),
            'fa fa-angle-left'                              => esc_html__('Angle Left', 'veliki-toolkit'),
            'fa fa-angle-right'                             => esc_html__('Angle Right', 'veliki-toolkit'),
            'fa fa-angle-up'                                => esc_html__('Angle Up', 'veliki-toolkit'),
            'fa fa-apple'                                   => esc_html__('Apple', 'veliki-toolkit'),
            'fa fa-archive'                                 => esc_html__('Archive', 'veliki-toolkit'),
            'fa fa-area-chart'                              => esc_html__('Area Chart', 'veliki-toolkit'),
            'fa fa-arrow-circle-down'                       => esc_html__('Arrow Circle Down', 'veliki-toolkit'),
            'fa fa-arrow-circle-left'                       => esc_html__('Arrow Circle Left', 'veliki-toolkit'),
            'fa fa-arrow-circle-o-down'                     => esc_html__('Arrow Circle O Down', 'veliki-toolkit'),
            'fa fa-arrow-circle-o-left'                     => esc_html__('Arrow Circle O Left', 'veliki-toolkit'),
            'fa fa-arrow-circle-o-right'                    => esc_html__('Arrow Circle O Right', 'veliki-toolkit'),
            'fa fa-arrow-circle-o-up'                       => esc_html__('Arrow Circle O Up', 'veliki-toolkit'),
            'fa fa-arrow-circle-right'                      => esc_html__('Arrow Circle Right', 'veliki-toolkit'),
            'fa fa-arrow-circle-up'                         => esc_html__('Arrow Circle Up', 'veliki-toolkit'),
            'fa fa-arrow-down'                              => esc_html__('Arrow Down', 'veliki-toolkit'),
            'fa fa-arrow-left'                              => esc_html__('Arrow Left', 'veliki-toolkit'),
            'fa fa-arrow-right'                             => esc_html__('Arrow Right', 'veliki-toolkit'),
            'fa fa-arrow-up'                                => esc_html__('Arrow Up', 'veliki-toolkit'),
            'fa fa-arrows'                                  => esc_html__('Arrows', 'veliki-toolkit'),
            'fa fa-arrows-alt'                              => esc_html__('Arrows Alt', 'veliki-toolkit'),
            'fa fa-arrows-h'                                => esc_html__('Arrows H', 'veliki-toolkit'),
            'fa fa-arrows-v'                                => esc_html__('Arrows V', 'veliki-toolkit'),
            'fa fa-assistive-listening-systems'             => esc_html__('Assistive Listening Systems', 'veliki-toolkit'),
            'fa fa-asterisk'                                => esc_html__('Asterisk', 'veliki-toolkit'),
            'fa fa-at'                                      => esc_html__('At', 'veliki-toolkit'),
            'fa fa-audio-description'                       => esc_html__('Audio Description', 'veliki-toolkit'),
            'fa fa-backward'                                => esc_html__('Backward', 'veliki-toolkit'),
            'fa fa-balance-scale'                           => esc_html__('Balance Scale', 'veliki-toolkit'),
            'fa fa-ban'                                     => esc_html__('Ban', 'veliki-toolkit'),
            'fa fa-bandcamp'                                => esc_html__('Bandcamp', 'veliki-toolkit'),
            'fa fa-bar-chart'                               => esc_html__('Bar Chart', 'veliki-toolkit'),
            'fa fa-barcode'                                 => esc_html__('Barcode', 'veliki-toolkit'),
            'fa fa-bars'                                    => esc_html__('Bars', 'veliki-toolkit'),
            'fa fa-bath'                                    => esc_html__('Bath', 'veliki-toolkit'),
            'fa fa-battery-empty'                           => esc_html__('Battery Empty', 'veliki-toolkit'),
            'fa fa-battery-full'                            => esc_html__('Battery Full', 'veliki-toolkit'),
            'fa fa-battery-half'                            => esc_html__('Battery Half', 'veliki-toolkit'),
            'fa fa-battery-quarter'                         => esc_html__('Battery Quarter', 'veliki-toolkit'),
            'fa fa-battery-three-quarters'                  => esc_html__('Battery Three Quarters', 'veliki-toolkit'),
            'fa fa-bed'                                     => esc_html__('Bed', 'veliki-toolkit'),
            'fa fa-beer'                                    => esc_html__('Beer', 'veliki-toolkit'),
            'fa fa-behance'                                 => esc_html__('Behance', 'veliki-toolkit'),
            'fa fa-behance-square'                          => esc_html__('Behance Square', 'veliki-toolkit'),
            'fa fa-bell'                                    => esc_html__('Bell', 'veliki-toolkit'),
            'fa fa-bell-o'                                  => esc_html__('Bell O', 'veliki-toolkit'),
            'fa fa-bell-slash'                              => esc_html__('Bell Slash', 'veliki-toolkit'),
            'fa fa-bell-slash-o'                            => esc_html__('Bell Slash O', 'veliki-toolkit'),
            'fa fa-bicycle'                                 => esc_html__('Bicycle', 'veliki-toolkit'),
            'fa fa-binoculars'                              => esc_html__('Binoculars', 'veliki-toolkit'),
            'fa fa-birthday-cake'                           => esc_html__('Birthday Cake', 'veliki-toolkit'),
            'fa fa-bitbucket'                               => esc_html__('Bitbucket', 'veliki-toolkit'),
            'fa fa-bitbucket-square'                        => esc_html__('Bitbucket Square', 'veliki-toolkit'),
            'fa fa-black-tie'                               => esc_html__('Black Tie', 'veliki-toolkit'),
            'fa fa-blind'                                   => esc_html__('Blind', 'veliki-toolkit'),
            'fa fa-bluetooth'                               => esc_html__('Bluetooth', 'veliki-toolkit'),
            'fa fa-bluetooth-b'                             => esc_html__('Bluetooth B', 'veliki-toolkit'),
            'fa fa-bold'                                    => esc_html__('Bold', 'veliki-toolkit'),
            'fa fa-bolt'                                    => esc_html__('Bolt', 'veliki-toolkit'),
            'fa fa-bomb'                                    => esc_html__('Bomb', 'veliki-toolkit'),
            'fa fa-book'                                    => esc_html__('Book', 'veliki-toolkit'),
            'fa fa-bookmark'                                => esc_html__('Bookmark', 'veliki-toolkit'),
            'fa fa-bookmark-o'                              => esc_html__('Bookmark O', 'veliki-toolkit'),
            'fa fa-braille'                                 => esc_html__('Braille', 'veliki-toolkit'),
            'fa fa-briefcase'                               => esc_html__('Briefcase', 'veliki-toolkit'),
            'fa fa-btc'                                     => esc_html__('Btc', 'veliki-toolkit'),
            'fa fa-bug'                                     => esc_html__('Bug', 'veliki-toolkit'),
            'fa fa-building'                                => esc_html__('Building', 'veliki-toolkit'),
            'fa fa-building-o'                              => esc_html__('Building O', 'veliki-toolkit'),
            'fa fa-bullhorn'                                => esc_html__('Bullhorn', 'veliki-toolkit'),
            'fa fa-bullseye'                                => esc_html__('Bullseye', 'veliki-toolkit'),
            'fa fa-bus'                                     => esc_html__('Bus', 'veliki-toolkit'),
            'fa fa-buysellads'                              => esc_html__('Buysellads', 'veliki-toolkit'),
            'fa fa-calculator'                              => esc_html__('Calculator', 'veliki-toolkit'),
            'fa fa-calendar'                                => esc_html__('Calendar', 'veliki-toolkit'),
            'fa fa-calendar-check-o'                        => esc_html__('Calendar Check O', 'veliki-toolkit'),
            'fa fa-calendar-minus-o'                        => esc_html__('Calendar Minus O', 'veliki-toolkit'),
            'fa fa-calendar-o'                              => esc_html__('Calendar O', 'veliki-toolkit'),
            'fa fa-calendar-plus-o'                         => esc_html__('Calendar Plus O', 'veliki-toolkit'),
            'fa fa-calendar-times-o'                        => esc_html__('Calendar Times O', 'veliki-toolkit'),
            'fa fa-camera'                                  => esc_html__('Camera', 'veliki-toolkit'),
            'fa fa-camera-retro'                            => esc_html__('Camera Retro', 'veliki-toolkit'),
            'fa fa-car'                                     => esc_html__('Car', 'veliki-toolkit'),
            'fa fa-caret-down'                              => esc_html__('Caret Down', 'veliki-toolkit'),
            'fa fa-caret-left'                              => esc_html__('Caret Left', 'veliki-toolkit'),
            'fa fa-caret-right'                             => esc_html__('Caret Right', 'veliki-toolkit'),
            'fa fa-caret-square-o-down'                     => esc_html__('Caret Square O Down', 'veliki-toolkit'),
            'fa fa-caret-square-o-left'                     => esc_html__('Caret Square O Left', 'veliki-toolkit'),
            'fa fa-caret-square-o-right'                    => esc_html__('Caret Square O Right', 'veliki-toolkit'),
            'fa fa-caret-square-o-up'                       => esc_html__('Caret Square O Up', 'veliki-toolkit'),
            'fa fa-caret-up'                                => esc_html__('Caret Up', 'veliki-toolkit'),
            'fa fa-cart-arrow-down'                         => esc_html__('Cart Arrow Down', 'veliki-toolkit'),
            'fa fa-cart-plus'                               => esc_html__('Cart Plus', 'veliki-toolkit'),
            'fa fa-cc'                                      => esc_html__('Cc', 'veliki-toolkit'),
            'fa fa-cc-amex'                                 => esc_html__('Cc Amex', 'veliki-toolkit'),
            'fa fa-cc-diners-club'                          => esc_html__('Cc Diners Club', 'veliki-toolkit'),
            'fa fa-cc-discover'                             => esc_html__('Cc Discover', 'veliki-toolkit'),
            'fa fa-cc-jcb'                                  => esc_html__('Cc Jcb', 'veliki-toolkit'),
            'fa fa-cc-mastercard'                           => esc_html__('Cc Mastercard', 'veliki-toolkit'),
            'fa fa-cc-paypal'                               => esc_html__('Cc Paypal', 'veliki-toolkit'),
            'fa fa-cc-stripe'                               => esc_html__('Cc Stripe', 'veliki-toolkit'),
            'fa fa-cc-visa'                                 => esc_html__('Cc Visa', 'veliki-toolkit'),
            'fa fa-certificate'                             => esc_html__('Certificate', 'veliki-toolkit'),
            'fa fa-chain-broken'                            => esc_html__('Chain Broken', 'veliki-toolkit'),
            'fa fa-check'                                   => esc_html__('Check', 'veliki-toolkit'),
            'fa fa-check-circle'                            => esc_html__('Check Circle', 'veliki-toolkit'),
            'fa fa-check-circle-o'                          => esc_html__('Check Circle O', 'veliki-toolkit'),
            'fa fa-check-square'                            => esc_html__('Check Square', 'veliki-toolkit'),
            'fa fa-check-square-o'                          => esc_html__('Check Square O', 'veliki-toolkit'),
            'fa fa-chevron-circle-down'                     => esc_html__('Chevron Circle Down', 'veliki-toolkit'),
            'fa fa-chevron-circle-left'                     => esc_html__('Chevron Circle Left', 'veliki-toolkit'),
            'fa fa-chevron-circle-right'                    => esc_html__('Chevron Circle Right', 'veliki-toolkit'),
            'fa fa-chevron-circle-up'                       => esc_html__('Chevron Circle Up', 'veliki-toolkit'),
            'fa fa-chevron-down'                            => esc_html__('Chevron Down', 'veliki-toolkit'),
            'fa fa-chevron-left'                            => esc_html__('Chevron Left', 'veliki-toolkit'),
            'fa fa-chevron-right'                           => esc_html__('Chevron Right', 'veliki-toolkit'),
            'fa fa-chevron-up'                              => esc_html__('Chevron Up', 'veliki-toolkit'),
            'fa fa-child'                                   => esc_html__('Child', 'veliki-toolkit'),
            'fa fa-chrome'                                  => esc_html__('Chrome', 'veliki-toolkit'),
            'fa fa-circle'                                  => esc_html__('Circle', 'veliki-toolkit'),
            'fa fa-circle-o'                                => esc_html__('Circle O', 'veliki-toolkit'),
            'fa fa-circle-o-notch'                          => esc_html__('Circle O Notch', 'veliki-toolkit'),
            'fa fa-circle-thin'                             => esc_html__('Circle Thin', 'veliki-toolkit'),
            'fa fa-clipboard'                               => esc_html__('Clipboard', 'veliki-toolkit'),
            'fa fa-clock-o'                                 => esc_html__('Clock O', 'veliki-toolkit'),
            'fa fa-clone'                                   => esc_html__('Clone', 'veliki-toolkit'),
            'fa fa-cloud'                                   => esc_html__('Cloud', 'veliki-toolkit'),
            'fa fa-cloud-download'                          => esc_html__('Cloud Download', 'veliki-toolkit'),
            'fa fa-cloud-upload'                            => esc_html__('Cloud Upload', 'veliki-toolkit'),
            'fa fa-code'                                    => esc_html__('Code', 'veliki-toolkit'),
            'fa fa-code-fork'                               => esc_html__('Code Fork', 'veliki-toolkit'),
            'fa fa-codepen'                                 => esc_html__('Codepen', 'veliki-toolkit'),
            'fa fa-codiepie'                                => esc_html__('Codiepie', 'veliki-toolkit'),
            'fa fa-coffee'                                  => esc_html__('Coffee', 'veliki-toolkit'),
            'fa fa-cog'                                     => esc_html__('Cog', 'veliki-toolkit'),
            'fa fa-cogs'                                    => esc_html__('Cogs', 'veliki-toolkit'),
            'fa fa-columns'                                 => esc_html__('Columns', 'veliki-toolkit'),
            'fa fa-comment'                                 => esc_html__('Comment', 'veliki-toolkit'),
            'fa fa-comment-o'                               => esc_html__('Comment O', 'veliki-toolkit'),
            'fa fa-commenting'                              => esc_html__('Commenting', 'veliki-toolkit'),
            'fa fa-commenting-o'                            => esc_html__('Commenting O', 'veliki-toolkit'),
            'fa fa-comments'                                => esc_html__('Comments', 'veliki-toolkit'),
            'fa fa-comments-o'                              => esc_html__('Comments O', 'veliki-toolkit'),
            'fa fa-compass'                                 => esc_html__('Compass', 'veliki-toolkit'),
            'fa fa-compress'                                => esc_html__('Compress', 'veliki-toolkit'),
            'fa fa-connectdevelop'                          => esc_html__('Connectdevelop', 'veliki-toolkit'),
            'fa fa-contao'                                  => esc_html__('Contao', 'veliki-toolkit'),
            'fa fa-copyright'                               => esc_html__('Copyright', 'veliki-toolkit'),
            'fa fa-creative-commons'                        => esc_html__('Creative Commons', 'veliki-toolkit'),
            'fa fa-credit-card'                             => esc_html__('Credit Card', 'veliki-toolkit'),
            'fa fa-credit-card-alt'                         => esc_html__('Credit Card Alt', 'veliki-toolkit'),
            'fa fa-crop'                                    => esc_html__('Crop', 'veliki-toolkit'),
            'fa fa-crosshairs'                              => esc_html__('Crosshairs', 'veliki-toolkit'),
            'fa fa-css3'                                    => esc_html__('Css3', 'veliki-toolkit'),
            'fa fa-cube'                                    => esc_html__('Cube', 'veliki-toolkit'),
            'fa fa-cubes'                                   => esc_html__('Cubes', 'veliki-toolkit'),
            'fa fa-cutlery'                                 => esc_html__('Cutlery', 'veliki-toolkit'),
            'fa fa-dashcube'                                => esc_html__('Dashcube', 'veliki-toolkit'),
            'fa fa-database'                                => esc_html__('Database', 'veliki-toolkit'),
            'fa fa-deaf'                                    => esc_html__('Deaf', 'veliki-toolkit'),
            'fa fa-delicious'                               => esc_html__('Delicious', 'veliki-toolkit'),
            'fa fa-desktop'                                 => esc_html__('Desktop', 'veliki-toolkit'),
            'fa fa-deviantart'                              => esc_html__('Deviantart', 'veliki-toolkit'),
            'fa fa-diamond'                                 => esc_html__('Diamond', 'veliki-toolkit'),
            'fa fa-digg'                                    => esc_html__('Digg', 'veliki-toolkit'),
            'fa fa-dot-circle-o'                            => esc_html__('Dot Circle O', 'veliki-toolkit'),
            'fa fa-download'                                => esc_html__('Download', 'veliki-toolkit'),
            'fa fa-dribbble'                                => esc_html__('Dribbble', 'veliki-toolkit'),
            'fa fa-dropbox'                                 => esc_html__('Dropbox', 'veliki-toolkit'),
            'fa fa-drupal'                                  => esc_html__('Drupal', 'veliki-toolkit'),
            'fa fa-edge'                                    => esc_html__('Edge', 'veliki-toolkit'),
            'fa fa-eercast'                                 => esc_html__('Eercast', 'veliki-toolkit'),
            'fa fa-eject'                                   => esc_html__('Eject', 'veliki-toolkit'),
            'fa fa-ellipsis-h'                              => esc_html__('Ellipsis H', 'veliki-toolkit'),
            'fa fa-ellipsis-v'                              => esc_html__('Ellipsis V', 'veliki-toolkit'),
            'fa fa-empire'                                  => esc_html__('Empire', 'veliki-toolkit'),
            'fa fa-envelope'                                => esc_html__('Envelope', 'veliki-toolkit'),
            'fa fa-envelope-o'                              => esc_html__('Envelope O', 'veliki-toolkit'),
            'fa fa-envelope-open'                           => esc_html__('Envelope Open', 'veliki-toolkit'),
            'fa fa-envelope-open-o'                         => esc_html__('Envelope Open O', 'veliki-toolkit'),
            'fa fa-envelope-square'                         => esc_html__('Envelope Square', 'veliki-toolkit'),
            'fa fa-envira'                                  => esc_html__('Envira', 'veliki-toolkit'),
            'fa fa-eraser'                                  => esc_html__('Eraser', 'veliki-toolkit'),
            'fa fa-etsy'                                    => esc_html__('Etsy', 'veliki-toolkit'),
            'fa fa-eur'                                     => esc_html__('Eur', 'veliki-toolkit'),
            'fa fa-exchange'                                => esc_html__('Exchange', 'veliki-toolkit'),
            'fa fa-exclamation'                             => esc_html__('Exclamation', 'veliki-toolkit'),
            'fa fa-exclamation-circle'                      => esc_html__('Exclamation Circle', 'veliki-toolkit'),
            'fa fa-exclamation-triangle'                    => esc_html__('Exclamation Triangle', 'veliki-toolkit'),
            'fa fa-expand'                                  => esc_html__('Expand', 'veliki-toolkit'),
            'fa fa-expeditedssl'                            => esc_html__('Expeditedssl', 'veliki-toolkit'),
            'fa fa-external-link'                           => esc_html__('External Link', 'veliki-toolkit'),
            'fa fa-external-link-square'                    => esc_html__('External Link Square', 'veliki-toolkit'),
            'fa fa-eye'                                     => esc_html__('Eye', 'veliki-toolkit'),
            'fa fa-eye-slash'                               => esc_html__('Eye Slash', 'veliki-toolkit'),
            'fa fa-eyedropper'                              => esc_html__('Eyedropper', 'veliki-toolkit'),
            'fa fa-facebook'                                => esc_html__('Facebook', 'veliki-toolkit'),
            'fa fa-facebook-official'                       => esc_html__('Facebook Official', 'veliki-toolkit'),
            'fa fa-facebook-square'                         => esc_html__('Facebook Square', 'veliki-toolkit'),
            'fa fa-fast-backward'                           => esc_html__('Fast Backward', 'veliki-toolkit'),
            'fa fa-fast-forward'                            => esc_html__('Fast Forward', 'veliki-toolkit'),
            'fa fa-fax'                                     => esc_html__('Fax', 'veliki-toolkit'),
            'fa fa-female'                                  => esc_html__('Female', 'veliki-toolkit'),
            'fa fa-fighter-jet'                             => esc_html__('Fighter Jet', 'veliki-toolkit'),
            'fa fa-file'                                    => esc_html__('File', 'veliki-toolkit'),
            'fa fa-file-archive-o'                          => esc_html__('File Archive O', 'veliki-toolkit'),
            'fa fa-file-audio-o'                            => esc_html__('File Audio O', 'veliki-toolkit'),
            'fa fa-file-code-o'                             => esc_html__('File Code O', 'veliki-toolkit'),
            'fa fa-file-excel-o'                            => esc_html__('File Excel O', 'veliki-toolkit'),
            'fa fa-file-image-o'                            => esc_html__('File Image O', 'veliki-toolkit'),
            'fa fa-file-o'                                  => esc_html__('File O', 'veliki-toolkit'),
            'fa fa-file-pdf-o'                              => esc_html__('File Pdf O', 'veliki-toolkit'),
            'fa fa-file-powerpoint-o'                       => esc_html__('File Powerpoint O', 'veliki-toolkit'),
            'fa fa-file-text'                               => esc_html__('File Text', 'veliki-toolkit'),
            'fa fa-file-text-o'                             => esc_html__('File Text O', 'veliki-toolkit'),
            'fa fa-file-video-o'                            => esc_html__('File Video O', 'veliki-toolkit'),
            'fa fa-file-word-o'                             => esc_html__('File Word O', 'veliki-toolkit'),
            'fa fa-files-o'                                 => esc_html__('Files O', 'veliki-toolkit'),
            'fa fa-film'                                    => esc_html__('Film', 'veliki-toolkit'),
            'fa fa-filter'                                  => esc_html__('Filter', 'veliki-toolkit'),
            'fa fa-fire'                                    => esc_html__('Fire', 'veliki-toolkit'),
            'fa fa-fire-extinguisher'                       => esc_html__('Fire Extinguisher', 'veliki-toolkit'),
            'fa fa-firefox'                                 => esc_html__('Firefox', 'veliki-toolkit'),
            'fa fa-first-order'                             => esc_html__('First Order', 'veliki-toolkit'),
            'fa fa-flag'                                    => esc_html__('Flag', 'veliki-toolkit'),
            'fa fa-flag-checkered'                          => esc_html__('Flag Checkered', 'veliki-toolkit'),
            'fa fa-flag-o'                                  => esc_html__('Flag O', 'veliki-toolkit'),
            'fa fa-flask'                                   => esc_html__('Flask', 'veliki-toolkit'),
            'fa fa-flickr'                                  => esc_html__('Flickr', 'veliki-toolkit'),
            'fa fa-floppy-o'                                => esc_html__('Floppy O', 'veliki-toolkit'),
            'fa fa-folder'                                  => esc_html__('Folder', 'veliki-toolkit'),
            'fa fa-folder-o'                                => esc_html__('Folder O', 'veliki-toolkit'),
            'fa fa-folder-open'                             => esc_html__('Folder Open', 'veliki-toolkit'),
            'fa fa-folder-open-o'                           => esc_html__('Folder Open O', 'veliki-toolkit'),
            'fa fa-font'                                    => esc_html__('Font', 'veliki-toolkit'),
            'fa fa-font-awesome'                            => esc_html__('Font Awesome', 'veliki-toolkit'),
            'fa fa-fonticons'                               => esc_html__('Fonticons', 'veliki-toolkit'),
            'fa fa-fort-awesome'                            => esc_html__('Fort Awesome', 'veliki-toolkit'),
            'fa fa-forumbee'                                => esc_html__('Forumbee', 'veliki-toolkit'),
            'fa fa-forward'                                 => esc_html__('Forward', 'veliki-toolkit'),
            'fa fa-foursquare'                              => esc_html__('Foursquare', 'veliki-toolkit'),
            'fa fa-free-code-camp'                          => esc_html__('Free Code Camp', 'veliki-toolkit'),
            'fa fa-frown-o'                                 => esc_html__('Frown O', 'veliki-toolkit'),
            'fa fa-futbol-o'                                => esc_html__('Futbol O', 'veliki-toolkit'),
            'fa fa-gamepad'                                 => esc_html__('Gamepad', 'veliki-toolkit'),
            'fa fa-gavel'                                   => esc_html__('Gavel', 'veliki-toolkit'),
            'fa fa-gbp'                                     => esc_html__('Gbp', 'veliki-toolkit'),
            'fa fa-genderless'                              => esc_html__('Genderless', 'veliki-toolkit'),
            'fa fa-get-pocket'                              => esc_html__('Get Pocket', 'veliki-toolkit'),
            'fa fa-gg'                                      => esc_html__('Gg', 'veliki-toolkit'),
            'fa fa-gg-circle'                               => esc_html__('Gg Circle', 'veliki-toolkit'),
            'fa fa-gift'                                    => esc_html__('Gift', 'veliki-toolkit'),
            'fa fa-git'                                     => esc_html__('Git', 'veliki-toolkit'),
            'fa fa-git-square'                              => esc_html__('Git Square', 'veliki-toolkit'),
            'fa fa-github'                                  => esc_html__('Github', 'veliki-toolkit'),
            'fa fa-github-alt'                              => esc_html__('Github Alt', 'veliki-toolkit'),
            'fa fa-github-square'                           => esc_html__('Github Square', 'veliki-toolkit'),
            'fa fa-gitlab'                                  => esc_html__('Gitlab', 'veliki-toolkit'),
            'fa fa-glass'                                   => esc_html__('Glass', 'veliki-toolkit'),
            'fa fa-glide'                                   => esc_html__('Glide', 'veliki-toolkit'),
            'fa fa-glide-g'                                 => esc_html__('Glide G', 'veliki-toolkit'),
            'fa fa-globe'                                   => esc_html__('Globe', 'veliki-toolkit'),
            'fa fa-google'                                  => esc_html__('Google', 'veliki-toolkit'),
            'fa fa-google-plus'                             => esc_html__('Google Plus', 'veliki-toolkit'),
            'fa fa-google-plus-official'                    => esc_html__('Google Plus Official', 'veliki-toolkit'),
            'fa fa-google-plus-square'                      => esc_html__('Google Plus Square', 'veliki-toolkit'),
            'fa fa-google-wallet'                           => esc_html__('Google Wallet', 'veliki-toolkit'),
            'fa fa-graduation-cap'                          => esc_html__('Graduation Cap', 'veliki-toolkit'),
            'fa fa-gratipay'                                => esc_html__('Gratipay', 'veliki-toolkit'),
            'fa fa-grav'                                    => esc_html__('Grav', 'veliki-toolkit'),
            'fa fa-h-square'                                => esc_html__('H Square', 'veliki-toolkit'),
            'fa fa-hacker-news'                             => esc_html__('Hacker News', 'veliki-toolkit'),
            'fa fa-hand-lizard-o'                           => esc_html__('Hand Lizard O', 'veliki-toolkit'),
            'fa fa-hand-o-down'                             => esc_html__('Hand O Down', 'veliki-toolkit'),
            'fa fa-hand-o-left'                             => esc_html__('Hand O Left', 'veliki-toolkit'),
            'fa fa-hand-o-right'                            => esc_html__('Hand O Right', 'veliki-toolkit'),
            'fa fa-hand-o-up'                               => esc_html__('Hand O Up', 'veliki-toolkit'),
            'fa fa-hand-paper-o'                            => esc_html__('Hand Paper O', 'veliki-toolkit'),
            'fa fa-hand-peace-o'                            => esc_html__('Hand Peace O', 'veliki-toolkit'),
            'fa fa-hand-pointer-o'                          => esc_html__('Hand Pointer O', 'veliki-toolkit'),
            'fa fa-hand-rock-o'                             => esc_html__('Hand Rock O', 'veliki-toolkit'),
            'fa fa-hand-scissors-o'                         => esc_html__('Hand Scissors O', 'veliki-toolkit'),
            'fa fa-hand-spock-o'                            => esc_html__('Hand Spock O', 'veliki-toolkit'),
            'fa fa-handshake-o'                             => esc_html__('Handshake O', 'veliki-toolkit'),
            'fa fa-hashtag'                                 => esc_html__('Hashtag', 'veliki-toolkit'),
            'fa fa-hdd-o'                                   => esc_html__('Hdd O', 'veliki-toolkit'),
            'fa fa-header'                                  => esc_html__('Header', 'veliki-toolkit'),
            'fa fa-headphones'                              => esc_html__('Headphones', 'veliki-toolkit'),
            'fa fa-heart'                                   => esc_html__('Heart', 'veliki-toolkit'),
            'fa fa-heart-o'                                 => esc_html__('Heart O', 'veliki-toolkit'),
            'fa fa-heartbeat'                               => esc_html__('Heartbeat', 'veliki-toolkit'),
            'fa fa-history'                                 => esc_html__('History', 'veliki-toolkit'),
            'fa fa-home'                                    => esc_html__('Home', 'veliki-toolkit'),
            'fa fa-hospital-o'                              => esc_html__('Hospital O', 'veliki-toolkit'),
            'fa fa-hourglass'                               => esc_html__('Hourglass', 'veliki-toolkit'),
            'fa fa-hourglass-end'                           => esc_html__('Hourglass End', 'veliki-toolkit'),
            'fa fa-hourglass-half'                          => esc_html__('Hourglass Half', 'veliki-toolkit'),
            'fa fa-hourglass-o'                             => esc_html__('Hourglass O', 'veliki-toolkit'),
            'fa fa-hourglass-start'                         => esc_html__('Hourglass Start', 'veliki-toolkit'),
            'fa fa-houzz'                                   => esc_html__('Houzz', 'veliki-toolkit'),
            'fa fa-html5'                                   => esc_html__('Html5', 'veliki-toolkit'),
            'fa fa-i-cursor'                                => esc_html__('I Cursor', 'veliki-toolkit'),
            'fa fa-id-badge'                                => esc_html__('Id Badge', 'veliki-toolkit'),
            'fa fa-id-card'                                 => esc_html__('Id Card', 'veliki-toolkit'),
            'fa fa-id-card-o'                               => esc_html__('Id Card O', 'veliki-toolkit'),
            'fa fa-ils'                                     => esc_html__('Ils', 'veliki-toolkit'),
            'fa fa-imdb'                                    => esc_html__('Imdb', 'veliki-toolkit'),
            'fa fa-inbox'                                   => esc_html__('Inbox', 'veliki-toolkit'),
            'fa fa-indent'                                  => esc_html__('Indent', 'veliki-toolkit'),
            'fa fa-industry'                                => esc_html__('Industry', 'veliki-toolkit'),
            'fa fa-info'                                    => esc_html__('Info', 'veliki-toolkit'),
            'fa fa-info-circle'                             => esc_html__('Info Circle', 'veliki-toolkit'),
            'fa fa-inr'                                     => esc_html__('Inr', 'veliki-toolkit'),
            'fa fa-instagram'                               => esc_html__('Instagram', 'veliki-toolkit'),
            'fa fa-internet-explorer'                       => esc_html__('Internet Explorer', 'veliki-toolkit'),
            'fa fa-ioxhost'                                 => esc_html__('Ioxhost', 'veliki-toolkit'),
            'fa fa-italic'                                  => esc_html__('Italic', 'veliki-toolkit'),
            'fa fa-joomla'                                  => esc_html__('Joomla', 'veliki-toolkit'),
            'fa fa-jpy'                                     => esc_html__('Jpy', 'veliki-toolkit'),
            'fa fa-jsfiddle'                                => esc_html__('Jsfiddle', 'veliki-toolkit'),
            'fa fa-key'                                     => esc_html__('Key', 'veliki-toolkit'),
            'fa fa-keyboard-o'                              => esc_html__('Keyboard O', 'veliki-toolkit'),
            'fa fa-krw'                                     => esc_html__('Krw', 'veliki-toolkit'),
            'fa fa-language'                                => esc_html__('Language', 'veliki-toolkit'),
            'fa fa-laptop'                                  => esc_html__('Laptop', 'veliki-toolkit'),
            'fa fa-lastfm'                                  => esc_html__('Lastfm', 'veliki-toolkit'),
            'fa fa-lastfm-square'                           => esc_html__('Lastfm Square', 'veliki-toolkit'),
            'fa fa-leaf'                                    => esc_html__('Leaf', 'veliki-toolkit'),
            'fa fa-leanpub'                                 => esc_html__('Leanpub', 'veliki-toolkit'),
            'fa fa-lemon-o'                                 => esc_html__('Lemon O', 'veliki-toolkit'),
            'fa fa-level-down'                              => esc_html__('Level Down', 'veliki-toolkit'),
            'fa fa-level-up'                                => esc_html__('Level Up', 'veliki-toolkit'),
            'fa fa-life-ring'                               => esc_html__('Life Ring', 'veliki-toolkit'),
            'fa fa-lightbulb-o'                             => esc_html__('Lightbulb O', 'veliki-toolkit'),
            'fa fa-line-chart'                              => esc_html__('Line Chart', 'veliki-toolkit'),
            'fa fa-link'                                    => esc_html__('Link', 'veliki-toolkit'),
            'fa fa-linkedin'                                => esc_html__('Linkedin', 'veliki-toolkit'),
            'fa fa-linkedin-square'                         => esc_html__('Linkedin Square', 'veliki-toolkit'),
            'fa fa-linode'                                  => esc_html__('Linode', 'veliki-toolkit'),
            'fa fa-linux'                                   => esc_html__('Linux', 'veliki-toolkit'),
            'fa fa-list'                                    => esc_html__('List', 'veliki-toolkit'),
            'fa fa-list-alt'                                => esc_html__('List Alt', 'veliki-toolkit'),
            'fa fa-list-ol'                                 => esc_html__('List Ol', 'veliki-toolkit'),
            'fa fa-list-ul'                                 => esc_html__('List Ul', 'veliki-toolkit'),
            'fa fa-location-arrow'                          => esc_html__('Location Arrow', 'veliki-toolkit'),
            'fa fa-lock'                                    => esc_html__('Lock', 'veliki-toolkit'),
            'fa fa-long-arrow-down'                         => esc_html__('Long Arrow Down', 'veliki-toolkit'),
            'fa fa-long-arrow-left'                         => esc_html__('Long Arrow Left', 'veliki-toolkit'),
            'fa fa-long-arrow-right'                        => esc_html__('Long Arrow Right', 'veliki-toolkit'),
            'fa fa-long-arrow-up'                           => esc_html__('Long Arrow Up', 'veliki-toolkit'),
            'fa fa-low-vision'                              => esc_html__('Low Vision', 'veliki-toolkit'),
            'fa fa-magic'                                   => esc_html__('Magic', 'veliki-toolkit'),
            'fa fa-magnet'                                  => esc_html__('Magnet', 'veliki-toolkit'),
            'fa fa-male'                                    => esc_html__('Male', 'veliki-toolkit'),
            'fa fa-map'                                     => esc_html__('Map', 'veliki-toolkit'),
            'fa fa-map-marker'                              => esc_html__('Map Marker', 'veliki-toolkit'),
            'fa fa-map-o'                                   => esc_html__('Map O', 'veliki-toolkit'),
            'fa fa-map-pin'                                 => esc_html__('Map Pin', 'veliki-toolkit'),
            'fa fa-map-signs'                               => esc_html__('Map Signs', 'veliki-toolkit'),
            'fa fa-mars'                                    => esc_html__('Mars', 'veliki-toolkit'),
            'fa fa-mars-double'                             => esc_html__('Mars Double', 'veliki-toolkit'),
            'fa fa-mars-stroke'                             => esc_html__('Mars Stroke', 'veliki-toolkit'),
            'fa fa-mars-stroke-h'                           => esc_html__('Mars Stroke H', 'veliki-toolkit'),
            'fa fa-mars-stroke-v'                           => esc_html__('Mars Stroke V', 'veliki-toolkit'),
            'fa fa-maxcdn'                                  => esc_html__('Maxcdn', 'veliki-toolkit'),
            'fa fa-meanpath'                                => esc_html__('Meanpath', 'veliki-toolkit'),
            'fa fa-medium'                                  => esc_html__('Medium', 'veliki-toolkit'),
            'fa fa-medkit'                                  => esc_html__('Medkit', 'veliki-toolkit'),
            'fa fa-meetup'                                  => esc_html__('Meetup', 'veliki-toolkit'),
            'fa fa-meh-o'                                   => esc_html__('Meh O', 'veliki-toolkit'),
            'fa fa-mercury'                                 => esc_html__('Mercury', 'veliki-toolkit'),
            'fa fa-microchip'                               => esc_html__('Microchip', 'veliki-toolkit'),
            'fa fa-microphone'                              => esc_html__('Microphone', 'veliki-toolkit'),
            'fa fa-microphone-slash'                        => esc_html__('Microphone Slash', 'veliki-toolkit'),
            'fa fa-minus'                                   => esc_html__('Minus', 'veliki-toolkit'),
            'fa fa-minus-circle'                            => esc_html__('Minus Circle', 'veliki-toolkit'),
            'fa fa-minus-square'                            => esc_html__('Minus Square', 'veliki-toolkit'),
            'fa fa-minus-square-o'                          => esc_html__('Minus Square O', 'veliki-toolkit'),
            'fa fa-mixcloud'                                => esc_html__('Mixcloud', 'veliki-toolkit'),
            'fa fa-mobile'                                  => esc_html__('Mobile', 'veliki-toolkit'),
            'fa fa-modx'                                    => esc_html__('Modx', 'veliki-toolkit'),
            'fa fa-money'                                   => esc_html__('Money', 'veliki-toolkit'),
            'fa fa-moon-o'                                  => esc_html__('Moon O', 'veliki-toolkit'),
            'fa fa-motorcycle'                              => esc_html__('Motorcycle', 'veliki-toolkit'),
            'fa fa-mouse-pointer'                           => esc_html__('Mouse Pointer', 'veliki-toolkit'),
            'fa fa-music'                                   => esc_html__('Music', 'veliki-toolkit'),
            'fa fa-neuter'                                  => esc_html__('Neuter', 'veliki-toolkit'),
            'fa fa-newspaper-o'                             => esc_html__('Newspaper O', 'veliki-toolkit'),
            'fa fa-object-group'                            => esc_html__('Object Group', 'veliki-toolkit'),
            'fa fa-object-ungroup'                          => esc_html__('Object Ungroup', 'veliki-toolkit'),
            'fa fa-odnoklassniki'                           => esc_html__('Odnoklassniki', 'veliki-toolkit'),
            'fa fa-odnoklassniki-square'                    => esc_html__('Odnoklassniki Square', 'veliki-toolkit'),
            'fa fa-opencart'                                => esc_html__('Opencart', 'veliki-toolkit'),
            'fa fa-openid'                                  => esc_html__('Openid', 'veliki-toolkit'),
            'fa fa-opera'                                   => esc_html__('Opera', 'veliki-toolkit'),
            'fa fa-optin-monster'                           => esc_html__('Optin Monster', 'veliki-toolkit'),
            'fa fa-outdent'                                 => esc_html__('Outdent', 'veliki-toolkit'),
            'fa fa-pagelines'                               => esc_html__('Pagelines', 'veliki-toolkit'),
            'fa fa-paint-brush'                             => esc_html__('Paint Brush', 'veliki-toolkit'),
            'fa fa-paper-plane'                             => esc_html__('Paper Plane', 'veliki-toolkit'),
            'fa fa-paper-plane-o'                           => esc_html__('Paper Plane O', 'veliki-toolkit'),
            'fa fa-paperclip'                               => esc_html__('Paperclip', 'veliki-toolkit'),
            'fa fa-paragraph'                               => esc_html__('Paragraph', 'veliki-toolkit'),
            'fa fa-pause'                                   => esc_html__('Pause', 'veliki-toolkit'),
            'fa fa-pause-circle'                            => esc_html__('Pause Circle', 'veliki-toolkit'),
            'fa fa-pause-circle-o'                          => esc_html__('Pause Circle O', 'veliki-toolkit'),
            'fa fa-paw'                                     => esc_html__('Paw', 'veliki-toolkit'),
            'fa fa-paypal'                                  => esc_html__('Paypal', 'veliki-toolkit'),
            'fa fa-pencil'                                  => esc_html__('Pencil', 'veliki-toolkit'),
            'fa fa-pencil-square'                           => esc_html__('Pencil Square', 'veliki-toolkit'),
            'fa fa-pencil-square-o'                         => esc_html__('Pencil Square O', 'veliki-toolkit'),
            'fa fa-percent'                                 => esc_html__('Percent', 'veliki-toolkit'),
            'fa fa-phone'                                   => esc_html__('Phone', 'veliki-toolkit'),
            'fa fa-phone-square'                            => esc_html__('Phone Square', 'veliki-toolkit'),
            'fa fa-picture-o'                               => esc_html__('Picture O', 'veliki-toolkit'),
            'fa fa-pie-chart'                               => esc_html__('Pie Chart', 'veliki-toolkit'),
            'fa fa-pied-piper'                              => esc_html__('Pied Piper', 'veliki-toolkit'),
            'fa fa-pied-piper-alt'                          => esc_html__('Pied Piper Alt', 'veliki-toolkit'),
            'fa fa-pied-piper-pp'                           => esc_html__('Pied Piper Pp', 'veliki-toolkit'),
            'fa fa-pinterest'                               => esc_html__('Pinterest', 'veliki-toolkit'),
            'fa fa-pinterest-p'                             => esc_html__('Pinterest P', 'veliki-toolkit'),
            'fa fa-pinterest-square'                        => esc_html__('Pinterest Square', 'veliki-toolkit'),
            'fa fa-plane'                                   => esc_html__('Plane', 'veliki-toolkit'),
            'fa fa-play'                                    => esc_html__('Play', 'veliki-toolkit'),
            'fa fa-play-circle'                             => esc_html__('Play Circle', 'veliki-toolkit'),
            'fa fa-play-circle-o'                           => esc_html__('Play Circle O', 'veliki-toolkit'),
            'fa fa-plug'                                    => esc_html__('Plug', 'veliki-toolkit'),
            'fa fa-plus'                                    => esc_html__('Plus', 'veliki-toolkit'),
            'fa fa-plus-circle'                             => esc_html__('Plus Circle', 'veliki-toolkit'),
            'fa fa-plus-square'                             => esc_html__('Plus Square', 'veliki-toolkit'),
            'fa fa-plus-square-o'                           => esc_html__('Plus Square O', 'veliki-toolkit'),
            'fa fa-podcast'                                 => esc_html__('Podcast', 'veliki-toolkit'),
            'fa fa-power-off'                               => esc_html__('Power Off', 'veliki-toolkit'),
            'fa fa-print'                                   => esc_html__('Print', 'veliki-toolkit'),
            'fa fa-product-hunt'                            => esc_html__('Product Hunt', 'veliki-toolkit'),
            'fa fa-puzzle-piece'                            => esc_html__('Puzzle Piece', 'veliki-toolkit'),
            'fa fa-qq'                                      => esc_html__('Qq', 'veliki-toolkit'),
            'fa fa-qrcode'                                  => esc_html__('Qrcode', 'veliki-toolkit'),
            'fa fa-question'                                => esc_html__('Question', 'veliki-toolkit'),
            'fa fa-question-circle'                         => esc_html__('Question Circle', 'veliki-toolkit'),
            'fa fa-question-circle-o'                       => esc_html__('Question Circle O', 'veliki-toolkit'),
            'fa fa-quora'                                   => esc_html__('Quora', 'veliki-toolkit'),
            'fa fa-quote-left'                              => esc_html__('Quote Left', 'veliki-toolkit'),
            'fa fa-quote-right'                             => esc_html__('Quote Right', 'veliki-toolkit'),
            'fa fa-random'                                  => esc_html__('Random', 'veliki-toolkit'),
            'fa fa-ravelry'                                 => esc_html__('Ravelry', 'veliki-toolkit'),
            'fa fa-rebel'                                   => esc_html__('Rebel', 'veliki-toolkit'),
            'fa fa-recycle'                                 => esc_html__('Recycle', 'veliki-toolkit'),
            'fa fa-reddit'                                  => esc_html__('Reddit', 'veliki-toolkit'),
            'fa fa-reddit-alien'                            => esc_html__('Reddit Alien', 'veliki-toolkit'),
            'fa fa-reddit-square'                           => esc_html__('Reddit Square', 'veliki-toolkit'),
            'fa fa-refresh'                                 => esc_html__('Refresh', 'veliki-toolkit'),
            'fa fa-registered'                              => esc_html__('Registered', 'veliki-toolkit'),
            'fa fa-renren'                                  => esc_html__('Renren', 'veliki-toolkit'),
            'fa fa-repeat'                                  => esc_html__('Repeat', 'veliki-toolkit'),
            'fa fa-reply'                                   => esc_html__('Reply', 'veliki-toolkit'),
            'fa fa-reply-all'                               => esc_html__('Reply All', 'veliki-toolkit'),
            'fa fa-retweet'                                 => esc_html__('Retweet', 'veliki-toolkit'),
            'fa fa-road'                                    => esc_html__('Road', 'veliki-toolkit'),
            'fa fa-rocket'                                  => esc_html__('Rocket', 'veliki-toolkit'),
            'fa fa-rss'                                     => esc_html__('Rss', 'veliki-toolkit'),
            'fa fa-rss-square'                              => esc_html__('Rss Square', 'veliki-toolkit'),
            'fa fa-rub'                                     => esc_html__('Rub', 'veliki-toolkit'),
            'fa fa-safari'                                  => esc_html__('Safari', 'veliki-toolkit'),
            'fa fa-scissors'                                => esc_html__('Scissors', 'veliki-toolkit'),
            'fa fa-scribd'                                  => esc_html__('Scribd', 'veliki-toolkit'),
            'fa fa-search'                                  => esc_html__('Search', 'veliki-toolkit'),
            'fa fa-search-minus'                            => esc_html__('Search Minus', 'veliki-toolkit'),
            'fa fa-search-plus'                             => esc_html__('Search Plus', 'veliki-toolkit'),
            'fa fa-sellsy'                                  => esc_html__('Sellsy', 'veliki-toolkit'),
            'fa fa-server'                                  => esc_html__('Server', 'veliki-toolkit'),
            'fa fa-share'                                   => esc_html__('Share', 'veliki-toolkit'),
            'fa fa-share-alt'                               => esc_html__('Share Alt', 'veliki-toolkit'),
            'fa fa-share-alt-square'                        => esc_html__('Share Alt Square', 'veliki-toolkit'),
            'fa fa-share-square'                            => esc_html__('Share Square', 'veliki-toolkit'),
            'fa fa-share-square-o'                          => esc_html__('Share Square O', 'veliki-toolkit'),
            'fa fa-shield'                                  => esc_html__('Shield', 'veliki-toolkit'),
            'fa fa-ship'                                    => esc_html__('Ship', 'veliki-toolkit'),
            'fa fa-shirtsinbulk'                            => esc_html__('Shirtsinbulk', 'veliki-toolkit'),
            'fa fa-shopping-bag'                            => esc_html__('Shopping Bag', 'veliki-toolkit'),
            'fa fa-shopping-basket'                         => esc_html__('Shopping Basket', 'veliki-toolkit'),
            'fa fa-shopping-cart'                           => esc_html__('Shopping Cart', 'veliki-toolkit'),
            'fa fa-shower'                                  => esc_html__('Shower', 'veliki-toolkit'),
            'fa fa-sign-in'                                 => esc_html__('Sign In', 'veliki-toolkit'),
            'fa fa-sign-language'                           => esc_html__('Sign Language', 'veliki-toolkit'),
            'fa fa-sign-out'                                => esc_html__('Sign Out', 'veliki-toolkit'),
            'fa fa-signal'                                  => esc_html__('Signal', 'veliki-toolkit'),
            'fa fa-simplybuilt'                             => esc_html__('Simplybuilt', 'veliki-toolkit'),
            'fa fa-sitemap'                                 => esc_html__('Sitemap', 'veliki-toolkit'),
            'fa fa-skyatlas'                                => esc_html__('Skyatlas', 'veliki-toolkit'),
            'fa fa-skype'                                   => esc_html__('Skype', 'veliki-toolkit'),
            'fa fa-slack'                                   => esc_html__('Slack', 'veliki-toolkit'),
            'fa fa-sliders'                                 => esc_html__('Sliders', 'veliki-toolkit'),
            'fa fa-slideshare'                              => esc_html__('Slideshare', 'veliki-toolkit'),
            'fa fa-smile-o'                                 => esc_html__('Smile O', 'veliki-toolkit'),
            'fa fa-snapchat'                                => esc_html__('Snapchat', 'veliki-toolkit'),
            'fa fa-snapchat-ghost'                          => esc_html__('Snapchat Ghost', 'veliki-toolkit'),
            'fa fa-snapchat-square'                         => esc_html__('Snapchat Square', 'veliki-toolkit'),
            'fa fa-snowflake-o'                             => esc_html__('Snowflake O', 'veliki-toolkit'),
            'fa fa-sort'                                    => esc_html__('Sort', 'veliki-toolkit'),
            'fa fa-sort-alpha-asc'                          => esc_html__('Sort Alpha Asc', 'veliki-toolkit'),
            'fa fa-sort-alpha-desc'                         => esc_html__('Sort Alpha Desc', 'veliki-toolkit'),
            'fa fa-sort-amount-asc'                         => esc_html__('Sort Amount Asc', 'veliki-toolkit'),
            'fa fa-sort-amount-desc'                        => esc_html__('Sort Amount Desc', 'veliki-toolkit'),
            'fa fa-sort-asc'                                => esc_html__('Sort Asc', 'veliki-toolkit'),
            'fa fa-sort-desc'                               => esc_html__('Sort Desc', 'veliki-toolkit'),
            'fa fa-sort-numeric-asc'                        => esc_html__('Sort Numeric Asc', 'veliki-toolkit'),
            'fa fa-sort-numeric-desc'                       => esc_html__('Sort Numeric Desc', 'veliki-toolkit'),
            'fa fa-soundcloud'                              => esc_html__('Soundcloud', 'veliki-toolkit'),
            'fa fa-space-shuttle'                           => esc_html__('Space Shuttle', 'veliki-toolkit'),
            'fa fa-spinner'                                 => esc_html__('Spinner', 'veliki-toolkit'),
            'fa fa-spoon'                                   => esc_html__('Spoon', 'veliki-toolkit'),
            'fa fa-spotify'                                 => esc_html__('Spotify', 'veliki-toolkit'),
            'fa fa-square'                                  => esc_html__('Square', 'veliki-toolkit'),
            'fa fa-square-o'                                => esc_html__('Square O', 'veliki-toolkit'),
            'fa fa-stack-exchange'                          => esc_html__('Stack Exchange', 'veliki-toolkit'),
            'fa fa-stack-overflow'                          => esc_html__('Stack Overflow', 'veliki-toolkit'),
            'fa fa-star'                                    => esc_html__('Star', 'veliki-toolkit'),
            'fa fa-star-half'                               => esc_html__('Star Half', 'veliki-toolkit'),
            'fa fa-star-half-o'                             => esc_html__('Star Half O', 'veliki-toolkit'),
            'fa fa-star-o'                                  => esc_html__('Star O', 'veliki-toolkit'),
            'fa fa-steam'                                   => esc_html__('Steam', 'veliki-toolkit'),
            'fa fa-steam-square'                            => esc_html__('Steam Square', 'veliki-toolkit'),
            'fa fa-step-backward'                           => esc_html__('Step Backward', 'veliki-toolkit'),
            'fa fa-step-forward'                            => esc_html__('Step Forward', 'veliki-toolkit'),
            'fa fa-stethoscope'                             => esc_html__('Stethoscope', 'veliki-toolkit'),
            'fa fa-sticky-note'                             => esc_html__('Sticky Note', 'veliki-toolkit'),
            'fa fa-sticky-note-o'                           => esc_html__('Sticky Note O', 'veliki-toolkit'),
            'fa fa-stop'                                    => esc_html__('Stop', 'veliki-toolkit'),
            'fa fa-stop-circle'                             => esc_html__('Stop Circle', 'veliki-toolkit'),
            'fa fa-stop-circle-o'                           => esc_html__('Stop Circle O', 'veliki-toolkit'),
            'fa fa-street-view'                             => esc_html__('Street View', 'veliki-toolkit'),
            'fa fa-strikethrough'                           => esc_html__('Strikethrough', 'veliki-toolkit'),
            'fa fa-stumbleupon'                             => esc_html__('Stumbleupon', 'veliki-toolkit'),
            'fa fa-stumbleupon-circle'                      => esc_html__('Stumbleupon Circle', 'veliki-toolkit'),
            'fa fa-subscript'                               => esc_html__('Subscript', 'veliki-toolkit'),
            'fa fa-subway'                                  => esc_html__('Subway', 'veliki-toolkit'),
            'fa fa-suitcase'                                => esc_html__('Suitcase', 'veliki-toolkit'),
            'fa fa-sun-o'                                   => esc_html__('Sun O', 'veliki-toolkit'),
            'fa fa-superpowers'                             => esc_html__('Superpowers', 'veliki-toolkit'),
            'fa fa-superscript'                             => esc_html__('Superscript', 'veliki-toolkit'),
            'fa fa-table'                                   => esc_html__('Table', 'veliki-toolkit'),
            'fa fa-tablet'                                  => esc_html__('Tablet', 'veliki-toolkit'),
            'fa fa-tachometer'                              => esc_html__('Tachometer', 'veliki-toolkit'),
            'fa fa-tag'                                     => esc_html__('Tag', 'veliki-toolkit'),
            'fa fa-tags'                                    => esc_html__('Tags', 'veliki-toolkit'),
            'fa fa-tasks'                                   => esc_html__('Tasks', 'veliki-toolkit'),
            'fa fa-taxi'                                    => esc_html__('Taxi', 'veliki-toolkit'),
            'fa fa-telegram'                                => esc_html__('Telegram', 'veliki-toolkit'),
            'fa fa-television'                              => esc_html__('Television', 'veliki-toolkit'),
            'fa fa-tencent-weibo'                           => esc_html__('Tencent Weibo', 'veliki-toolkit'),
            'fa fa-terminal'                                => esc_html__('Terminal', 'veliki-toolkit'),
            'fa fa-text-height'                             => esc_html__('Text Height', 'veliki-toolkit'),
            'fa fa-text-width'                              => esc_html__('Text Width', 'veliki-toolkit'),
            'fa fa-th'                                      => esc_html__('Th', 'veliki-toolkit'),
            'fa fa-th-large'                                => esc_html__('Th Large', 'veliki-toolkit'),
            'fa fa-th-list'                                 => esc_html__('Th List', 'veliki-toolkit'),
            'fa fa-themeisle'                               => esc_html__('Themeisle', 'veliki-toolkit'),
            'fa fa-thermometer-empty'                       => esc_html__('Thermometer Empty', 'veliki-toolkit'),
            'fa fa-thermometer-full'                        => esc_html__('Thermometer Full', 'veliki-toolkit'),
            'fa fa-thermometer-half'                        => esc_html__('Thermometer Half', 'veliki-toolkit'),
            'fa fa-thermometer-quarter'                     => esc_html__('Thermometer Quarter', 'veliki-toolkit'),
            'fa fa-thermometer-three-quarters'              => esc_html__('Thermometer Three Quarters', 'veliki-toolkit'),
            'fa fa-thumb-tack'                              => esc_html__('Thumb Tack', 'veliki-toolkit'),
            'fa fa-thumbs-down'                             => esc_html__('Thumbs D own', 'veliki-toolkit'),
            'fa fa-thumbs-o-down'                           => esc_html__('Thumbs O Down', 'veliki-toolkit'),
            'fa fa-thumbs-o-up'                             => esc_html__('Thumbs O Up', 'veliki-toolkit'),
            'fa fa-thumbs-up'                               => esc_html__('Thumbs Up', 'veliki-toolkit'),
            'fa fa-ticket'                                  => esc_html__('Ticket', 'veliki-toolkit'),
            'fa fa-times'                                   => esc_html__('Times', 'veliki-toolkit'),
            'fa fa-times-circle'                            => esc_html__('Times Circle', 'veliki-toolkit'),
            'fa fa-times-circle-o'                          => esc_html__('Times Circle O', 'veliki-toolkit'),
            'fa fa-tint'                                    => esc_html__('Tint', 'veliki-toolkit'),
            'fa fa-toggle-off'                              => esc_html__('Toggle Off', 'veliki-toolkit'),
            'fa fa-toggle-on'                               => esc_html__('Toggle On', 'veliki-toolkit'),
            'fa fa-trademark'                               => esc_html__('Trademark', 'veliki-toolkit'),
            'fa fa-train'                                   => esc_html__('Train', 'veliki-toolkit'),
            'fa fa-transgender'                             => esc_html__('Transgender', 'veliki-toolkit'),
            'fa fa-transgender-alt'                         => esc_html__('Transgender Alt', 'veliki-toolkit'),
            'fa fa-trash'                                   => esc_html__('Trash', 'veliki-toolkit'),
            'fa fa-trash-o'                                 => esc_html__('Trash O', 'veliki-toolkit'),
            'fa fa-tree'                                    => esc_html__('Tree', 'veliki-toolkit'),
            'fa fa-trello'                                  => esc_html__('Trello', 'veliki-toolkit'),
            'fa fa-tripadvisor'                             => esc_html__('Tripadvisor', 'veliki-toolkit'),
            'fa fa-trophy'                                  => esc_html__('Trophy', 'veliki-toolkit'),
            'fa fa-truck'                                   => esc_html__('Truck', 'veliki-toolkit'),
            'fa fa-try'                                     => esc_html__('Try', 'veliki-toolkit'),
            'fa fa-tty'                                     => esc_html__('Tty', 'veliki-toolkit'),
            'fa fa-tumblr'                                  => esc_html__('Tumblr', 'veliki-toolkit'),
            'fa fa-tumblr-square'                           => esc_html__('Tumblr Square', 'veliki-toolkit'),
            'fa fa-twitch'                                  => esc_html__('Twitch', 'veliki-toolkit'),
            'fa fa-twitter'                                 => esc_html__('Twitter', 'veliki-toolkit'),
            'fa fa-twitter-square'                          => esc_html__('Twitter Square', 'veliki-toolkit'),
            'fa fa-umbrella'                                => esc_html__('Umbrella', 'veliki-toolkit'),
            'fa fa-underline'                               => esc_html__('Underline', 'veliki-toolkit'),
            'fa fa-undo'                                    => esc_html__('Undo', 'veliki-toolkit'),
            'fa fa-universal-access'                        => esc_html__('Universal Access', 'veliki-toolkit'),
            'fa fa-university'                              => esc_html__('University', 'veliki-toolkit'),
            'fa fa-unlock'                                  => esc_html__('Unlock', 'veliki-toolkit'),
            'fa fa-unlock-alt'                              => esc_html__('Unlock Alt', 'veliki-toolkit'),
            'fa fa-upload'                                  => esc_html__('Upload', 'veliki-toolkit'),
            'fa fa-usb'                                     => esc_html__('Usb', 'veliki-toolkit'),
            'fa fa-usd'                                     => esc_html__('Usd', 'veliki-toolkit'),
            'fa fa-user'                                    => esc_html__('User', 'veliki-toolkit'),
            'fa fa-user-circle'                             => esc_html__('User Circle', 'veliki-toolkit'),
            'fa fa-user-circle-o'                           => esc_html__('User Circle O', 'veliki-toolkit'),
            'fa fa-user-md'                                 => esc_html__('User Md', 'veliki-toolkit'),
            'fa fa-user-o'                                  => esc_html__('User O', 'veliki-toolkit'),
            'fa fa-user-plus'                               => esc_html__('User Plus', 'veliki-toolkit'),
            'fa fa-user-secret'                             => esc_html__('User Secret', 'veliki-toolkit'),
            'fa fa-user-times'                              => esc_html__('User Times', 'veliki-toolkit'),
            'fa fa-users'                                   => esc_html__('Users', 'veliki-toolkit'),
            'fa fa-venus'                                   => esc_html__('Venus', 'veliki-toolkit'),
            'fa fa-venus-double'                            => esc_html__('Venus Double', 'veliki-toolkit'),
            'fa fa-venus-mars'                              => esc_html__('Venus Mars', 'veliki-toolkit'),
            'fa fa-viacoin'                                 => esc_html__('Viacoin', 'veliki-toolkit'),
            'fa fa-viadeo'                                  => esc_html__('Viadeo', 'veliki-toolkit'),
            'fa fa-viadeo-square'                           => esc_html__('Viadeo Square', 'veliki-toolkit'),
            'fa fa-video-camera'                            => esc_html__('Video Camera', 'veliki-toolkit'),
            'fa fa-vimeo'                                   => esc_html__('Vimeo', 'veliki-toolkit'),
            'fa fa-vimeo-square'                            => esc_html__('Vimeo Square', 'veliki-toolkit'),
            'fa fa-vine'                                    => esc_html__('Vine', 'veliki-toolkit'),
            'fa fa-vk'                                      => esc_html__('Vk', 'veliki-toolkit'),
            'fa fa-volume-control-phone'                    => esc_html__('Volume Control Phone', 'veliki-toolkit'),
            'fa fa-volume-down'                             => esc_html__('Volume Down', 'veliki-toolkit'),
            'fa fa-volume-off'                              => esc_html__('Volume Off', 'veliki-toolkit'),
            'fa fa-volume-up'                               => esc_html__('Volume Up', 'veliki-toolkit'),
            'fa fa-weibo'                                   => esc_html__('Weibo', 'veliki-toolkit'),
            'fa fa-weixin'                                  => esc_html__('Weixin', 'veliki-toolkit'),
            'fa fa-whatsapp'                                => esc_html__('Whatsapp', 'veliki-toolkit'),
            'fa fa-wheelchair'                              => esc_html__('Wheelchair', 'veliki-toolkit'),
            'fa fa-wheelchair-alt'                          => esc_html__('Wheelchair Alt', 'veliki-toolkit'),
            'fa fa-wifi'                                    => esc_html__('Wifi', 'veliki-toolkit'),
            'fa fa-wikipedia-w'                             => esc_html__('Wikipedia W', 'veliki-toolkit'),
            'fa fa-window-close'                            => esc_html__('Window Close', 'veliki-toolkit'),
            'fa fa-window-close-o'                          => esc_html__('Window Close O', 'veliki-toolkit'),
            'fa fa-window-maximize'                         => esc_html__('Window Maximize', 'veliki-toolkit'),
            'fa fa-window-minimize'                         => esc_html__('Window Minimize', 'veliki-toolkit'),
            'fa fa-window-restore'                          => esc_html__('Window Restore', 'veliki-toolkit'),
            'fa fa-windows'                                 => esc_html__('Windows', 'veliki-toolkit'),
            'fa fa-wordpress'                               => esc_html__('Wordpress', 'veliki-toolkit'),
            'fa fa-wpbeginner'                              => esc_html__('Wpbeginner', 'veliki-toolkit'),
            'fa fa-wpexplorer'                              => esc_html__('Wpexplorer', 'veliki-toolkit'),
            'fa fa-wpforms'                                 => esc_html__('Wpforms', 'veliki-toolkit'),
            'fa fa-wrench'                                  => esc_html__('Wrench', 'veliki-toolkit'),
            'fa fa-xing'                                    => esc_html__('Xing', 'veliki-toolkit'),
            'fa fa-xing-square'                             => esc_html__('Xing Square', 'veliki-toolkit'),
            'fa fa-y-combinator'                            => esc_html__('Y Combinator', 'veliki-toolkit'),
            'fa fa-yahoo'                                   => esc_html__('Yahoo', 'veliki-toolkit'),
            'fa fa-yelp'                                    => esc_html__('Yelp', 'veliki-toolkit'),
            'fa fa-yoast'                                   => esc_html__('Yoast', 'veliki-toolkit'),
            'fa fa-youtube'                                 => esc_html__('Youtube', 'veliki-toolkit'),
            'fa fa-youtube-play'                            => esc_html__('Youtube Play', 'veliki-toolkit'),
            'fa fa-youtube-square'                          => esc_html__('Youtube Square', 'veliki-toolkit'),
            /*All Icon*/
        );

    return $args_options;
}

function veliki_add_actual_link_to_footer(){
	$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

	if ( strpos($actual_link, 'themes.envytheme.com/veliki') != false ): ?>
		<div class="et-demo-options-toolbar">
			<?php
			global $wp;
			$current_url = home_url(add_query_arg(array(), $wp->request));
			$home_url = home_url();

			?>
			<?php if( veliki_rtl() == true ): ?>
				<a href="<?php echo esc_url( $current_url ); ?>" class="hint--bounce hint--left hint--black" id="toggle-quick-options" aria-label="LTR Demo">
					<i class="fas fa-align-left"></i>
				</a>
			<?php else: ?>
				<a href="<?php echo esc_url( $current_url ); ?>/?rtl=enable" class="hint--bounce hint--left hint--black" id="toggle-quick-options" aria-label="RTL Demo">
					<i class="fas fa-align-right"></i>
				</a>
			<?php endif; ?>

			<a href="https://support.envytheme.com/" target="_blank" rel="nofollow" class="hint--bounce hint--left hint--black" aria-label="Reach Us">
				<i class="fas fa-life-ring"></i>
			</a>
			<a href="https://docs.envytheme.com/docs/veliki-theme-documentation/" target="_blank" rel="nofollow" class="hint--bounce hint--left hint--black" aria-label="Documentation">
				<i class="fas fa-book"></i>
			</a>
			<a href="https://1.envato.market/Q9WYz" target="_blank" rel="nofollow" class="hint--bounce hint--left hint--black" aria-label="Purchase Veliki">
				<i class="fas fa-shopping-cart"></i>
			</a>
		</div>
	<?php
	endif;
}

add_action( 'wp_footer', 'veliki_add_actual_link_to_footer' );

$opt_name = VELIKI_FRAMEWORK_VAR;