<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = VELIKI_FRAMEWORK_VAR;
    

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'opt_name/opt_name', $opt_name );

    /*
     *
     * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
     *
     */

    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();
    
    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme Options', 'veliki-toolkit' ),
        'page_title'           => __( 'Theme Options', 'veliki-toolkit' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => 'kena_option',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );


    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( __( '<p></p>', 'veliki-toolkit' ), $v );
    } else {
        $args['intro_text'] = __( '<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'veliki-toolkit' );
    }

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Theme Information 1', 'veliki-toolkit' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'veliki-toolkit' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => __( 'Theme Information 2', 'veliki-toolkit' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'veliki-toolkit' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'veliki-toolkit' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */

// Preloader Options
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Preloader', 'veliki-toolkit' ),
    'id'               => 'preloader_opt',
    'icon'             => 'dashicons dashicons-controls-repeat',
    'fields'           => array(
        array(
            'id'      => 'enable_preloader',
            'type'    => 'switch',
            'title'   => esc_html__( 'Pre-loader', 'veliki-toolkit' ),
            'on'      => esc_html__( 'Enable', 'veliki-toolkit' ),
            'off'     => esc_html__( 'Disable', 'veliki-toolkit' ),
            'default' => true,
        ),
        array(
            'required' => array( 'enable_preloader', '=', '1' ),
            'id'       => 'preloader_style',
            'type'     => 'select',
            'title'    => esc_html__( 'Pre-loader Style', 'veliki-toolkit' ),
            'default'   => 'circle-spin',
            'options'  => array(
                'circle-spin'   => esc_html__( 'Cube Spin Preloader', 'veliki-toolkit' ),
                'text'          => esc_html__( 'Text Preloader', 'veliki-toolkit' ),
                'image'         => esc_html__( 'Image Preloader', 'veliki-toolkit' )
            )
        ),
        array(
            'title'       => esc_html__( 'Background Color', 'axolot-toolkit' ),
            'id'          => 'preloader_bgcolor',
            'type'        => 'color',
            'default'     => '#074ece',
            'validate'    => 'color',
            'transparent' => false,
            'required' => array( 'preloader_style', '!=', 'image' ),
        ),
        array(
            'title'       => esc_html__( 'Background Color', 'axolot-toolkit' ),
            'id'          => 'preloader_imgbgcolor',
            'type'        => 'color',
            'default'     => '#ffffff',
            'validate'    => 'color',
            'transparent' => false,
            'required' => array( 'preloader_style', '=', 'image' ),
        ),
        array(
            'title'     => esc_html__( 'Cube Background Color', 'veliki-toolkit' ),
            'id'        => 'preloader_color_spin',
            'type'      => 'background',
            'background-image'      => false,
            'background-repeat'     => false,
            'background-size'       => false,
            'background-attachment' => false,
            'background-position'   => false,
            'transparent' => false,
            'output'    => array( '.preloader .sk-folding-cube .sk-cube::before' ),
            'required'  => array( 'preloader_style', '=', 'circle-spin' ),
        ),
        array(
            'title'       => esc_html__( 'Text Color', 'veliki-toolkit' ),
            'id'          => 'preloader_color',
            'type'        => 'color',
            'default'     => '#ffffff',
            'validate'    => 'color',
            'transparent' => false,
            'output'      => array( '.preloader p' ),
            'required'    => array( 'preloader_style', '=', 'text' ),
        ),    
        array(
            'id'       => 'loading_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Loading Text', 'veliki-toolkit' ),
            'default'  => esc_html__( 'Loading', 'veliki-toolkit' ),
            'required' => array( 'preloader_style', '=', 'text' ),
        ),

        array(
            'title'         => esc_html__( 'Loading Text Typography', 'veliki-toolkit' ),
            'id'            => 'preloader_small_typo',
            'type'          => 'typography',
            'text-align'    => false,
            'color'         => false,
            'output'        => '.preloader p',
            'required' => array( 'preloader_style', '=', 'text' ),
        ),

        /**
         * Image Preloader
         */
        array(
            'required' => array( 'preloader_style', '=', 'image' ),
            'id'       => 'preloader_image',
            'type'     => 'media',
            'title'    => esc_html__( 'Pre-loader image', 'veliki-toolkit' ),
            'compiler' => true,
            'default'  => array(
                'url'  => get_template_directory_uri() .'/assets/img/status.gif'
            ),
        ),
    )
));

// -> START General Options
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'General Options', 'veliki-toolkit' ),
    'id'               => 'general_options',
    'customizer' => false,
    'icon'             => ' el el-home',
    'fields'     => array(
        array(
            'id' => 'veliki_enable_rtl',
            'type' => 'select',
            'options' => array(
                'enable'        => 'Enable',
                'disable'       => 'Disable',
            ),
            'title'     => esc_html__( 'RTL', 'veliki-toolkit' ),
            'default'   => 'disable',
        ),

        array(
            'id'        => 'enable_sticky_header',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Sticky Header', 'veliki-toolkit'),
            'desc'      => esc_html__('', 'veliki-toolkit'),
            'default'   => '1'
        ),
        array(
            'id'       => 'coming-soon-date',
            'type'     => 'date',
            'title'    => esc_html__( 'Date Option', 'veliki-toolkit' ),
            'subtitle' => esc_html__('This date option is required only for Coming soon page', 'veliki-toolkit'),
            'desc'     => esc_html__( 'Choose a Date', 'veliki-toolkit' )
        ),
        array(
            'id'       => 'white_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Veliki White Logo', 'veliki-toolkit' ),
        ),
        array(
            'title'     => __( 'White Logo dimensions', 'veliki-toolkit' ),
            'subtitle'  => __( 'Set a custom height width for your upload logo. Recommended size 150X40', 'veliki-toolkit' ),
            'id'        => 'white_logo_dimensions',
            'type'      => 'dimensions',
            'units'     => array( 'em','px','%' ),
            'output'    => '.navbar-brand img, .single-footer-widget .logo img'
        ),
        array(
            'id'       => 'black_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Veliki Black Logo', 'veliki-toolkit' ),
        ),
        array(
            'title'     => __( 'Black Logo dimensions', 'veliki-toolkit' ),
            'subtitle'  => __( 'Set a custom height width for your upload logo. Recommended size 150X40', 'veliki-toolkit' ),
            'id'        => 'black_logo_dimensions',
            'type'      => 'dimensions',
            'units'     => array( 'em','px','%' ),
            'output'    => '.coming-soon-area .coming-soon-content .logo img'
        ),
        array(
            'id'      => 'enable_lazyloader',
            'type'    => 'switch',
            'title'   => esc_html__( 'Lazy Loader', 'veliki-toolkit' ),
            'on'      => esc_html__( 'Enable', 'veliki-toolkit' ),
            'off'     => esc_html__( 'Disable', 'veliki-toolkit' ),
            'default' => false,
        ),
        array(
            'id'      => 'enable_minify_css_js',
            'type'    => 'switch',
            'title'   => esc_html__( 'Minify CSS and JS', 'veliki-toolkit' ),
            'on'      => esc_html__( 'Enable', 'veliki-toolkit' ),
            'off'     => esc_html__( 'Disable', 'veliki-toolkit' ),
            'default' => false,
        ), 
    )
) );

// -> START Pages Options
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Pages Banner Options', 'veliki-toolkit' ),
    'id'               => 'pages_options',
    'customizer' => false,
    'icon'             => ' el el-tasks',
    'fields'     => array(
        array(
            'id'       => 'hide_page_banner',
            'type'     => 'checkbox',
            'title'    => esc_html__( 'Page Banner Hide?', 'veliki-toolkit' ),
        ),
        array(
            'id'       => 'hide_breadcumb',
            'type'     => 'checkbox',
            'title'    => esc_html__( 'Breadcrumb Hide?', 'veliki-toolkit' ),
            'required' => array('hide_page_banner','!=','1'),
        ),  
        array(
            'id'       => 'blog_bg',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Posts Page Banner Background Image', 'veliki-toolkit' ),
            'required' => array('hide_page_banner','!=','1'),
        ),
        array(
            'id'       => 'archive_bg',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Archive Page Banner Background Image', 'veliki-toolkit' ),
            'required' => array('hide_page_banner','!=','1'),
        ),
        array(
            'id'       => 'search_bg',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Search Page Banner Background Image', 'veliki-toolkit' ),
            'required' => array('hide_page_banner','!=','1'),
        ),
        array(
            'id'       => 'page_alignment',
            'type'     => 'radio',
            'title'    => esc_html__( 'Banner Text Alignment', 'veliki-toolkit' ),
            'options'  => array(
                '1' => 'Left', 
                '2' => 'Center', 
                '3' => 'Right'
            ),
            'default' => '1',
            'required' => array('hide_page_banner','!=','1'),
        ),
    ),
) );

// Banner
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'Banner', 'veliki-toolkit' ),
    'id'                => 'banner_options',
    'customizer'        => false,
    'icon'              => 'el el-website',
    'fields'     => array(  
        array(
            'id'        => 'page_title_tag',
            'type'      => 'select',
            'title'     => esc_html__( 'Banner Title Tag', 'veliki-toolkit' ),
            'options' => array(
                'h1'         => esc_html__( 'h1', 'veliki-toolkit' ),
                'h2'         => esc_html__( 'h2', 'veliki-toolkit' ),
                'h3'         => esc_html__( 'h3', 'veliki-toolkit' ),
                'h4'         => esc_html__( 'h4', 'veliki-toolkit' ),
                'h5'         => esc_html__( 'h5', 'veliki-toolkit' ),
                'h6'         => esc_html__( 'h6', 'veliki-toolkit' ),
            ),
            'default' => 'h2',
            'output'    => '.page-title-content h1, .page-title-content h2, .page-title-content h3, .page-title-content h4, .page-title-content h5, .page-title-content h6'
        ),
        array(
            'id'        => 'titlebar_title_typo',
            'type'      => 'typography',
            'text-align'    => false,
            'title'     => esc_html__( 'Title Typography', 'veliki-toolkit' ),
            'output'    => '.page-title-content h1, .page-title-content h2, .page-title-content h3, .page-title-content h4, .page-title-content h5, .page-title-content h6'
        ),
        array(
            'id'        => 'titlebar_desc_typo',
            'type'      => 'typography',
            'text-align'    => false,
            'title'     => esc_html__( 'Breadcumb Typography', 'veliki-toolkit' ),
            'output'    => '.page-title-content p, .page-title-area .woocommerce-breadcrumb, .page-title-area .woocommerce-breadcrumb a, .page-title-content ul li, .page-title-content ul li a'
        ),
        array(
            'title'     => esc_html__( 'Banner Padding', 'veliki-toolkit' ),
            'subtitle'  => esc_html__( 'Padding around the Banner.', 'veliki-toolkit' ),
            'id'        => 'banner_padding',
            'type'      => 'spacing',
            'output'    => array( '.page-title-area' ),
            'mode'      => 'padding',
            'units'     => array( 'em', 'px', '%' ),
            'units_extended' => 'true',
        ), 
    ),
) );


// -> START Top Header
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Top Header', 'veliki-toolkit' ),
    'id'               => 'top_header',
    'customizer'       => false,
    'icon'             => 'el el-website',
    'fields'     => array(
        array(
            'id'       => 'hide_top_header',
            'type'     => 'checkbox',
            'title'    => esc_html__( 'Top Header Hide?', 'veliki-toolkit' ),
        ),
        array(
            'id' => 'address',
            'type' => 'text',
            'title' => esc_html__('Address Text', 'veliki-toolkit'),
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id' => 'address_info',
            'type' => 'text',
            'title' => esc_html__('Address', 'veliki-toolkit'),
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id' => 'call_number_text',
            'type' => 'text',
            'title' => esc_html__('Contact Text', 'veliki-toolkit'),
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id' => 'call_number',
            'type' => 'text',
            'title' => esc_html__('Contact Number', 'veliki-toolkit'),
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id' => 'email_text',
            'type' => 'text',
            'title' => esc_html__('Email Text', 'veliki-toolkit'),
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id' => 'email',
            'type' => 'text',
            'title' => esc_html__('Contact Email', 'veliki-toolkit'),
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id' => 'top_header_bg',
            'type' => 'color',
            'title' => esc_html__('Top Header Background Color', 'veliki-toolkit'),
            'validate' => 'color',
            'transparent' => false,
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id' => 'top_header_textcolor',
            'type' => 'color',
            'title' => esc_html__('Top Header Text Color', 'veliki-toolkit'),
            'default' => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
            'required' => array('hide_top_header','!=','1'),
        ),
        array(
            'id' => 'top_header_iconcolor',
            'type' => 'color',
            'title' => esc_html__('Top Header Icon Color', 'veliki-toolkit'),
            'default' => '#4ac728',
            'validate' => 'color',
            'transparent' => false,
            'required' => array('hide_top_header','!=','1'),
        ),
    )
) );

// -> START Header
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Header', 'veliki-toolkit' ),
    'id'               => 'header',
    'customizer'       => false,
    'icon'             => 'el el-website',
    'fields'     => array(
        array(
            'id' => 'enable_search',
            'type' => 'switch',
            'title' => esc_html__('Enable Search Form', 'veliki-toolkit'),
            'default' => '1'
        ),
        array(
            'id' => 'enable_cart_btn',
            'type' => 'switch',
            'title' => esc_html__('Enable Woocommerce Cart', 'veliki-toolkit'),
            'default' => '1'
        ),
        array(
            'id' => 'enable_header_btn',
            'type' => 'switch',
            'title' => esc_html__('Enable Header Button', 'veliki-toolkit'),
            'default' => '1'
        ),
        array(
            'id' => 'header_btn_text',
            'type' => 'text',
            'title' => esc_html__('Header Button Text', 'veliki-toolkit'),
            'required' => array('enable_header_btn','equals','1'),
            'default' => esc_html__("Start Free Trial", 'veliki-toolkit'),
        ),

        array(
            'id' => 'button_type',
            'type' => 'select',
            'options' => array(
                'link_to_page'        => 'Link To Page',
                'external_link'       => 'External Link',
            ),
            'title'     => esc_html__( 'Choose Header Button Link Type', 'veliki-toolkit' ),
            'default'   => 'link_to_page',
            'required' => array('enable_header_btn','equals','1'),
        ),
        array(
            'id'        => 'button_page_link',
            'type'      => 'select',
            'options'   => veliki_toolkit_get_page_as_list(),
            'title'     => esc_html__( 'Button Link', 'veliki-toolkit' ),
            'required'  => array( 'button_type', '=', 'link_to_page' ),
        ),
        array(
            'id'       => 'button_ex_link',
            'type'     => 'text',
            'title'    => esc_html__( 'Button Link', 'veliki-toolkit' ),
            'required' => array( 'button_type', '=', 'external_link' ),
            'default'  => esc_html__('#', 'veliki-toolkit'),
        ),
        array(
            'id' => 'header_bg',
            'type' => 'color',
            'title' => esc_html__('Header Background Color', 'veliki-toolkit'),
            'validate' => 'color',
            'transparent' => true
        ),
        array(
            'id' => 'nav_item',
            'type' => 'color',
            'title' => esc_html__('Nav Item Color', 'veliki-toolkit'),
            'default' => '#ffffff',
            'validate' => 'color',
            'transparent' => false
        ),
    )
) );

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Sticky Header Gradient Colors', 'veliki-toolkit' ),
    'id'               => 'nav-color-options',
    'customizer_width' => '500px',
    'subsection' => true,
    'desc'     => esc_html__( 'Select all colors for seeing gradient effect. Make sure all colors will be different ', 'veliki-toolkit' ),

    'fields'     => array(
        array(
            'id'          => 'nav_grad_color1',
            'type'        => 'color',
            'title'       => esc_html__('Gradient Color One', 'veliki-toolkit'),
            'default'     => '#0030b8',
            'validate'    => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'nav_grad_color2',
            'type'     => 'color',
            'title'    => esc_html__('Gradient Color Two', 'veliki-toolkit'), 
            'default'     => '#003cc1',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'nav_grad_color3',
            'type'     => 'color',
            'title'    => esc_html__('Gradient Color Three', 'veliki-toolkit'), 
            'default'     => '#0047c9',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'nav_grad_color4',
            'type'     => 'color',
            'title'    => esc_html__('Gradient Color Four', 'veliki-toolkit'), 
            'default'     => '#0152d0',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'nav_grad_color5',
            'type'     => 'color',
            'title'    => esc_html__('Gradient Color Five', 'veliki-toolkit'), 
            'default'     => '#0a5dd8',
            'validate' => 'color',
            'transparent' => false,
        )
    ),
) );

/* Social Profiles */
Redux::setSection( $opt_name, array(
	'title' => esc_html__('Social Profiles', 'veliki-toolkit'),
	'desc' => 'Social profiles are used in different places inside the theme.',
	'icon' => 'el-icon-user',
	'customizer' => false,
	'fields' => array(
        array(
            'id' => 'veliki_social_target',
            'type' => 'select',
            'options' => array(
                '_blank'    => 'Load in a new window. ( _blank )',
                '_self'     => 'Load in the same frame as it was clicked. ( _self )',
            ),
            'title'     => __( 'Social Link Target', 'veliki-toolkit' ),
            'default'   => '_blank',
        ),
        array(
			'id' => 'facebook-url',
			'type' => 'text',
			'title' =>esc_html__('Facebook URL', 'veliki-toolkit')
		),
        array(
			'id' => 'twitter-url',
            'type' => 'text',
			'title' => esc_html__('Twitter URL', 'veliki-toolkit')
        ),
        array(
			'id' => 'instagram-url',
			'type' => 'text',
			'title' => esc_html__('Instagram URL', 'veliki-toolkit')
        ),
        array(
			'id' => 'youtube-url',
			'type' => 'text',
			'title' =>  esc_html__('Youtube URL', 'veliki-toolkit')
		),
        array(
			'id' => 'linkedin-url',
			'type' => 'text',
			'title' => esc_html__('Linkedin URL', 'veliki-toolkit')
        ),
		array(
			'id' => 'pinterest-url',
			'type' => 'text',
			'title' =>esc_html__('Pinterest URL', 'veliki-toolkit')
		),
		array(
			'id' => 'dribbble-url',
			'type' => 'text',
			'title' =>esc_html__('Dribbble URL', 'veliki-toolkit')
		),
		array(
			'id' => 'tumblr-url',
			'type' => 'text',
			'title' =>esc_html__('Tumblr URL', 'veliki-toolkit')
		),
	)
) );

// START Styling 
Redux::setSection( $opt_name, array(
    'title'            =>  esc_html__( 'Styling Options', 'veliki-toolkit' ),
    'id'               => 'styling_options',
    'customizer' => false,
    'icon'             => ' el el-magic',
    'fields'     => array(
        array(
            'id' => 'primary_color',
            'type' => 'color',
            'title' => esc_html__('Primary Color', 'veliki-toolkit'),
            'default' => '#074ece',
            'validate' => 'color',
            'transparent' => false
        ),
        array(
            'id' => 'secondary_color',
            'type' => 'color',
            'title' => esc_html__('Secondary Color', 'veliki-toolkit'),
            'default' => '#4ac728',
            'validate' => 'color',
            'transparent' => false
        ),
        array(
            'id' => 'text_color',
            'type' => 'color',
            'title' => esc_html__('Body Text Color', 'veliki-toolkit'),
            'default' => '#57647c',
            'validate' => 'color',
            'transparent' => false
        ),
        array(
            'id' => 'footer_bg',
            'type' => 'color',
            'title' => esc_html__('Footer Background Color', 'veliki-toolkit'),
            'default' => '#182c51',
            'validate' => 'color',
            'transparent' => false
        ),
        array(
            'id' => 'footer_top_textcolor',
            'type' => 'color',
            'title' => esc_html__('Footer Top Text Color', 'veliki-toolkit'),
            'default' => '#ffffff',
            'validate' => 'color',
            'transparent' => false
        ),
        array(
            'id' => 'footer_top_texthover',
            'type' => 'color',
            'title' => esc_html__('Footer Top Text Hover Color', 'veliki-toolkit'),
            'default' => '#4ac728',
            'validate' => 'color',
            'transparent' => false
        ),
        array(
            'id' => 'footer_bottom_bg',
            'type' => 'color',
            'title' => esc_html__('Footer Bottom Background Color', 'veliki-toolkit'),
            'default' => '#0d1d3b',
            'validate' => 'color',
            'transparent' => false
        ),

        array(
            'id' => 'footer_bottom_textcolor',
            'type' => 'color',
            'title' => esc_html__('Footer Bottom Text Color', 'veliki-toolkit'),
            'default' => '#ffffff',
            'validate' => 'color',
            'transparent' => false
        ),
        array(
            'id' => 'footer_bottom_texthover',
            'type' => 'color',
            'title' => esc_html__('Footer Bottom Text Hover Color', 'veliki-toolkit'),
            'default' => '#4ac728',
            'validate' => 'color',
            'transparent' => false
        ),
    )
) );
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Gradient Colors', 'veliki-toolkit' ),
    'id'               => 'grad-color-options',
    'customizer_width' => '500px',
    'subsection' => true,
    'desc'     => esc_html__( 'Select all colors for seeing gradient effect. Make sure all colors will be different ', 'veliki-toolkit' ),

    'fields'     => array(
        array(
            'id'          => 'grad_color1',
            'type'        => 'color',
            'title'       => esc_html__('Gradient Color One', 'veliki-toolkit'),
            'default'     => '#0030b8',
            'validate'    => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'grad_color2',
            'type'     => 'color',
            'title'    => esc_html__('Gradient Color Two', 'veliki-toolkit'), 
            'default'     => '#003cc1',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'grad_color3',
            'type'     => 'color',
            'title'    => esc_html__('Gradient Color Three', 'veliki-toolkit'), 
            'default'     => '#0047c9',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'grad_color4',
            'type'     => 'color',
            'title'    => esc_html__('Gradient Color Four', 'veliki-toolkit'), 
            'default'     => '#0152d0',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'grad_color5',
            'type'     => 'color',
            'title'    => esc_html__('Gradient Color Five', 'veliki-toolkit'), 
            'default'     => '#0a5dd8',
            'validate' => 'color',
            'transparent' => false,
        )
    )
) );

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Optional Gradient Colors', 'veliki-toolkit' ),
    'id'               => 'opt-grad-color-options',
    'customizer_width' => '500px',
    'subsection' => true,
    'desc'     => esc_html__( 'Select all colors for seeing gradient effect. Make sure all colors will be different ', 'veliki-toolkit' ),

    'fields'     => array(
        array(
            'id'          => 'opt_grad_color1',
            'type'        => 'color',
            'title'       => esc_html__('Optional Gradient Color One', 'veliki-toolkit'),
            'default'     => '#49c628',
            'validate'    => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'opt_grad_color2',
            'type'     => 'color',
            'title'    => esc_html__('Optional Gradient Color Two', 'veliki-toolkit'), 
            'default'     => '#53d23c',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'opt_grad_color3',
            'type'     => 'color',
            'title'    => esc_html__('Optional Gradient Color Three', 'veliki-toolkit'), 
            'default'     => '#5ddd4e',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'opt_grad_color4',
            'type'     => 'color',
            'title'    => esc_html__('Optional Gradient Color Four', 'veliki-toolkit'), 
            'default'     => '#66e95f',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'opt_grad_color5',
            'type'     => 'color',
            'title'    => esc_html__('Optional Gradient Color Five', 'veliki-toolkit'), 
            'default'     => '#70f570',
            'validate' => 'color',
            'transparent' => false,
        )
    ),
) );

// START Blog Area
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Blog', 'veliki-toolkit' ),
    'id'               => 'veliki_blog',
    'customizer' => false,
    'icon'             => 'el el-file-edit',
    'fields' => array(
        array(
            'id'       => 'post_read_more',
            'type'     => 'text',
            'title'    => esc_html__( 'Posts Read More Button Text', 'veliki-toolkit' ),
        ),
        array(
            'id'       => 'blog_title',
            'type'     => 'text',
            'title'    => esc_html__( 'Posts Page Banner Title', 'veliki-toolkit' ),
        ),

        array(
            'id' => 'veliki_blog_layout',
            'type' => 'select',
            'options' => array(
                'container'                 => esc_html__( 'Container', 'veliki-toolkit' ),
                'container-fluid'           => esc_html__( 'Container Fluid', 'veliki-toolkit' ),
            ),
            'title'     => esc_html__( 'Blog Width', 'veliki-toolkit' ),
            'default'   => 'container',
        ),
        array(
            'id' => 'veliki_blog_single_layout',
            'type' => 'select',
            'options' => array(
                'container'                 => esc_html__( 'Container', 'veliki-toolkit' ),
                'container-fluid'           => esc_html__( 'Container Fluid', 'veliki-toolkit' ),
            ),
            'title'     => esc_html__( 'Single Blog Width', 'veliki-toolkit' ),
            'default'   => 'container',
        ),
        array(
            'id' => 'veliki_blog_grid',
            'type' => 'select',
            'options' => array(
                'col-lg-12 col-md-12'       => esc_html__( 'One Column', 'veliki-toolkit' ),
                'col-lg-6 col-md-6'         => esc_html__( 'Two Column', 'veliki-toolkit' ),
                'col-lg-4 col-md-6'         => esc_html__( 'Three Column', 'veliki-toolkit' ),
                'col-lg-3 col-md-6'         => esc_html__( 'Four Column', 'veliki-toolkit' ),
            ),
            'title'     => esc_html__( 'Blog Grid System', 'veliki-toolkit' ),
            'default'   => 'col-lg-12 col-md-12',
        ),

        array(
            'id' => 'blog_sidebar',
            'type' => 'select',
            'options' => array(
                'with_sidebar'              => 'With Sidebar',
                'without_sidebar'           => 'Without Sidebar ( full width )',
                'without_sidebar_center'    => 'Without Sidebar( center )',
            ),
            'title'     => __( 'Blog Sidebar', 'veliki-toolkit' ),
            'default'   => 'with_sidebar',
        ),
        array(
			'title'     => esc_html__( 'Post meta', 'veliki-toolkit' ),
			'subtitle'  => esc_html__( 'Show/hide post meta', 'veliki-toolkit' ),
			'id'        => 'is_post_meta',
			'type'      => 'switch',
            'on'        => esc_html__( 'Show', 'veliki-toolkit' ),
            'off'       => esc_html__( 'Hide', 'veliki-toolkit' ),
            'default'   => '1',
        ),
    ) 
));


// START Footer Area
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Footer', 'veliki-toolkit' ),
    'id'               => 'footer',
    'customizer'       => false,
    'icon'             => 'el el-edit',
    'fields' => array(
        array(
            'id' => 'footer-social-text',
            'type' => 'textarea',
            'title' => esc_html__('Footer social text', 'veliki-toolkit'),
            'default' => esc_html__('Quis ipsum suspendisse ultrices gravida. Risus commodo viverra maecenas accumsan.','veliki-toolkit')
        ),
        array(
            'id' => 'footer-copyright-text',
            'type' => 'editor',
            'title' => esc_html__('Footer copyright text', 'veliki-toolkit'),
            'subtitle' => esc_html__('HTML and Shortcodes are allowed', 'veliki-toolkit'),
            'desc' => '',
            'args' => array(
                'teeny' => true,
                'media_buttons' => false
            ),
        ),

        array(
            'title'     => esc_html__( 'Footer Column', 'veliki-toolkit' ),
            'id'        => 'footer_column',
            'type'      => 'select',
            'default'   => '3',
            'options'   => array(
                '12'    => esc_html__( 'One Column', 'veliki-toolkit' ),
                '6'     => esc_html__( 'Two Column', 'veliki-toolkit' ),
                '4'     => esc_html__( 'Three Column', 'veliki-toolkit' ),
                '3'     => esc_html__( 'Four Column', 'veliki-toolkit' ),
            ),
        ),

        array(
            'id' => 'show_mapimage',
            'type' => 'switch',
            'title' => esc_html__('Show Map image?', 'veliki-toolkit'),
            'default' => '1'
        ),
        array(
            'id'       => 'map_img',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Map', 'veliki-toolkit' ),
            'required' => array('show_mapimage','equals','1'),
        ),


        array(
            'id'    => 'action_url',
            'type'  => 'text',
            'title' => esc_html__( 'Newsletter Action URL', 'veliki-toolkit' ),
            'desc' => __( 'Enter here your MailChimp action URL. <a href="https://www.docs.envytheme.com/docs/veliki-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a>', 'veliki-toolkit' ),
        ),
        array(
            'id' => 'placeholder_text',
            'type' => 'text',
            'title' => esc_html__('Newsletter Placeholder Text', 'veliki-toolkit'),
            'default' => esc_html__('Your email','veliki-toolkit')
        ),
        array(
            'id' => 'news_btn_text',
            'type' => 'text',
            'title' => esc_html__('Newsletter Button Text', 'veliki-toolkit'),
            'default' => esc_html__('Subscribe','veliki-toolkit')
        ),
      
    ) 
));

// WooCommerce Product
Redux::setSection( $opt_name, array(
    'title' => esc_html__( 'WooCommerce Product', 'veliki-toolkit' ),
    'desc'  => esc_html__( 'Manage product page settings.', 'veliki-toolkit' ),
    'icon'  => 'el-icon-list-alt',
    'customizer'    => false,
    'fields' => array(
        array(
            'id'        => 'enable_shop_pages_banner',
            'type'      => 'switch',
            'title'     => esc_html__('Enable WooCommerce Page Banner', 'veliki-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_woo_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('Hide WooCommerce Breadcrumb', 'edali-toolkit'),
            'default'   => '0',
            'required'      => array('enable_shop_pages_banner','equals','1'),
        ),
        array(
            'id'       => 'product_bg_image',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'WooCommerce Page Background Image', 'veliki-toolkit' ),
            'required' => array('enable_shop_pages_banner','equals','1'),
        ),
        array(
            'id'        => 'products_page_count',
            'desc'      => esc_html__( 'Number of products per page on product pages.', 'veliki-toolkit' ),
            'type'      => 'text',
            'title'     => esc_html__( 'Products per page', 'veliki-toolkit' ),
            'default'   => '6',
        ),
        array(
            'id' => 'veliki_product_layout',
            'type' => 'select',
            'options' => array(
                'container'                 => esc_html__( 'Container', 'veliki-toolkit' ),
                'container-fluid'           => esc_html__( 'Container Fluid', 'veliki-toolkit' ),
            ),
            'title'     => esc_html__( 'Product Width', 'veliki-toolkit' ),
            'default'   => 'container',
        ),
        array(
            'id' => 'veliki_single_product_layout',
            'type' => 'select',
            'options' => array(
                'container'                 => esc_html__( 'Container', 'veliki-toolkit' ),
                'container-fluid'           => esc_html__( 'Container Fluid', 'veliki-toolkit' ),
            ),
            'title'     => esc_html__( 'Single Product Width', 'veliki-toolkit' ),
            'default'   => 'container',
        ),
        array(
            'id'    => 'veliki_product_sidebar',
            'type'  => 'select',
            'options' => array(
                'veliki_product_no_sidebar'       => 'None',
                'veliki_product_left_sidebar'     => 'Left',
                'veliki_product_right_sidebar'    => 'Right',
            ),
            'title'     => esc_html__( 'Product Sidebar Position', 'veliki-toolkit' ),
            'default'   => 'veliki_product_no_sidebar',
        ),
        array(
            'id'    => 'veliki_related_product_count',
            'type'  => 'text',
            'title' => esc_html__( 'Product Details Related Product Count', 'veliki-toolkit' ),
            'desc'  => esc_html__( 'e.g. 3', 'veliki-toolkit' ),
            'default' => '3',
        ),
        array(
            'id'       => 'product_details_title',
            'type'     => 'text',
            'title'    => __( 'Product Details Banner Title', 'veliki-toolkit' ),
            'default'  => __( 'Product Details', 'veliki-toolkit' ),
        ),
        array(
            'id'       => 'rel_title',
            'type'     => 'text',
            'title'    => esc_html__( 'Related Products Title', 'veliki-toolkit' ),
            'default'  => esc_html__( 'Related Products', 'veliki-toolkit' ),
        ),
    )
));

// Permalink Settings 
Redux::setSection( $opt_name, array(
    'title'         => esc_html__( 'Custom Posts Permalinks', 'veliki-toolkit' ),
    'id'            => 'veliki_permalink',
    'customizer'    => false,
    'icon'          => 'el el-link',
    'desc'          => 'Manage your custom post permalink settings.',
    'fields' => array(

        array(
            'id'        => 'ser_post_text',
            'type'      => 'text',
            'title'     => __('Services Custom Post URL Text', 'veliki-toolkit'),
            'default'   => __('service', 'veliki-toolkit'),
            'desc'      => '<p>After changing the permalink go to <strong style="color:#28a745;">Settings Permalinks</strong> and hit <strong style="color:#28a745;">Save Changes</strong> button.</p>',
        ),
        array(
            'id'        => 'res_post_text',
            'type'      => 'text',
            'title'     => __('Resource Custom Post URL Text', 'veliki-toolkit'),
            'default'   => __('resource', 'veliki-toolkit'),
            'desc'      => '<p>After changing the permalink go to <strong style="color:#28a745;">Settings Permalinks</strong> and hit <strong style="color:#28a745;">Save Changes</strong> button.</p>',
        ),
    ) 
));

// Typography
Redux::setSection( $opt_name, array(
    'title' => esc_html__( 'Typography', 'veliki-toolkit' ),
    'desc' => esc_html__( 'Manage your fonts and typefaces.', 'veliki-toolkit' ),
    'icon' => 'el-icon-fontsize',
    'customizer'    => false,
    'fields' => array(
        array(
            'id'            => 'opt-typography-body',
            'type'          => 'typography',
            'title'         => esc_html__( 'Body font', 'veliki-toolkit' ),
            'google'        => true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'   => true, // Select a backup non-google font in addition to a google font
            'all_styles'    => false, // Enable all Google Font style/weight variations to be added to the page
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output' => array(
                'body',
            ), // An array of CSS selectors to apply this font style to dynamically
            'subtitle' => esc_html__( 'Typography option with each property can be called individually.', 'veliki-toolkit' ),
            'default' => array(
                'font-family' => 'Open Sans',
                'google' => true,
            ),
        ),
        array(
            'id'            => 'opt-typography-secondary',
            'type'          => 'typography',
            'title'         => esc_html__( 'Secondary font', 'veliki-toolkit' ),
            'google'        => true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'   => true, // Select a backup non-google font in addition to a google font
            'all_styles'    => false, // Enable all Google Font style/weight variations to be added to the page
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output' => array(
                '.h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6, .section-title span, .btn, .learn-more-btn, .evolta-nav .navbar .navbar-nav, .services-details-overview .services-details-desc .features-list, .services-details-overview .services-details-desc .services-details-accordion .accordion .accordion-title, .about-content span, .overview-box .content .features-list, .single-team-box .content span, .resources-details-overview .resources-details-desc .resources-details-accordion .accordion .accordion-title, .single-feedback-item .client-info span, .single-blog-post .post-content .entry-meta li, blockquote, .blockquote, .page-title-content ul, .pagination-area, .blog-sidebar .widget ul li, .faq-accordion .accordion .accordion-title, .faq-contact-form form .form-control, .coming-soon-area .coming-soon-time #timer div, .contact-form form .form-control, #comments .comment-list .comment-body .reply a, .comment-respond label, .comment-respond .form-submit input',
            ), // An array of CSS selectors to apply this font style to dynamically
            'subtitle' => esc_html__( 'Typography option with each property can be called individually.', 'veliki-toolkit' ),
            'default' => array(
                'font-family' => 'Dosis',
                'google' => true,
            ),
        ),
    ),
) );

// Font Size
Redux::setSection( $opt_name, array(
    'title' => __( 'Font Sizes', 'veliki-toolkit' ),
    'desc' => __( 'Manage your body default, header and footer fonts', 'veliki-toolkit' ),
    'icon' => 'el-icon-fontsize',
    'customizer'    => false,
    'fields' => array(
        array(
            'id'            => 'opt-body_fontsize1',
            'type'          => 'typography',
            'title'         => __( 'Body Font Size', 'veliki-toolkit' ),
            'google'        => false, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'   => false, // Select a backup non-google font in addition to a google font
            'all_styles'    => false, // Enable all Google Font style/weight variations to be added to the page
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => true,
            'font-family'   => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output' => array(
                'body',
            ), // An array of CSS selectors to apply this font style to dynamically
            'default' => array(
                'font-size' => '14px',
                'google' => false,
            ),
        ),
        array(
            'id'            => 'opt-header_fontsize1',
            'type'          => 'typography',
            'title'         => __( 'Header Menu Font Size', 'veliki-toolkit' ),
            'google'        => false, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'   => false, // Select a backup non-google font in addition to a google font
            'all_styles'    => false, // Enable all Google Font style/weight variations to be added to the page
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => true,
            'font-family'   => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output' => array(
                '.evolta-nav .navbar .navbar-nav .nav-item a',
            ), // An array of CSS selectors to apply this font style to dynamically
            'default' => array(
                'font-size' => '17px',
                'google' => false,
            ),
        ),
        array(
            'id'            => 'opt-footer_fontsize1',
            'type'          => 'typography',
            'title'         => __( 'Footer Menu Font Size', 'veliki-toolkit' ),
            'google'        => false, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'   => false, // Select a backup non-google font in addition to a google font
            'all_styles'    => false, // Enable all Google Font style/weight variations to be added to the page
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => true,
            'font-family'   => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output' => array(
                '.copyright-area ul li',
            ), // An array of CSS selectors to apply this font style to dynamically
            'default' => array(
                'font-size' => '14px',
                'google' => false,
            ),
        ),
    )
) );

// Advanced Settings
Redux::setSection( $opt_name, array(
	'title'         => esc_html__('Advanced Settings', 'veliki-toolkit'),
    'icon'          => 'el-icon-cogs',
    'customizer'    => false,
	'fields' => array(
		array(
			'id' => 'veliki_css_code',
			'type' => 'ace_editor',
			'title' => esc_html__('Custom CSS Code', 'veliki-toolkit'),
			'desc' => esc_html__('e.g. .btn-primary{ background: #000; } Dont use &lt;style&gt; tags', 'veliki-toolkit'),
			'subtitle' => esc_html__('Paste your CSS code here.', 'veliki-toolkit'),
			'mode' => 'css',
			'theme' => 'monokai'
		),
		array(
			'id'        => 'veliki_js_code',
			'type'      => 'ace_editor',
			'title'     => esc_html__('Custom JS Code', 'veliki-toolkit'),
			'desc'      => esc_html__('e.g. alert("Hello World!"); Dont use&lt;script&gt;tags.', 'veliki-toolkit'),
			'subtitle'  => esc_html__('Paste your JS code here.', 'veliki-toolkit'),
			'mode'      => 'javascript',
			'theme'     => 'monokai'
		)
	)
) );

// -> START 404 Area
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( '404', 'veliki-toolkit' ),
    'id'                => 'veliki_404',
    'customizer'        => false,
    'icon'              => 'el el-question-sign',
    'fields'            => array(
        array(
            'id'        => 'img-404',
            'type'      => 'media',
            'url'       => true,
            'title'     => esc_html__('404 Image Upload', 'veliki-toolkit' ),
            'compiler'  => 'false',
        ),
        array(
            'id'       => 'content_not_found',
            'type'     => 'textarea',
            'title'    => esc_html__( '404 Title', 'veliki-toolkit' ),
            'default'  => esc_html__( 'Page Not Found', 'veliki-toolkit' ),
        ),
        array(
            'id'       => 'long_content_not_found',
            'type'     => 'textarea',
            'title'    => esc_html__( '404 Content', 'veliki-toolkit' ),
        ),
        array(
            'id'       => 'button_not_found',
            'type'     => 'text',
            'title'    => esc_html__( 'Go to Home Button Text', 'veliki-toolkit' ),
            'default'  => esc_html__( 'Go To Home', 'veliki-toolkit' ),
        ),
    ) 
));

      /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */


    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'veliki-toolkit' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'veliki-toolkit' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

    if( !function_exists('veliki_toolkit_js_code') ){
        trigger_error("Hey! Are you trying to heck this theme! Please register Veliki theme!", E_USER_ERROR);
    }